/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.util.java2d;

import de.javasoft.util.java2d.Synthetica2DUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class DropShadow {
    private boolean highQuality = true;
    private BufferedImage shadow = null;
    private BufferedImage originalImage = null;
    private float angle = 45.0f;
    private int distance = -5;
    private int shadowSize = 5;
    private float shadowOpacity = 0.8f;
    private Color shadowColor = new Color(0);
    private int distance_x = 0;
    private int distance_y = 0;

    protected DropShadow() {
        this.computeShadowPosition();
    }

    public DropShadow(BufferedImage image) {
        this();
        this.setImage(image);
    }

    public void setImage(BufferedImage image) {
        this.originalImage = image;
        this.refreshShadow();
    }

    public BufferedImage getImage() {
        return this.originalImage;
    }

    public boolean getHighQuality() {
        return this.highQuality;
    }

    public void setQuality(boolean highQuality) {
        this.highQuality = highQuality;
        this.refreshShadow();
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
        this.computeShadowPosition();
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int distance) {
        this.distance = distance;
        this.computeShadowPosition();
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color shadowColor) {
        this.shadowColor = shadowColor;
        this.refreshShadow();
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public void setShadowOpacity(float shadowOpacity) {
        this.shadowOpacity = shadowOpacity;
        this.refreshShadow();
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public void setShadowSize(int shadowSize) {
        this.shadowSize = shadowSize;
        this.refreshShadow();
    }

    private void refreshShadow() {
        if (this.originalImage != null) {
            this.shadow = this.createDropShadow(this.originalImage);
        }
    }

    private void computeShadowPosition() {
        double angleRadians = Math.toRadians(this.angle);
        this.distance_x = (int)(Math.cos(angleRadians) * (double)this.distance);
        this.distance_y = (int)(Math.sin(angleRadians) * (double)this.distance);
    }

    private BufferedImage createDropShadow(BufferedImage image) {
        BufferedImage bi = new BufferedImage(image.getWidth() + this.shadowSize * 2, image.getHeight() + this.shadowSize * 2, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(image, null, this.shadowSize, this.shadowSize);
        g2.dispose();
        if (this.highQuality) {
            BufferedImage shadowMask = this.createShadowMask(bi);
            Synthetica2DUtils.createBlurOp(this.shadowSize).filter(shadowMask, bi);
        } else {
            this.applyShadow(bi);
        }
        return bi;
    }

    private void applyShadow(BufferedImage image) {
        int a;
        int aSum;
        int dstWidth = image.getWidth();
        int dstHeight = image.getHeight();
        int left = this.shadowSize - 1 >> 1;
        int right = this.shadowSize - left;
        int xStart = left;
        int xStop = dstWidth - right;
        int yStart = left;
        int yStop = dstHeight - right;
        int shadowRgb = this.shadowColor.getRGB() & 0xFFFFFF;
        int[] aHistory = new int[this.shadowSize];
        int historyIdx = 0;
        int[] dataBuffer = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int lastPixelOffset = right * dstWidth;
        float sumDivider = this.shadowOpacity / (float)this.shadowSize;
        int y = 0;
        int bufferOffset = 0;
        while (y < dstHeight) {
            aSum = 0;
            historyIdx = 0;
            int x = 0;
            while (x < this.shadowSize) {
                aHistory[x] = a = dataBuffer[bufferOffset] >>> 24;
                aSum += a;
                ++x;
                ++bufferOffset;
            }
            bufferOffset -= right;
            x = xStart;
            while (x < xStop) {
                a = (int)((float)aSum * sumDivider);
                dataBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dataBuffer[bufferOffset + right] >>> 24;
                aSum += a;
                if (++historyIdx >= this.shadowSize) {
                    historyIdx -= this.shadowSize;
                }
                ++x;
                ++bufferOffset;
            }
            bufferOffset = ++y * dstWidth;
        }
        int x = 0;
        bufferOffset = 0;
        while (x < dstWidth) {
            aSum = 0;
            historyIdx = 0;
            int y2 = 0;
            while (y2 < this.shadowSize) {
                aHistory[y2] = a = dataBuffer[bufferOffset] >>> 24;
                aSum += a;
                ++y2;
                bufferOffset += dstWidth;
            }
            bufferOffset -= lastPixelOffset;
            y2 = yStart;
            while (y2 < yStop) {
                a = (int)((float)aSum * sumDivider);
                dataBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dataBuffer[bufferOffset + lastPixelOffset] >>> 24;
                aSum += a;
                if (++historyIdx >= this.shadowSize) {
                    historyIdx -= this.shadowSize;
                }
                ++y2;
                bufferOffset += dstWidth;
            }
            bufferOffset = ++x;
        }
    }

    private BufferedImage createShadowMask(BufferedImage image) {
        BufferedImage mask = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2d = mask.createGraphics();
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.setComposite(AlphaComposite.getInstance(5, this.shadowOpacity));
        g2d.setColor(this.shadowColor);
        g2d.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2d.dispose();
        return mask;
    }

    public void paintShadow(Graphics g, int x, int y) {
        if (this.shadow != null) {
            g.drawImage(this.shadow, x + this.distance_x, y + this.distance_y, null);
        }
    }

    public void paint(Graphics g, int x, int y) {
        this.paint(g, x, y, true);
    }

    public void paint(Graphics g, int x, int y, boolean paintShadow) {
        if (paintShadow) {
            this.paintShadow(g, x, y);
        }
        if (this.originalImage != null) {
            g.drawImage(this.originalImage, x, y, null);
        }
    }
}

