/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import jigcell.sbml2.Model;
import jigcell.sbml2.SBaseId;
import jigcell.sbml2.UnitDefinition;
import jigcell.sbml2.XMLPrinter;
import org.xml.sax.Attributes;

public final class Compartment
extends SBaseId {
    private boolean constant;
    private double size;
    private int spatialDimensions;
    private String outside;
    private String units;

    public Compartment() {
        this(null, null);
    }

    public Compartment(Compartment compartment) {
        this(compartment.getId(), compartment.isNameSet() ? compartment.getName() : null);
        this.setConstant(compartment.isConstant());
        this.setSize(compartment.getSize());
        this.setSpatialDimensions(compartment.getSpatialDimensions());
        this.setOutside(compartment.getOutside());
        this.setUnits(compartment.getUnits());
    }

    public Compartment(String id, String name) {
        super(id, name);
        this.setConstant(true);
        this.setSize(Double.NaN);
        this.setSpatialDimensions(3);
    }

    public String getOutside() {
        return this.outside;
    }

    public Compartment getOutside(Model model) {
        return (Compartment)model.findElementWithId(this.getOutside(), 1);
    }

    public double getSize() {
        return this.spatialDimensions == 0 ? Double.NaN : this.size;
    }

    public int getSpatialDimensions() {
        return this.spatialDimensions;
    }

    public String getUnits() {
        return this.units == null ? this.getDefaultUnits() : this.units;
    }

    public UnitDefinition getUnits(Model model) {
        return (UnitDefinition)model.findElementWithId(this.getUnits(), 64);
    }

    public boolean isConstant() {
        return this.spatialDimensions == 0 || this.constant;
    }

    @Override
    public boolean isValid(Model model) {
        return super.isValid(model) && UnitDefinition.isValidSpatialSizeUnit(this.getUnits(model), this.getSpatialDimensions()) && this.getOutside(model) != null;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public void setOutside(String outside) {
        this.outside = outside;
    }

    public void setOutside(Compartment compartment) {
        this.setOutside(compartment == null ? null : compartment.getId());
    }

    public void setSize(double size) {
        this.size = size;
    }

    public void setSpatialDimensions(int dimensions) {
        if (this.spatialDimensions < 0 || this.spatialDimensions > 3) {
            throw new IllegalArgumentException("Spatial dimensions must be 0, 1, 2, or 3.");
        }
        this.spatialDimensions = dimensions;
    }

    public void setUnits(String units) {
        if (units != null && !Compartment.isValidId(units)) {
            throw new IllegalArgumentException("Invalid SBML identifier.");
        }
        this.units = units;
    }

    public void setUnits(UnitDefinition units) {
        this.setUnits(units == null ? null : units.getId());
    }

    @Override
    protected void parse(Attributes attributes) {
        super.parse(attributes);
        if (attributes.getIndex("constant") != -1) {
            this.setConstant(Boolean.valueOf(attributes.getValue("constant")) == Boolean.TRUE);
        }
        this.setOutside(attributes.getValue("outside"));
        if (attributes.getIndex("spatialDimensions") != -1) {
            this.setSpatialDimensions(Integer.parseInt(attributes.getValue("spatialDimensions")));
        }
        if (attributes.getIndex("size") != -1) {
            this.setSize(Double.parseDouble(attributes.getValue("size")));
        }
        this.setUnits(attributes.getValue("units"));
    }

    @Override
    protected XMLPrinter print(XMLPrinter parent) {
        return this.print(parent, "compartment");
    }

    @Override
    protected XMLPrinter print(XMLPrinter parent, String name) {
        XMLPrinter printer = super.print(parent, name);
        if (this.getSpatialDimensions() != 3) {
            printer.addAttribute("spatialDimensions", String.valueOf(this.getSpatialDimensions()));
        }
        if (!Double.isNaN(this.getSize())) {
            printer.addAttribute("size", String.valueOf(this.getSize()));
        }
        if (!this.getUnits().equals(this.getDefaultUnits())) {
            printer.addAttribute("units", this.getUnits());
        }
        printer.addAttribute("outside", this.getOutside());
        if (!this.isConstant()) {
            printer.addAttribute("constant", "false");
        }
        return printer;
    }

    private String getDefaultUnits() {
        switch (this.getSpatialDimensions()) {
            case 0: {
                return "dimensionless";
            }
            case 1: {
                return "length";
            }
            case 2: {
                return "area";
            }
            case 3: {
                return "volume";
            }
        }
        throw new IllegalStateException("Spatial dimensions must be 0, 1, 2, or 3.");
    }
}

