/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import jigcell.sbml2.Model;
import jigcell.sbml2.SBMLLevel2Reader;
import jigcell.sbml2.SBase;
import jigcell.sbml2.XMLPrinter;
import org.xml.sax.Attributes;

public final class SBMLLevel2Document
extends SBase {
    private Model model;

    public static SBMLLevel2Document readDocument(InputStream stream) throws IOException {
        return SBMLLevel2Reader.read(new InputStreamReader(stream));
    }

    public static SBMLLevel2Document readDocument(Reader reader) throws IOException {
        return SBMLLevel2Reader.read(reader);
    }

    public static SBMLLevel2Document readDocument(String fileName) throws IOException {
        return SBMLLevel2Reader.read(new BufferedReader(new FileReader(fileName)));
    }

    public SBMLLevel2Document() {
        this(null);
    }

    public SBMLLevel2Document(Model model) {
        this.model = model;
    }

    public int getLevel() {
        return 2;
    }

    public Model getModel() {
        return this.model;
    }

    public int getVersion() {
        return 1;
    }

    @Override
    public boolean isValid(Model model) {
        return super.isValid(model) && this.getModel() != null;
    }

    public void setLevel(int level) {
        if (level != 2) {
            throw new IllegalArgumentException("Level is required to be 2.");
        }
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public void setVersion(int version) {
        if (version != 1) {
            throw new IllegalArgumentException("Version is required to be 1.");
        }
    }

    public void writeDocument(OutputStream stream) throws IOException {
        this.writeDocument(new OutputStreamWriter(stream));
    }

    public void writeDocument(String fileName) throws IOException {
        this.writeDocument(new BufferedWriter(new FileWriter(fileName)));
    }

    public void writeDocument(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.print(null).write(writer);
        writer.close();
    }

    @Override
    protected void parse(Attributes attributes) {
        super.parse(attributes);
        this.setLevel(Integer.parseInt(attributes.getValue("level")));
        this.setVersion(Integer.parseInt(attributes.getValue("version")));
    }

    @Override
    protected XMLPrinter print(XMLPrinter parent) {
        return this.print(parent, "sbml");
    }

    @Override
    protected XMLPrinter print(XMLPrinter parent, String name) {
        XMLPrinter printer = super.print(parent, name);
        printer.addAttribute("xmlns", "http://www.sbml.org/sbml/level2");
        printer.addAttribute("xmlns:html", "http://www.w3.org/1999/xhtml");
        printer.addAttribute("xmlns:jigcell", "http://www.sbml.org/2001/ns/jigcell");
        printer.addAttribute("xmlns:math", "http://www.w3.org/1998/Math/MathML");
        printer.addAttribute("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        printer.addAttribute("xmlns:sbml", "http://www.sbml.org/sbml/level2");
        printer.addAttribute("level", String.valueOf(this.getLevel()));
        printer.addAttribute("version", String.valueOf(this.getVersion()));
        printer.addElement(this.getModel());
        return printer;
    }
}

