/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jigcell.sbml2.SBase;
import jigcell.sbml2.XMLPrinter;
import org.xml.sax.Attributes;

public final class Unit
extends SBase {
    private static final Map baseUnits = new HashMap();
    private double multiplier;
    private double offset;
    private int exponent;
    private int scale;
    private String name;
    private Unit kind = this;

    public static Unit findBaseUnit(String name) {
        return (Unit)baseUnits.get(name);
    }

    public static Set getBaseUnits() {
        return new HashSet(baseUnits.values());
    }

    private static void addBaseUnit(String name) {
        baseUnits.put(name, new Unit(name));
    }

    public Unit(Unit unit) {
        this(unit.getKind(), unit.getMultiplier(), unit.getScale(), unit.getExponent(), unit.getOffset());
    }

    public Unit(Unit kind, double multiplier, int scale, int exponent, double offset) {
        this();
        this.setKind(kind);
        this.setMultiplier(multiplier);
        this.setScale(scale);
        this.setExponent(exponent);
        this.setOffset(offset);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Unit)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Unit unit = (Unit)o;
        return this.getKindName().equals(unit.getKindName()) && this.getMultiplier() == unit.getMultiplier() && this.getScale() == unit.getScale() && this.getExponent() == unit.getExponent() && this.getOffset() == unit.getOffset();
    }

    public int getExponent() {
        return this.exponent;
    }

    public Unit getKind() {
        return this.isBaseUnit() ? this : this.kind;
    }

    public String getKindName() {
        return this.isBaseUnit() ? this.name : this.kind.getKindName();
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public double getOffset() {
        return this.offset;
    }

    public int getScale() {
        return this.scale;
    }

    public int hashCode() {
        int sum = this.getKindName().hashCode();
        long multiplierBits = Double.doubleToLongBits(this.getMultiplier());
        sum += (int)(multiplierBits ^ multiplierBits >>> 32);
        sum += this.getScale();
        long offsetBits = Double.doubleToLongBits(this.getOffset());
        return (sum += this.getExponent() << 16) + (int)(offsetBits ^ offsetBits >>> 32);
    }

    public boolean isBaseUnit() {
        return this.kind == null;
    }

    public void setExponent(int exponent) {
        if (this.isBaseUnit()) {
            throw new UnsupportedOperationException("Base units cannot be modified.");
        }
        this.exponent = exponent;
    }

    public void setKind(Unit kind) {
        if (this.isBaseUnit()) {
            throw new UnsupportedOperationException("Base units cannot be modified.");
        }
        if (kind == null) {
            throw new IllegalArgumentException("Must specify a unit kind");
        }
        if (!kind.isBaseUnit()) {
            throw new IllegalArgumentException("Units cannot be derived from a user defined unit");
        }
        this.kind = kind;
    }

    public void setMultiplier(double multiplier) {
        if (this.isBaseUnit()) {
            throw new UnsupportedOperationException("Base units cannot be modified.");
        }
        this.multiplier = multiplier;
    }

    public void setOffset(double offset) {
        if (this.isBaseUnit()) {
            throw new UnsupportedOperationException("Base units cannot be modified.");
        }
        this.offset = offset;
    }

    public void setScale(int scale) {
        if (this.isBaseUnit()) {
            throw new UnsupportedOperationException("Base units cannot be modified.");
        }
        this.scale = scale;
    }

    Unit() {
        this.setMultiplier(1.0);
        this.setScale(0);
        this.setExponent(1);
        this.setOffset(0.0);
    }

    Unit(String name) {
        this();
        this.name = name;
        this.kind = null;
    }

    @Override
    protected void parse(Attributes attributes) {
        super.parse(attributes);
        if (attributes.getIndex("exponent") != -1) {
            this.setExponent(Integer.parseInt(attributes.getValue("exponent")));
        }
        this.setKind(Unit.findBaseUnit(attributes.getValue("kind")));
        if (attributes.getIndex("multiplier") != -1) {
            this.setMultiplier(Double.parseDouble(attributes.getValue("multiplier")));
        }
        if (attributes.getIndex("offset") != -1) {
            this.setOffset(Double.parseDouble(attributes.getValue("offset")));
        }
        if (attributes.getIndex("scale") != -1) {
            this.setScale(Integer.parseInt(attributes.getValue("scale")));
        }
    }

    @Override
    protected XMLPrinter print(XMLPrinter parent) {
        return this.print(parent, "unit");
    }

    @Override
    protected XMLPrinter print(XMLPrinter parent, String name) {
        XMLPrinter printer = super.print(parent, name);
        printer.addAttribute("kind", this.getKindName());
        if (this.getExponent() != 1) {
            printer.addAttribute("exponent", String.valueOf(this.getExponent()));
        }
        if (this.getScale() != 0) {
            printer.addAttribute("scale", String.valueOf(this.getScale()));
        }
        if (this.getMultiplier() != 1.0) {
            printer.addAttribute("multiplier", String.valueOf(this.getMultiplier()));
        }
        if (this.getOffset() != 0.0) {
            printer.addAttribute("offset", String.valueOf(this.getOffset()));
        }
        return printer;
    }

    static {
        Unit.addBaseUnit("ampere");
        Unit.addBaseUnit("becquerel");
        Unit.addBaseUnit("candela");
        Unit.addBaseUnit("Celsius");
        Unit.addBaseUnit("coulomb");
        Unit.addBaseUnit("dimensionless");
        Unit.addBaseUnit("farad");
        Unit.addBaseUnit("gram");
        Unit.addBaseUnit("gray");
        Unit.addBaseUnit("henry");
        Unit.addBaseUnit("hertz");
        Unit.addBaseUnit("item");
        Unit.addBaseUnit("joule");
        Unit.addBaseUnit("katal");
        Unit.addBaseUnit("kelvin");
        Unit.addBaseUnit("kilogram");
        Unit.addBaseUnit("litre");
        Unit.addBaseUnit("lumen");
        Unit.addBaseUnit("lux");
        Unit.addBaseUnit("metre");
        Unit.addBaseUnit("mole");
        Unit.addBaseUnit("newton");
        Unit.addBaseUnit("ohm");
        Unit.addBaseUnit("pascal");
        Unit.addBaseUnit("radian");
        Unit.addBaseUnit("second");
        Unit.addBaseUnit("siemens");
        Unit.addBaseUnit("sievert");
        Unit.addBaseUnit("steradian");
        Unit.addBaseUnit("tesla");
        Unit.addBaseUnit("volt");
        Unit.addBaseUnit("watt");
        Unit.addBaseUnit("weber");
    }
}

