/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jigcell.sbml2.XMLElement;

public final class XMLPrinter {
    private final List elements;
    private final Map attributes;
    private final String indent;
    private final String name;
    private String text;

    public static String quote(String cdata) {
        if (cdata == null) {
            return null;
        }
        cdata = cdata.replaceAll("&", "&amp;");
        cdata = cdata.replaceAll("<", "&lt;");
        cdata = cdata.replaceAll(">", "&gt;");
        cdata = cdata.replaceAll("\"", "&quot;");
        return cdata.replaceAll("'", "&apos;");
    }

    public XMLPrinter(String name) {
        this(null, name);
    }

    public XMLPrinter(XMLPrinter parent, String name) {
        this.name = name;
        this.indent = parent == null ? "" : parent.indent + "  ";
        this.attributes = new LinkedHashMap();
        this.elements = new ArrayList();
    }

    public void addAttribute(String attribute, String value) {
        if (value != null && value.length() > 0) {
            this.attributes.put(attribute, value);
        }
    }

    public void addCustomElement(XMLElement element, String name, String cdata) {
        XMLPrinter elementPrinter = element.print(this, name);
        elementPrinter.addText(cdata);
        this.elements.add(elementPrinter);
    }

    public void addElement(XMLElement element) {
        if (element != null) {
            this.elements.add(element.print(this));
        }
    }

    public void addElementList(XMLElement element, String name, Collection collection) {
        if (collection.isEmpty()) {
            return;
        }
        XMLPrinter elementPrinter = element.print(this, name);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            elementPrinter.addElement((XMLElement)iterator.next());
        }
        this.elements.add(elementPrinter);
    }

    public void addText(String cdata) {
        if (cdata != null) {
            this.text = this.text == null ? cdata : this.text + cdata;
        }
    }

    public String toString() {
        return this.toString(new StringBuffer());
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.indent + "<" + this.name);
        for (Map.Entry entry : this.attributes.entrySet()) {
            writer.write(" " + (String)entry.getKey() + "=\"" + XMLPrinter.quote((String)entry.getValue()) + "\"");
        }
        if (this.text == null && this.elements.isEmpty()) {
            writer.write(" />\n");
            return;
        }
        writer.write(">\n");
        if (this.text != null) {
            writer.write(this.text);
            if (!this.text.endsWith("\n")) {
                writer.write("\n");
            }
        }
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            ((XMLPrinter)((Object)iterator.next())).write(writer);
        }
        writer.write(this.indent + "</" + this.name + ">\n");
    }

    private String toString(StringBuffer xml) {
        xml.append(this.indent + "<" + this.name);
        for (Map.Entry entry : this.attributes.entrySet()) {
            xml.append(" " + (String)entry.getKey() + "=\"" + XMLPrinter.quote((String)entry.getValue()) + "\"");
        }
        if (this.text == null && this.elements.isEmpty()) {
            return xml.append(" />\n").toString();
        }
        xml.append(">\n");
        if (this.text != null) {
            xml.append(this.text);
            if (!this.text.endsWith("\n")) {
                xml.append("\n");
            }
        }
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            ((XMLPrinter)((Object)iterator.next())).toString(xml);
        }
        return xml.append(this.indent + "</" + this.name + ">\n").toString();
    }
}

