/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2.jep;

import java.util.Stack;
import java.util.Vector;
import jigcell.sbml2.jep.ASTConstant;
import jigcell.sbml2.jep.ASTElse;
import jigcell.sbml2.jep.ASTElseIfThen;
import jigcell.sbml2.jep.ASTFunNode;
import jigcell.sbml2.jep.ASTIfThen;
import jigcell.sbml2.jep.ASTPiecewise;
import jigcell.sbml2.jep.ASTStart;
import jigcell.sbml2.jep.ASTVarNode;
import jigcell.sbml2.jep.Node;
import jigcell.sbml2.jep.ParserVisitor;
import jigcell.sbml2.jep.SimpleNode;
import jigcell.sbml2.jep.function.PostfixMathCommandI;

public class EvaluatorVisitor
implements ParserVisitor {
    private static final boolean debug = false;
    private boolean errorFlag;
    private Stack stack = new Stack();
    private Vector errorList = null;

    public Object getValue(Node topNode, Vector errorList_in) throws Exception {
        if (topNode == null) {
            throw new IllegalArgumentException("topNode parameter is null");
        }
        this.errorList = errorList_in;
        this.errorFlag = false;
        topNode.jjtAccept(this, null);
        if (this.errorFlag || this.stack.size() != 1) {
            throw new Exception("EvaluatorVisitor.getValue(): Error during evaluation");
        }
        return this.stack.pop();
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTStart node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTFunNode node, Object data) {
        if (node == null) {
            return null;
        }
        data = node.childrenAccept(this, data);
        PostfixMathCommandI pfmc = node.getPFMC();
        if (pfmc == null) {
            this.addToErrorList("No function class associated with " + node.getName());
            return data;
        }
        if (pfmc.getNumberOfParameters() == -1) {
            pfmc.setCurNumberOfParameters(node.jjtGetNumChildren());
        }
        try {
            pfmc.run(this.stack);
        }
        catch (Exception e) {
            this.addToErrorList(e.getMessage());
            this.errorFlag = true;
        }
        return data;
    }

    @Override
    public Object visit(ASTVarNode node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTConstant node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTIfThen node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTElse node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTPiecewise node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTElseIfThen node, Object data) {
        return data;
    }

    private void addToErrorList(String errorStr) {
        if (this.errorList != null) {
            this.errorList.addElement(errorStr);
        }
    }
}

