/*
 * Decompiled with CFR 0.152.
 */
package org.compbiollab.datavisualization;

import cern.colt.matrix.DoubleMatrix2D;
import com.tlabs.dcolt.DecoratedDoubleMatrix2D;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.compbiollab.datavisualization.BlotPanel;
import org.enfin.squad.dl.TabSeparatedDataFile;

public class VirtualBlot
extends JFrame {
    private static final long serialVersionUID = 1L;
    JScrollPane scrollPane;
    JComboBox combScale;
    BlotPanel blotPanel;
    DoubleMatrix2D allData;

    public VirtualBlot(DecoratedDoubleMatrix2D dt) throws IOException {
        super("VirtualBlot");
        this.setSize(600, 400);
        this.setDefaultCloseOperation(2);
        this.allData = dt;
        this.initialize();
    }

    public VirtualBlot(String fileName) throws IOException {
        super("VirtualBlot");
        this.setSize(600, 400);
        this.setDefaultCloseOperation(2);
        TabSeparatedDataFile dataFile = new TabSeparatedDataFile(fileName);
        DecoratedDoubleMatrix2D dt = dataFile.readMatrix();
        this.allData = dt;
        this.initialize();
    }

    private void initialize() {
        this.blotPanel = new BlotPanel((DecoratedDoubleMatrix2D)this.allData, 1);
        this.scrollPane = new JScrollPane(this.blotPanel);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        JPanel butPanel = new JPanel(new FlowLayout());
        butPanel.add(new JLabel("time scale: 1/"));
        this.combScale = new JComboBox();
        this.combScale.addItem("1");
        this.combScale.addItem("2");
        this.combScale.addItem("3");
        this.combScale.addItem("5");
        this.combScale.addItem("10");
        this.combScale.addItem("20");
        this.combScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualBlot.this.blotPanel.changeTimeScale(Integer.parseInt(VirtualBlot.this.combScale.getSelectedItem().toString()));
                VirtualBlot.this.validate();
            }
        });
        butPanel.add(this.combScale);
        this.getContentPane().add((Component)butPanel, "South");
    }

    public DoubleMatrix2D getData() {
        return this.allData;
    }

    public static void main(String[] args) {
        try {
            String fileName = "test_sets/timeseries.res";
            VirtualBlot vt = new VirtualBlot(fileName);
            vt.setVisible(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

