/*
 * Decompiled with CFR 0.152.
 */
package org.compbiollab.dynamicalsystem;

import java.util.List;
import java.util.Vector;
import org.compbiollab.algorithms.GraphAlgorithms;
import org.compbiollab.dynamicalsystem.Digraph;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.bl.NetworkState;
import org.enfin.squad.bl.ode.ODESystemSolver;
import org.enfin.squad.dl.GraphContainer;

public class ContinuousSystem
extends Digraph {
    private final Vector nodeNames;
    private final int networkSize;
    private GraphContainer grCont;

    public ContinuousSystem(GraphContainer graph) {
        this.grCont = graph;
        this.networkSize = this.grCont.getGraph().numVertices();
        this.nodeNames = GraphAlgorithms.getSortedNodeNames(this.grCont.getGraph());
    }

    public List<NetworkState> getContinuousStateFromDiscrete(List<NetworkState> listOfStates) {
        for (NetworkState nt : listOfStates) {
            nt.fillNodesWithState(this.grCont.getNodes(), false);
            ODESystemSolver solve = new ODESystemSolver(this.grCont);
            solve.setStopAtSteadyState(true);
            solve.initialize();
            solve.runSync();
            System.out.println(nt.getId());
            for (AbstractGraphNode modifiedNode : this.grCont.getNodes()) {
                nt.setContinuousValue(modifiedNode.getName(), modifiedNode.getState());
            }
            solve.dispose();
        }
        return listOfStates;
    }
}

