/*
 * Decompiled with CFR 0.152.
 */
package org.compbiollab.dynamicalsystem;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Digraph {
    private HashMap connectivity = new HashMap();
    private final String NEGATIVE = "-";
    private final String POSITIVE = "+";
    private final String NONE = "x";
    private Integer networkSize;
    private Integer numberOfInteractions;
    private String connectivityAsString;

    public Digraph() {
    }

    public Digraph(String fileName) throws IOException {
        this.readNetFromFile(fileName);
    }

    private void addConnection(String fromNode, String toNode, String sign) {
        HashMap outputSet = new HashMap();
        if (this.connectivity.containsKey(fromNode)) {
            outputSet = (HashMap)this.connectivity.get(fromNode);
        }
        outputSet.put(toNode, sign);
        this.connectivity.put(fromNode, outputSet);
    }

    public void readNetFromFile(String fileName) throws IOException {
        String line;
        HashSet<String> allElements = new HashSet<String>();
        BufferedReader inputData = new BufferedReader(new FileReader(fileName));
        this.numberOfInteractions = 0;
        this.connectivityAsString = "";
        while ((line = inputData.readLine()) != null) {
            Pattern regEx = Pattern.compile("(^\\S+)\\s+(-[>|])\\s+(\\S+).*$");
            Matcher lineToParse = regEx.matcher(line);
            if (!lineToParse.matches()) continue;
            Digraph digraph = this;
            Integer n = digraph.numberOfInteractions;
            Integer n2 = digraph.numberOfInteractions = Integer.valueOf(digraph.numberOfInteractions + 1);
            this.connectivityAsString = this.connectivityAsString + line + "\n";
            String interaction = this.NONE;
            interaction = lineToParse.group(2).equals("->") ? this.POSITIVE : this.NEGATIVE;
            this.addConnection(lineToParse.group(1), lineToParse.group(3), interaction);
            allElements.add(lineToParse.group(1));
            allElements.add(lineToParse.group(3));
        }
        inputData.close();
        this.addEndNodes(allElements);
        Vector allNodes = new Vector(this.connectivity.keySet());
        this.networkSize = allNodes.size();
    }

    public void addEndNodes(HashSet allElements) {
        Vector elementVector = new Vector(allElements);
        for (int i = 0; i < elementVector.size(); ++i) {
            if (this.connectivity.containsKey(elementVector.get(i).toString())) continue;
            this.addConnection(elementVector.get(i).toString(), "", this.NONE);
        }
    }

    public void showConnectivity() {
        Vector allNodes = new Vector(this.connectivity.keySet());
        for (int i = 0; i < allNodes.size(); ++i) {
            String currentNode = allNodes.elementAt(i).toString();
            System.out.println(currentNode);
            HashMap outputHash = new HashMap();
            outputHash = (HashMap)this.connectivity.get(currentNode);
            Vector localOutputs = new Vector(outputHash.keySet());
            for (int j = 0; j < localOutputs.size(); ++j) {
                String interaction = outputHash.get(localOutputs.elementAt(j)).toString().equals(this.POSITIVE) ? "->" : (outputHash.get(localOutputs.elementAt(j)).toString().equals(this.NEGATIVE) ? "-|" : "--");
                System.out.println("    " + interaction + " " + localOutputs.elementAt(j));
            }
        }
    }

    private Vector getCyclesFromNode(String node) {
        HashMap outputHash = new HashMap((HashMap)this.connectivity.get(node));
        Vector nodesToVisit = new Vector(outputHash.keySet());
        Vector<String> history = new Vector<String>();
        history.add(node);
        Vector cycles = new Vector();
        cycles = this.visit(nodesToVisit, history, cycles);
        return cycles;
    }

    private Vector visit(Vector nodesToVisit, Vector history, Vector cycles) {
        for (int i = 0; i < nodesToVisit.size(); ++i) {
            if (nodesToVisit.elementAt(i).equals(history.elementAt(0))) {
                cycles.add(history);
                continue;
            }
            if (history.contains(nodesToVisit.elementAt(i)) || !this.connectivity.containsKey(nodesToVisit.elementAt(i).toString())) continue;
            Vector localHistory = new Vector(history);
            localHistory.add(nodesToVisit.elementAt(i));
            HashMap localOutputHash = new HashMap((HashMap)this.connectivity.get(nodesToVisit.elementAt(i)));
            Vector localNodesToVisit = new Vector(localOutputHash.keySet());
            cycles = this.visit(localNodesToVisit, localHistory, cycles);
        }
        return cycles;
    }

    public Vector getAllCycles() {
        Vector allCycles = new Vector();
        Vector allNodes = new Vector(this.connectivity.keySet());
        for (int i = 0; i < allNodes.size(); ++i) {
            Vector cyclesFromNode = new Vector(this.getCyclesFromNode(allNodes.elementAt(i).toString()));
            for (int j = 0; j < cyclesFromNode.size(); ++j) {
                if (this.cycleIsAlreadyIncluded((Vector)cyclesFromNode.elementAt(j), allCycles)) continue;
                allCycles.add(cyclesFromNode.elementAt(j));
            }
        }
        return allCycles;
    }

    private boolean cycleIsAlreadyIncluded(Vector oneCycle, Vector allCycles) {
        for (int i = 0; i < allCycles.size(); ++i) {
            if (!this.arePermutations(oneCycle, (Vector)allCycles.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean arePermutations(Vector cycleOne, Vector cycleTwo) {
        int i;
        if (cycleOne.size() != cycleTwo.size()) {
            return false;
        }
        if (cycleOne == cycleTwo) {
            return true;
        }
        HashSet setOne = new HashSet(cycleOne);
        HashSet setTwo = new HashSet(cycleTwo);
        if (!setOne.equals(setTwo)) {
            return false;
        }
        int shiftedBy = 0;
        for (int i2 = 0; i2 < cycleTwo.size(); ++i2) {
            if (!cycleOne.elementAt(0).equals(cycleTwo.elementAt(i2))) continue;
            shiftedBy = i2;
            break;
        }
        if (shiftedBy == 0) {
            return false;
        }
        Vector doubledTarget = new Vector(cycleTwo);
        for (i = 0; i < cycleTwo.size(); ++i) {
            doubledTarget.add(cycleTwo.elementAt(i));
        }
        for (i = 0; i < cycleOne.size(); ++i) {
            if (cycleOne.elementAt(i).equals(doubledTarget.elementAt(i + shiftedBy))) continue;
            return false;
        }
        return true;
    }

    public String getSignOfCycle(Vector cycle) {
        String localSign = this.POSITIVE;
        String globalSign = this.POSITIVE;
        for (int i = 0; i < cycle.size() - 1; ++i) {
            HashMap outputs = new HashMap((HashMap)this.connectivity.get(cycle.elementAt(i).toString()));
            localSign = outputs.get(cycle.elementAt(i + 1).toString()).toString();
            if (localSign.equals(this.NONE)) {
                return localSign;
            }
            if (!localSign.equals(this.NEGATIVE)) continue;
            if (globalSign.equals(this.POSITIVE)) {
                globalSign = this.NEGATIVE;
                continue;
            }
            if (!globalSign.equals(this.NEGATIVE)) continue;
            globalSign = this.POSITIVE;
        }
        localSign = ((HashMap)this.connectivity.get(cycle.lastElement().toString())).get(cycle.firstElement().toString()).toString();
        if (!localSign.equals(this.POSITIVE) && !localSign.equals(this.NEGATIVE)) {
            return this.NONE;
        }
        if (localSign.equals(this.NEGATIVE)) {
            if (globalSign.equals(this.POSITIVE)) {
                globalSign = this.NEGATIVE;
            } else if (globalSign.equals(this.NEGATIVE)) {
                globalSign = this.POSITIVE;
            }
        }
        return globalSign;
    }

    public Vector getNodeNames() {
        HashSet names = new HashSet(this.connectivity.keySet());
        String[] namesArray = new String[this.connectivity.size()];
        Object[] objectArray = new Object[this.connectivity.size()];
        objectArray = names.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            namesArray[i] = objectArray[i].toString();
        }
        Arrays.sort(namesArray, String.CASE_INSENSITIVE_ORDER);
        Vector<String> namesVector = new Vector<String>();
        for (int i = 0; i < namesArray.length; ++i) {
            namesVector.add(namesArray[i]);
        }
        return namesVector;
    }

    private Vector sortThisVector(Vector unsorted) {
        int i;
        Vector<String> sorted = new Vector<String>();
        String[] toSort = new String[unsorted.size()];
        for (i = 0; i < unsorted.size(); ++i) {
            toSort[i] = unsorted.elementAt(i).toString();
        }
        Arrays.sort(toSort, String.CASE_INSENSITIVE_ORDER);
        for (i = 0; i < toSort.length; ++i) {
            sorted.add(toSort[i]);
        }
        return sorted;
    }

    public Vector getInputsToCycle(Vector cycle) {
        Vector allInputs = new Vector();
        for (int i = 0; i < cycle.size(); ++i) {
            Vector localInputs = new Vector(this.getInputsTo(cycle.get(i).toString()));
            for (int j = 0; j < localInputs.size(); ++j) {
                if (cycle.contains(localInputs.get(j))) continue;
                allInputs.add(localInputs.get(j));
            }
        }
        return this.sortThisVector(allInputs);
    }

    public void showAllCycles() {
        Vector allCycles = new Vector(this.getAllCycles());
        for (int i = 0; i < allCycles.size(); ++i) {
            System.out.println(allCycles.get(i));
        }
    }

    public String signOfEdge(String fromNode, String toNode) {
        HashMap edgeDetails = new HashMap((HashMap)this.connectivity.get(fromNode));
        if (edgeDetails.containsKey(toNode)) {
            return edgeDetails.get(toNode).toString();
        }
        return this.NONE;
    }

    public HashMap getConnectivity() {
        return this.connectivity;
    }

    public Vector getOutputsFrom(String node) {
        HashMap allOutLinks = new HashMap();
        allOutLinks = (HashMap)this.connectivity.get(node);
        Vector output = new Vector(allOutLinks.keySet());
        return output;
    }

    public Integer getNetworkSize() {
        return this.networkSize;
    }

    public Integer getNumberOfInteractions() {
        return this.numberOfInteractions;
    }

    public String getConnectivityAsString() {
        return this.connectivityAsString;
    }

    public Vector getInputsTo(String node) {
        Vector<String> inputsFrom = new Vector<String>();
        Iterator iter = this.connectivity.keySet().iterator();
        String nodeName = new String();
        while (iter.hasNext()) {
            nodeName = iter.next().toString();
            HashMap localConnectivity = new HashMap((HashMap)this.connectivity.get(nodeName));
            if (!localConnectivity.containsKey(node)) continue;
            inputsFrom.add(nodeName);
        }
        return this.sortThisVector(inputsFrom);
    }
}

