/*
 * Decompiled with CFR 0.152.
 */
package org.compbiollab.dynamicalsystem;

import com.sun.org.apache.regexp.internal.RESyntaxException;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.compbiollab.algorithms.GraphAlgorithms;
import org.compbiollab.dynamicalsystem.Digraph;
import org.enfin.squad.bl.IObservable;
import org.enfin.squad.bl.IObserver;
import org.enfin.squad.bl.NetworkState;
import org.enfin.squad.bl.NodeValueState;
import org.enfin.squad.dl.GraphContainer;
import org.enfin.squad.dl.VectorTools;

public class DiscreteSystem
extends Digraph
implements IObservable {
    private List allStableSteadyStates;
    private final DirectedSparseGraph theGraph;
    private HashMap dynamicalRules;
    private int networkSize;
    private final Vector<String> nodeNames;
    private final Vector graphNodes;
    private IObserver theObserver;

    @Override
    public void registerObserver(IObserver observer) {
        this.theObserver = observer;
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.theObserver = null;
    }

    public DiscreteSystem(DirectedSparseGraph graph) {
        this.theGraph = graph;
        this.networkSize = this.theGraph.numVertices();
        this.graphNodes = new Vector(this.theGraph.getVertices());
        this.nodeNames = new Vector();
        for (int i = 0; i < this.networkSize; ++i) {
            Vertex oneNode = (Vertex)this.graphNodes.get(i);
            this.nodeNames.add(oneNode.getUserDatum((Object)"id").toString());
        }
        Collections.sort(this.nodeNames);
        this.dynamicalRules = new HashMap(this.generateParameters());
    }

    private String generateParameterString(Vertex node, Vector inputs) {
        String name = new String();
        name = name + node.getUserDatum((Object)"id").toString() + "(";
        for (int i = 0; i < inputs.size(); ++i) {
            String inputNodeName = ((Vertex)inputs.get(i)).getUserDatum((Object)"id").toString();
            name = name + inputNodeName + ";";
        }
        if (name.endsWith(";")) {
            name = name.substring(0, name.length() - 1);
        }
        name = name + ")";
        return name;
    }

    private int assignValue(Vertex node, Vector inputs) {
        if (inputs.size() == 0) {
            int totalNumberOfNegativeInputs;
            int totalNumberOfPositiveInputs = this.getTotalPositiveInputsTo(node).size();
            if (totalNumberOfPositiveInputs == 0 & (totalNumberOfNegativeInputs = this.getTotalNegativeInputsTo(node).size()) > 0) {
                return 1;
            }
            return 0;
        }
        if (this.getActiveNegativeInputsTo(node, inputs).size() > 0) {
            return 0;
        }
        return 1;
    }

    private HashMap generateParameters() {
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        for (int i = 0; i < this.nodeNames.size(); ++i) {
            int j;
            Vertex presentNode = GraphAlgorithms.getNodeByName((Graph)this.theGraph, this.nodeNames.get(i).toString());
            Vector inputs = new Vector(presentNode.getPredecessors());
            Vector whichNodesToInclude = new Vector();
            for (j = 0; j < inputs.size(); ++j) {
                whichNodesToInclude.add(0);
            }
            j = 0;
            while ((double)j < Math.pow(2.0, inputs.size())) {
                Vector activeInputs = new Vector();
                for (int k = 0; k < whichNodesToInclude.size(); ++k) {
                    if (!whichNodesToInclude.get(k).equals(1)) continue;
                    activeInputs.add(inputs.get(k));
                }
                String name = new String(this.generateParameterString(presentNode, activeInputs));
                int value = this.assignValue(presentNode, activeInputs);
                values.put(name, value);
                whichNodesToInclude = VectorTools.nextBinaryState(whichNodesToInclude);
                ++j;
            }
        }
        return values;
    }

    public Vector getTotalPositiveInputsTo(Vertex node) {
        Vector<Vertex> result = new Vector<Vertex>();
        Vector allInputs = new Vector(node.getInEdges());
        for (int i = 0; i < allInputs.size(); ++i) {
            DirectedSparseEdge oneEdge = (DirectedSparseEdge)allInputs.get(i);
            if (!oneEdge.getUserDatum((Object)"sign").equals("positive")) continue;
            Vertex source = oneEdge.getSource();
            result.add(source);
        }
        return result;
    }

    public Vector getTotalNegativeInputsTo(Vertex node) {
        Vector<Vertex> result = new Vector<Vertex>();
        Vector allInputs = new Vector(node.getInEdges());
        for (int i = 0; i < allInputs.size(); ++i) {
            DirectedSparseEdge oneEdge = (DirectedSparseEdge)allInputs.get(i);
            if (!oneEdge.getUserDatum((Object)"sign").equals("negative")) continue;
            Vertex source = oneEdge.getSource();
            result.add(source);
        }
        return result;
    }

    public Vector getActiveNegativeInputsTo(Vertex node, Vector inputs) {
        Vector<Vertex> result = new Vector<Vertex>();
        Vector allInputs = new Vector(node.getInEdges());
        for (int i = 0; i < allInputs.size(); ++i) {
            Vertex source;
            DirectedSparseEdge oneEdge = (DirectedSparseEdge)allInputs.get(i);
            if (!oneEdge.getUserDatum((Object)"sign").equals("negative") || !inputs.contains(source = oneEdge.getSource())) continue;
            result.add(source);
        }
        return result;
    }

    private boolean thisIsAFixedPoint(Vector stateVector) {
        for (int i = 0; i < stateVector.size(); ++i) {
            Vertex node = this.getNodeByPosition(i);
            Vector inputs = new Vector(node.getPredecessors());
            Vector activeInputs = new Vector();
            for (int j = 0; j < inputs.size(); ++j) {
                String localInput = ((Vertex)inputs.get(j)).getUserDatum((Object)"id").toString();
                int positionOfLocalInput = this.getPositionOfNode(localInput);
                if (!stateVector.get(positionOfLocalInput).equals(1)) continue;
                activeInputs.add(inputs.get(j));
            }
            String inputState = new String(this.generateParameterString(node, activeInputs));
            if (this.dynamicalRules.get(inputState).equals(stateVector.get(i))) continue;
            return false;
        }
        return true;
    }

    private Vertex getNodeByPosition(int position) {
        String name = this.nodeNames.get(position).toString();
        int which = 0;
        for (int i = 0; i < this.networkSize; ++i) {
            String nameOfThisVertex = ((Vertex)this.graphNodes.get(i)).getUserDatum((Object)"id").toString();
            if (nameOfThisVertex != name) continue;
            which = i;
            break;
        }
        return (Vertex)this.graphNodes.get(which);
    }

    private int getPositionOfNode(String theName) {
        int which = 0;
        for (int i = 0; i < this.nodeNames.size(); ++i) {
            if (!this.nodeNames.get(i).equals(theName)) continue;
            which = i;
        }
        return which;
    }

    private int getPositionOfNode(Vertex node) {
        String theName = node.getUserDatum((Object)"id").toString();
        int which = 0;
        for (int i = 0; i < this.nodeNames.size(); ++i) {
            if (!this.nodeNames.get(i).equals(theName)) continue;
            which = i;
        }
        return which;
    }

    private Vector getFixedPoints() {
        int i;
        int fixedPointsCounter = 0;
        Vector<Vector> allFixedPoints = new Vector<Vector>();
        Vector networkState = new Vector();
        Vector ignoreTheseNodes = new Vector(GraphAlgorithms.getUpstreamNodesByName(this.theGraph));
        if (ignoreTheseNodes.size() == this.networkSize) {
            ignoreTheseNodes.clear();
        }
        Vector<Integer> ignoreThesePositions = new Vector<Integer>();
        for (i = 0; i < ignoreTheseNodes.size(); ++i) {
            ignoreThesePositions.add(this.getPositionOfNode(ignoreTheseNodes.get(i).toString()));
        }
        for (i = 0; i < this.networkSize; ++i) {
            networkState.add(1);
        }
        do {
            if (this.thisIsAFixedPoint(networkState = VectorTools.nextRelevantBinaryState(networkState, ignoreThesePositions))) {
                allFixedPoints.add(networkState);
            }
            Vector nextState = new Vector();
            nextState = VectorTools.nextRelevantBinaryState(networkState, ignoreThesePositions);
            this.theObserver.updateObserver(this, fixedPointsCounter++);
        } while (VectorTools.largerThan(VectorTools.nextRelevantBinaryState(networkState, ignoreThesePositions), networkState));
        return allFixedPoints;
    }

    public List<NetworkState> getAttractors() {
        ArrayList<NetworkState> allSteadyStates = new ArrayList<NetworkState>(NetworkState.getListOfNetwokStatesFromVector(this.getFixedPoints(), this.nodeNames));
        Vector negativeCycles = new Vector(GraphAlgorithms.getAllNegativeCycles(this.theGraph));
        int steadyStateCounter = 1;
        for (int i = 0; i < negativeCycles.size(); ++i) {
            Vector singularSS = this.getSingularSteadyStates((Vector)negativeCycles.get(i));
            for (int j = 0; j < singularSS.size(); ++j) {
                allSteadyStates.add(NetworkState.getNetworkStateFromVector("SS-" + steadyStateCounter, (Vector)singularSS.get(j), this.nodeNames));
            }
        }
        this.allStableSteadyStates = allSteadyStates;
        if (allSteadyStates.size() == 0) {
            Vector allNodes = VectorTools.unionOfVectors(negativeCycles);
            Vector allPositions = new Vector(this.getElementPositions(allNodes));
            NetworkState fakeSteadyState = new NetworkState("SS-" + steadyStateCounter);
            for (int i = 0; i < this.networkSize; ++i) {
                String nodeName = this.nodeNames.get(i);
                if (allPositions.contains(i)) {
                    fakeSteadyState.put(nodeName, new NodeValueState(nodeName, 0.5));
                    continue;
                }
                fakeSteadyState.put(nodeName, new NodeValueState(nodeName, 0.0));
            }
            allSteadyStates.add(fakeSteadyState);
        }
        return allSteadyStates;
    }

    private Vector getSingularSteadyStates(Vector negativeCycle) {
        Vector<Vector> allSingularSteadyStates = new Vector<Vector>();
        Vector variablePositions = new Vector(this.getElementPositions(this.getDirectInputsToCycle(negativeCycle)));
        Vector fixedPositions = new Vector(this.getElementPositions(negativeCycle));
        Vector<Integer> ignoreThesePositions = new Vector<Integer>();
        for (int i = 0; i < this.networkSize; ++i) {
            if (variablePositions.contains(i)) continue;
            ignoreThesePositions.add(i);
        }
        Vector networkState = new Vector();
        for (int i = 0; i < this.networkSize; ++i) {
            networkState.add(1);
        }
        HashMap cycleMinimalPreimage = new HashMap(this.getCycleMinimalPreimage(negativeCycle));
        do {
            Vector variableVector;
            Vector preimages;
            if (!this.thisIsASingularSteadyState(preimages = new Vector(this.getMiniMaxPreimages(variableVector = VectorTools.reduceVector(networkState = VectorTools.nextRelevantBinaryState(networkState, ignoreThesePositions), fixedPositions), cycleMinimalPreimage)), negativeCycle)) continue;
            allSingularSteadyStates.add(this.createSingularSteadyState(preimages));
        } while (VectorTools.largerThan(VectorTools.nextRelevantBinaryState(networkState, ignoreThesePositions), networkState));
        return allSingularSteadyStates;
    }

    private Vector getElementPositions(Vector elements) {
        Vector<Integer> positions = new Vector<Integer>();
        for (int i = 0; i < elements.size(); ++i) {
            positions.add(this.getPositionOfNode((Vertex)elements.get(i)));
        }
        Collections.sort(positions);
        return positions;
    }

    private HashMap getCycleMinimalPreimage(Vector cycle) {
        HashMap<Integer, Integer> minimal = new HashMap<Integer, Integer>();
        for (int i = 0; i < cycle.size() - 1; ++i) {
            if (this.getSignOfInteraction((Vertex)cycle.get(i), (Vertex)cycle.get(i + 1)).equals("positive")) {
                minimal.put(this.getPositionOfNode((Vertex)cycle.get(i)), 0);
                continue;
            }
            minimal.put(this.getPositionOfNode((Vertex)cycle.get(i)), 1);
        }
        if (this.getSignOfInteraction((Vertex)cycle.get(cycle.size() - 1), (Vertex)cycle.get(0)).equals("positive")) {
            minimal.put(this.getPositionOfNode((Vertex)cycle.get(cycle.size() - 1)), 0);
        } else {
            minimal.put(this.getPositionOfNode((Vertex)cycle.get(cycle.size() - 1)), 1);
        }
        return minimal;
    }

    private Vector getMiniMaxPreimages(Vector variableVector, HashMap cycleMinimalPreimage) {
        Vector<Integer> minimal = new Vector<Integer>(variableVector);
        Vector<Integer> maximal = new Vector<Integer>(variableVector);
        Vector positions = new Vector(cycleMinimalPreimage.keySet());
        Collections.sort(positions);
        for (int i = 0; i < positions.size(); ++i) {
            Integer where = new Integer(positions.get(i).toString());
            String value = cycleMinimalPreimage.get(where).toString();
            if (value.equals("0")) {
                minimal.add(where, 0);
                maximal.add(where, 1);
                continue;
            }
            minimal.add(where, 1);
            maximal.add(where, 0);
        }
        Vector<Vector<Integer>> miniMax = new Vector<Vector<Integer>>();
        miniMax.add(minimal);
        miniMax.add(maximal);
        return miniMax;
    }

    private boolean thisIsASingularSteadyState(Vector preimages, Vector negativeCycle) {
        Vector minimalPreimage = new Vector((Vector)preimages.get(0));
        Vector maximalPreimage = new Vector((Vector)preimages.get(1));
        Vector minimalImage = new Vector(this.nextNetworkState(minimalPreimage));
        Vector maximalImage = new Vector(this.nextNetworkState(maximalPreimage));
        Vector negativeCycleByNames = new Vector(GraphAlgorithms.getNamesOfVertices(negativeCycle, this.theGraph));
        for (int i = 0; i < this.networkSize; ++i) {
            if (!(negativeCycleByNames.contains(this.nodeNames.get(i)) ? !minimalImage.get(i).equals(0) || !maximalImage.get(i).equals(1) : !minimalImage.get(i).equals(maximalImage.get(i)))) continue;
            return false;
        }
        return true;
    }

    private Vector nextNetworkState(Vector presentState) {
        int i;
        Vector futureState = new Vector();
        HashMap statesByVertex = new HashMap();
        for (i = 0; i < this.networkSize; ++i) {
            statesByVertex.put(GraphAlgorithms.getNodeByName((Graph)this.theGraph, this.nodeNames.get(i).toString()), presentState.get(i));
        }
        for (i = 0; i < this.nodeNames.size(); ++i) {
            Vertex presentNode = this.getNodeByPosition(i);
            Vector inputs = new Vector(presentNode.getPredecessors());
            Vector activeInputs = new Vector();
            for (int j = 0; j < inputs.size(); ++j) {
                if (!statesByVertex.get(inputs.get(j)).equals(1)) continue;
                activeInputs.add(inputs.get(j));
            }
            String inputState = new String(this.generateParameterString(presentNode, activeInputs));
            futureState.add(this.dynamicalRules.get(inputState));
        }
        return futureState;
    }

    private Vector createSingularSteadyState(Vector preimages) {
        Vector singularSS = new Vector();
        Vector minimal = new Vector((Vector)preimages.get(0));
        Vector maximal = new Vector((Vector)preimages.get(1));
        for (int i = 0; i < this.networkSize; ++i) {
            if (minimal.get(i).equals(maximal.get(i))) {
                singularSS.add(minimal.get(i));
                continue;
            }
            singularSS.add(0.5);
        }
        return singularSS;
    }

    public void generateVisualOutput(String rootFileName) throws RESyntaxException, IOException {
        String lowStateNode = "[style=filled]";
        String mediumStateNode = "[style=filled,color=\"light_blue\"]";
        String highStateNode = "[style=filled,color=\"blue\"]";
        int numberOfAttractors = this.allStableSteadyStates.size();
        for (int i = 1; i <= numberOfAttractors; ++i) {
            int j;
            String textForDot = "digraph network\n   {\n   label=\"Attractor " + i + "\";\n";
            for (j = 0; j < this.networkSize; ++j) {
                textForDot = textForDot + "   \"" + this.nodeNames.get(j) + "\" ";
                Vector attractor = (Vector)this.allStableSteadyStates.get(i - 1);
                if (attractor.get(j).equals(0)) {
                    textForDot = textForDot + lowStateNode + ";\n";
                    continue;
                }
                if (attractor.get(j).equals(0.5)) {
                    textForDot = textForDot + mediumStateNode + ";\n";
                    continue;
                }
                if (!attractor.get(j).equals(1)) continue;
                textForDot = textForDot + highStateNode + ";\n";
            }
            for (j = 0; j < this.nodeNames.size(); ++j) {
                Vector outNodes = new Vector(this.getOutputsFrom(this.nodeNames.get(j)));
                Vertex originVertex = GraphContainer.getVertexByName(this.nodeNames.get(j), (Graph)this.theGraph);
                if (outNodes.get(0) == "") continue;
                for (int k = 0; k < outNodes.size(); ++k) {
                    textForDot = textForDot + "   edge [color=";
                    String sign = this.getSignOfInteraction(originVertex, (Vertex)outNodes.get(k));
                    if (sign.equals("positive")) {
                        textForDot = textForDot + "green];\n";
                    } else if (sign.equals("negative")) {
                        textForDot = textForDot + "red];\n";
                    }
                    textForDot = textForDot + "   \"" + this.nodeNames.get(j) + "\" -> \"" + outNodes.get(k) + "\";\n";
                }
            }
            textForDot = textForDot + "   }\n";
            this.generateFiles(rootFileName, i, textForDot);
        }
    }

    private void generateFiles(String rootFileName, int i, String textForDot) throws IOException {
        String finalFile = rootFileName + "_attractor_" + i + ".png";
        File tmp = File.createTempFile("for_dot", ".tmp");
        BufferedWriter inputToDot = new BufferedWriter(new FileWriter(tmp.getCanonicalPath()));
        inputToDot.write(textForDot);
        inputToDot.close();
        try {
            Process runningOctave = Runtime.getRuntime().exec("/home/lmendoza/bin/dot -Tpng " + tmp.getCanonicalPath() + " -o " + finalFile);
            runningOctave.waitFor();
        }
        catch (InterruptedException e) {
            System.err.println(e);
        }
        tmp.delete();
    }

    private String getSignOfInteraction(Vertex nodeFrom, Vertex nodeTo) {
        DirectedSparseEdge edge = null;
        Vector allEdges = new Vector(this.theGraph.getEdges());
        for (int i = 0; i < allEdges.size(); ++i) {
            Vertex node2;
            Vertex node1 = ((DirectedSparseEdge)allEdges.get(i)).getSource();
            if (!(node1 == nodeFrom & (node2 = ((DirectedSparseEdge)allEdges.get(i)).getDest()) == nodeTo)) continue;
            edge = (DirectedSparseEdge)allEdges.get(i);
            break;
        }
        return edge.getUserDatum((Object)"sign").toString();
    }

    private Vector getDirectInputsToCycle(Vector negativeCycle) {
        Vector result = new Vector();
        for (int i = 0; i < negativeCycle.size(); ++i) {
            Vertex node = (Vertex)negativeCycle.get(i);
            Vector allInputNodes = new Vector(node.getPredecessors());
            for (int j = 0; j < allInputNodes.size(); ++j) {
                if (negativeCycle.contains(allInputNodes.get(j))) continue;
                result.add(allInputNodes.get(j));
            }
        }
        return result;
    }
}

