/*
 * Decompiled with CFR 0.152.
 */
package org.compbiollab.dynamicalsystem;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import java.util.Vector;
import org.compbiollab.algorithms.GraphAlgorithms;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.dl.VectorTools;
import org.opensourcephysics.numerics.ODE;

public class GraphToODE
implements ODE {
    private DirectedSparseGraph theGraph;
    private Vector<AbstractGraphNode> theNodes;
    private int numberOfNodes;
    private double[] levelOfActivation;
    private double[] decayRate;
    private double[] sigmoidGain;
    private Vector weightMatrix;

    public GraphToODE(DirectedSparseGraph graph) {
        this.theGraph = graph;
        this.theNodes = GraphAlgorithms.getSortedNodeNames((Graph)this.theGraph);
        this.numberOfNodes = this.theNodes.size();
        this.levelOfActivation = new double[this.numberOfNodes + 1];
        this.decayRate = new double[this.numberOfNodes];
        this.sigmoidGain = new double[this.numberOfNodes];
        this.weightMatrix = VectorTools.getZeroMatrix(this.numberOfNodes, this.numberOfNodes);
        VectorTools.fillMatrixWithValue(this.weightMatrix, 1.0);
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.levelOfActivation[i] = 0.0;
            this.decayRate[i] = 1.0;
            this.sigmoidGain[i] = 10.0;
        }
        this.levelOfActivation[this.numberOfNodes] = 0.0;
    }

    public double[] getState() {
        return this.levelOfActivation;
    }

    public void getRate(double[] levelOfActivation, double[] rate) {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            int position;
            int j;
            double totalPositiveInput = 1.0;
            double totalNegativeInput = 1.0;
            Vector positiveInputs = new Vector(GraphAlgorithms.getPositiveInputsToNodeByName(this.theGraph, this.theNodes.get(i).toString()));
            Vector negativeInputs = new Vector(GraphAlgorithms.getNegativeInputsToNodeByName(this.theGraph, this.theNodes.get(i).toString()));
            double weightedInput = 0.0;
            double summOfWeights = 0.0;
            for (j = 0; j < positiveInputs.size(); ++j) {
                position = this.theNodes.indexOf(positiveInputs.get(j).toString());
                weightedInput += new Double(VectorTools.getValue(this.weightMatrix, i, position).toString()) * levelOfActivation[position];
                summOfWeights += new Double(VectorTools.getValue(this.weightMatrix, i, position).toString()).doubleValue();
            }
            if (positiveInputs.size() > 0) {
                totalPositiveInput = (1.0 + summOfWeights) / summOfWeights * (weightedInput / (1.0 + weightedInput));
            }
            weightedInput = 0.0;
            summOfWeights = 0.0;
            for (j = 0; j < negativeInputs.size(); ++j) {
                position = this.theNodes.indexOf(negativeInputs.get(j).toString());
                weightedInput += new Double(VectorTools.getValue(this.weightMatrix, i, position).toString()) * levelOfActivation[position];
                summOfWeights += new Double(VectorTools.getValue(this.weightMatrix, i, position).toString()).doubleValue();
            }
            if (negativeInputs.size() > 0) {
                totalNegativeInput = 1.0 - (1.0 + summOfWeights) / summOfWeights * (weightedInput / (1.0 + weightedInput));
            }
            double omega = totalPositiveInput * totalNegativeInput;
            double upperTerm = Math.exp(-this.sigmoidGain[i] * (omega - 0.5)) - Math.exp(0.5 * this.sigmoidGain[i]);
            double lowerTerm = (1.0 - Math.exp(0.5 * this.sigmoidGain[i])) * (1.0 + Math.exp(-this.sigmoidGain[i] * (omega - 0.5)));
            rate[i] = negativeInputs.size() == 0 && positiveInputs.size() == 0 ? -(this.theNodes.get(i).getDecay() * levelOfActivation[i]) : upperTerm / lowerTerm - this.theNodes.get(i).getDecay() * levelOfActivation[i];
        }
        rate[this.numberOfNodes] = 1.0;
    }
}

