/*
 * Decompiled with CFR 0.152.
 */
package org.compbiollab.dynamicalsystem;

import com.sun.org.apache.regexp.internal.RESyntaxException;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.compbiollab.algorithms.GraphAlgorithms;
import org.compbiollab.dynamicalsystem.ContinuousSystem;
import org.compbiollab.dynamicalsystem.DiscreteSystem;
import org.enfin.squad.bl.IObservable;
import org.enfin.squad.bl.IObserver;
import org.enfin.squad.bl.NetworkState;
import org.enfin.squad.bl.SteadyStateBDDFinder;
import org.enfin.squad.dl.GraphContainer;

public class Simulator
implements Runnable,
IObserver,
IObservable {
    private String textForOctave;
    private GraphContainer grCont;
    private static final Logger log = Logger.getLogger(Simulator.class);
    private int currentStatus;
    private boolean computationDone = false;
    private IObserver obs = null;
    private boolean useBDDnalysis = true;
    private boolean extractContinuousState = true;
    private boolean discreteSystemAnalysed = false;
    private boolean continuousSystemAnalysed = false;

    public int getCurrentStatus() {
        return this.currentStatus;
    }

    public boolean isUseBDDnalysis() {
        return this.useBDDnalysis;
    }

    public void setUseBDDnalysis(boolean useBDD) {
        this.useBDDnalysis = useBDD;
    }

    public boolean isExtractContinuousState() {
        return this.extractContinuousState;
    }

    public void setExtractContinuousState(boolean extractContinuousState) {
        this.extractContinuousState = extractContinuousState;
    }

    @Override
    public void registerObserver(IObserver observer) {
        this.obs = observer;
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.obs = null;
    }

    public Simulator(GraphContainer grContainer) {
        this.grCont = grContainer;
    }

    @Override
    public void run() {
        this.computationDone = false;
        if (!this.useBDDnalysis) {
            DiscreteSystem naiveDiscreteModel = new DiscreteSystem((DirectedSparseGraph)this.grCont.getGraph());
            naiveDiscreteModel.registerObserver(this);
            this.grCont.setStates(naiveDiscreteModel.getAttractors());
            this.discreteSystemAnalysed = true;
        } else {
            try {
                ArrayList<NetworkState> st = SteadyStateBDDFinder.getSteadyStates(this.grCont.getGraph());
                this.grCont.setStates(st);
                this.discreteSystemAnalysed = true;
                log.info((Object)("BDD run steady states found:" + st.size()));
            }
            catch (Exception e) {
                log.fatal((Object)"error running BDD");
                e.printStackTrace();
            }
        }
        if (this.extractContinuousState) {
            log.info((Object)"calculating cont state from discrete state");
            ContinuousSystem naiveContinuousModel = new ContinuousSystem(this.grCont);
            List<NetworkState> contStates = naiveContinuousModel.getContinuousStateFromDiscrete(this.grCont.getStates());
            this.grCont.setStates(contStates);
            this.grCont.setStates(this.excludeIdenticalStates(this.grCont.getStates()));
            this.continuousSystemAnalysed = true;
        }
        this.computationDone = true;
    }

    @Override
    public void updateObserver(IObservable obsvble, Object args) {
        this.currentStatus = (Integer)args;
        if (this.obs != null) {
            this.obs.updateObserver(this, this.currentStatus);
        }
    }

    private List<NetworkState> excludeIdenticalStates(List<NetworkState> nStates) {
        ArrayList<NetworkState> nonDuplicates = new ArrayList<NetworkState>();
        for (int m = 0; m < nStates.size(); ++m) {
            boolean hasDuplicates = false;
            for (int n = m + 1; n < nStates.size(); ++n) {
                if (!nStates.get(m).stateCompare(nStates.get(n))) continue;
                hasDuplicates = true;
                break;
            }
            if (hasDuplicates) continue;
            nonDuplicates.add(nStates.get(m));
        }
        return nonDuplicates;
    }

    public String getTextForSimulation() {
        if (this.grCont.getStates() == null) {
            this.run();
        }
        return this.textForOctave;
    }

    public Vector getAllFeedbackLoops() {
        return GraphAlgorithms.getAllCyclesByName((DirectedSparseGraph)this.grCont.getGraph());
    }

    public List<NetworkState> getAttractorsDiscrete() throws Exception {
        if (!this.discreteSystemAnalysed) {
            this.run();
        }
        return this.grCont.getStates();
    }

    public List<NetworkState> getAttractorsContinuous() {
        if (!this.continuousSystemAnalysed) {
            this.extractContinuousState = true;
            this.run();
        }
        return this.grCont.getStates();
    }

    public GraphContainer getGraphContainer() {
        return this.grCont;
    }

    public boolean isDone() {
        return this.computationDone;
    }

    public static void main(String[] args) throws IOException, RESyntaxException {
        try {
            String fileName = "test_sets/2states.mml";
            GraphContainer gr = new GraphContainer(fileName);
            Simulator theSimulator = new Simulator(gr);
            theSimulator.setUseBDDnalysis(false);
            theSimulator.run();
            for (NetworkState nt : theSimulator.getAttractorsContinuous()) {
                System.out.println(nt.getNonZeroNodes());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

