/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.bl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.bl.NodeValueState;
import org.enfin.squad.guiutils.IGUIXMLMappable;
import org.enfin.squad.guiutils.PropertiesMap;
import org.jdom.Attribute;
import org.jdom.Element;

public class NetworkState
implements IGUIXMLMappable,
Serializable {
    private static final long serialVersionUID = 1L;
    private SortedMap<String, NodeValueState> delegate = new TreeMap<String, NodeValueState>();
    private Map<String, PropertiesMap> properties = new TreeMap<String, PropertiesMap>();
    private boolean isSteadyState = false;
    public Double EQUALITY_TRESHOLD = 0.01;

    public NetworkState(String stateId) {
        this.properties.put("id", new PropertiesMap("id", stateId, stateId.getClass()));
    }

    public static NetworkState getNetworkStateFromVector(String stateId, Vector states, Vector nodeNames) {
        return NetworkState.extractNetworkStateFromVector(nodeNames, states, stateId);
    }

    public Boolean getIsSteadyState() {
        return this.isSteadyState;
    }

    public void setIsSteadyState(boolean isSteady) {
        this.isSteadyState = isSteady;
    }

    public Integer getNumberOfactiveNodes() {
        int counter = 0;
        for (NodeValueState myVal : this.delegate.values()) {
            if (!(myVal.getContinuousValue() > 0.0)) continue;
            ++counter;
        }
        return counter;
    }

    public NetworkState(String stateId, Vector attractors, List<String> nodeNames) {
        this(stateId);
        for (int h = 0; h < attractors.size(); ++h) {
            this.delegate.put(nodeNames.get(h), (NodeValueState)attractors.get(h));
        }
    }

    public NetworkState(String stateId, NodeValueState[] attractors, String[] nodeNames) {
        this(stateId);
        for (int h = 0; h < attractors.length; ++h) {
            this.delegate.put(nodeNames[h], attractors[h]);
        }
    }

    public SortedMap<String, NodeValueState> getNodeStates() {
        return this.delegate;
    }

    public NodeValueState getNode(String nodeName) {
        return (NodeValueState)this.delegate.get(nodeName);
    }

    public static List<NetworkState> getListOfNetwokStatesFromVector(List allStates, List nodeNames) {
        ArrayList<NetworkState> nts = new ArrayList<NetworkState>();
        Collections.sort(nodeNames);
        for (int i = 0; i < allStates.size(); ++i) {
            Vector ss = (Vector)allStates.get(i);
            String name = "SS-" + Integer.toString(i);
            NetworkState newState = NetworkState.extractNetworkStateFromVector(nodeNames, ss, name);
            nts.add(newState);
        }
        return nts;
    }

    private static NetworkState extractNetworkStateFromVector(List<String> nodeNames, Vector ss, String ssName) {
        NetworkState newState = new NetworkState(ssName);
        for (int h = 0; h < ss.size(); ++h) {
            Double val = Double.parseDouble(ss.get(h).toString());
            String nodeName = nodeNames.get(h);
            newState.put(nodeName, new NodeValueState(nodeName, val, val));
        }
        return newState;
    }

    public void addNode(String nodeName, NodeValueState nodeState) {
        this.delegate.put(nodeName, nodeState);
    }

    public List<AbstractGraphNode> fillNodesWithState(List<AbstractGraphNode> nodes, boolean useContinuousStateValue) {
        for (AbstractGraphNode nd : nodes) {
            if (this.delegate.containsKey(nd.getName())) {
                if (useContinuousStateValue) {
                    nd.setInitialState(((NodeValueState)this.delegate.get(nd.getName())).getContinuousValue(), true);
                    continue;
                }
                nd.setInitialState(((NodeValueState)this.delegate.get(nd.getName())).getDiscreteValue(), true);
                continue;
            }
            nd.setInitialState(0.0, true);
        }
        return nodes;
    }

    public SortedMap<String, Double> getNonZeroNodes() {
        TreeMap<String, Double> positiveState = new TreeMap<String, Double>();
        for (String name : this.delegate.keySet()) {
            Double state = ((NodeValueState)this.delegate.get(name)).getContinuousValue();
            if (!(state > 0.0)) continue;
            positiveState.put(name, state);
        }
        return positiveState;
    }

    public String getId() {
        return (String)this.properties.get((Object)"id").value;
    }

    public Comparator<? super String> comparator() {
        return this.delegate.comparator();
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public Set<Map.Entry<String, NodeValueState>> entrySet() {
        return this.delegate.entrySet();
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object arg0) {
        return this.getId().equals(arg0.toString());
    }

    public boolean stateCompare(Object o) {
        NetworkState otherState = (NetworkState)o;
        for (Map.Entry<String, NodeValueState> node : this.entrySet()) {
            double deltaValue;
            if (!(otherState.containsKey(node.getKey()) ? (deltaValue = Math.abs(this.getContinuousValue(node.getKey()) - otherState.getContinuousValue(node.getKey()))) > this.EQUALITY_TRESHOLD : node.getValue().getContinuousValue() > this.EQUALITY_TRESHOLD)) continue;
            return false;
        }
        return true;
    }

    public Double getDiscreteValue(Object key) {
        return ((NodeValueState)this.delegate.get(key)).getDiscreteValue();
    }

    public Double getContinuousValue(Object key) {
        return ((NodeValueState)this.delegate.get(key)).getContinuousValue();
    }

    public void setDiscreteValue(Object key, Double value) {
        NodeValueState vt = (NodeValueState)this.delegate.get(key);
        if (vt != null) {
            vt.setDiscreteValue(value);
        }
    }

    public void setContinuousValue(Object key, Double value) {
        NodeValueState vt = (NodeValueState)this.delegate.get(key);
        if (vt != null) {
            vt.setContinuousValue(value);
        }
    }

    public NodeValueState put(String key, NodeValueState vs) {
        return this.delegate.put(key, vs);
    }

    public void putAll(Map<? extends String, ? extends NodeValueState> m) {
        this.delegate.putAll(m);
    }

    public int size() {
        return this.delegate.size();
    }

    public Collection<NodeValueState> values() {
        return this.delegate.values();
    }

    @Override
    public String getNodeType() {
        return "state";
    }

    @Override
    public String getNodeTypeReadable() {
        return "Network state";
    }

    @Override
    public Map<String, PropertiesMap> getPropertyMaps() {
        return this.properties;
    }

    @Override
    public Element getXmlElement() {
        Element nt = new Element(this.getNodeType());
        for (PropertiesMap propertiesMap : this.properties.values()) {
            nt.getAttributes().add(new Attribute(propertiesMap.propertyName, propertiesMap.value.toString()));
        }
        if (this.delegate.size() > 0) {
            for (Map.Entry entry : this.delegate.entrySet()) {
                Element node = new Element("activenode");
                node.getAttributes().add(new Attribute("id", (String)entry.getKey()));
                node.getAttributes().add(new Attribute("state", ((NodeValueState)entry.getValue()).getContinuousValue().toString()));
                nt.getChildren().add(node);
            }
        }
        return nt;
    }

    @Override
    public void addChildMappableObject(Object child) {
        if (child.getClass().equals(NodeValueState.class)) {
            NodeValueState nt = (NodeValueState)child;
            this.addNode(nt.getId(), nt);
        }
    }
}

