/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.bl.ode;

import cern.colt.matrix.ObjectFactory2D;
import cern.colt.matrix.ObjectMatrix2D;
import java.util.ArrayList;
import java.util.List;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.bl.IEdge;
import org.enfin.squad.dl.GraphContainer;
import org.opensourcephysics.numerics.ODE;

public class AbstractStandardizedODE
implements ODE {
    protected List<AbstractGraphNode> theNodes = new ArrayList<AbstractGraphNode>();
    protected List<IEdge> theEdges = new ArrayList<IEdge>();
    protected int numberOfNodes;
    protected double[] levelOfActivation;
    protected ObjectMatrix2D edgeMatrix;

    public AbstractStandardizedODE(List<AbstractGraphNode> nodes, List<IEdge> edges) {
        this.theNodes.addAll(nodes);
        this.theEdges.addAll(edges);
        this.numberOfNodes = this.theNodes.size();
        this.levelOfActivation = new double[this.numberOfNodes + 1];
        this.levelOfActivation = AbstractStandardizedODE.updateStateFromNodeValues(this.theNodes, this.levelOfActivation);
        this.levelOfActivation[this.numberOfNodes] = 0.0;
        this.edgeMatrix = ObjectFactory2D.sparse.make(this.theNodes.size(), this.theNodes.size());
        for (IEdge grEd : this.theEdges) {
            int startNodeIndex = GraphContainer.getNodeIndexByName(this.theNodes, grEd.getSource());
            int endNodeIndex = GraphContainer.getNodeIndexByName(this.theNodes, grEd.getTarget());
            this.edgeMatrix.set(startNodeIndex, endNodeIndex, (Object)grEd);
        }
    }

    public double getTime() {
        return this.levelOfActivation[this.levelOfActivation.length - 1];
    }

    public double[] getState() {
        return this.levelOfActivation;
    }

    public void getRate(double[] levelOfActivation, double[] rate) {
        for (int nodeIndex = 0; nodeIndex < this.theNodes.size(); ++nodeIndex) {
            IEdge ie;
            int position;
            double totalPositiveInput = 1.0;
            double totalNegativeInput = 1.0;
            List<IEdge> positiveInputs = GraphContainer.getFilteredInputs(this.theNodes.get(nodeIndex), this.theEdges, "positive");
            List<IEdge> negativeInputs = GraphContainer.getFilteredInputs(this.theNodes.get(nodeIndex), this.theEdges, "negative");
            double weightedInput = 0.0;
            double summOfWeights = 0.0;
            double edgeWeight = 0.0;
            for (int j = 0; j < positiveInputs.size(); ++j) {
                position = GraphContainer.getNodeIndexByName(this.theNodes, positiveInputs.get(j).getSource());
                ie = (IEdge)this.edgeMatrix.get(position, nodeIndex);
                edgeWeight = ie.getWeight();
                weightedInput += edgeWeight * levelOfActivation[position];
                summOfWeights += ie.getWeight().doubleValue();
            }
            if (positiveInputs.size() > 0) {
                totalPositiveInput = (1.0 + summOfWeights) / summOfWeights * (weightedInput / (1.0 + weightedInput));
            }
            weightedInput = 0.0;
            summOfWeights = 0.0;
            edgeWeight = 0.0;
            for (int f = 0; f < negativeInputs.size(); ++f) {
                position = GraphContainer.getNodeIndexByName(this.theNodes, negativeInputs.get(f).getSource());
                ie = (IEdge)this.edgeMatrix.get(position, nodeIndex);
                edgeWeight = ie.getWeight();
                weightedInput += edgeWeight * levelOfActivation[position];
                summOfWeights += ie.getWeight().doubleValue();
            }
            if (negativeInputs.size() > 0) {
                totalNegativeInput = 1.0 - (1.0 + summOfWeights) / summOfWeights * (weightedInput / (1.0 + weightedInput));
            }
            double omega = totalPositiveInput * totalNegativeInput;
            double h = this.theNodes.get(nodeIndex).getGain();
            double upperTerm = -Math.exp(0.5 * h) + Math.exp(-h * (omega - 0.5));
            upperTerm = this.testValue(upperTerm);
            double lowerTerm = (1.0 - Math.exp(0.5 * h)) * (1.0 + Math.exp(-h * (omega - 0.5)));
            lowerTerm = this.testValue(lowerTerm);
            rate[nodeIndex] = negativeInputs.size() == 0 && positiveInputs.size() == 0 ? -(this.theNodes.get(nodeIndex).getDecay() * levelOfActivation[nodeIndex]) : upperTerm / lowerTerm - this.theNodes.get(nodeIndex).getDecay() * levelOfActivation[nodeIndex];
        }
        rate[this.numberOfNodes] = 1.0;
    }

    public static double[] updateStateFromNodeValues(List<AbstractGraphNode> nodes, double[] currentState) {
        for (int m = 0; m < nodes.size(); ++m) {
            currentState[m] = nodes.get(m).getState();
        }
        return currentState;
    }

    public List<AbstractGraphNode> updateNodesWithStateValues(List<AbstractGraphNode> nodes) {
        for (int m = 0; m < nodes.size(); ++m) {
            nodes.get(m).setState(this.getState()[m]);
        }
        return nodes;
    }

    private Double testValue(Double refValue) {
        if (Double.isInfinite(refValue)) {
            if (refValue.toString().contains("-")) {
                return 0.0;
            }
            return 1.0;
        }
        return refValue;
    }
}

