/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.bl.ode;

import org.opensourcephysics.numerics.AbstractODESolver;
import org.opensourcephysics.numerics.ODE;

public class RK4NegativeCorrection
extends AbstractODESolver {
    private double[] rate1;
    private double[] rate2;
    private double[] rate3;
    private double[] rate4;
    private double[] estimated_state;

    public RK4NegativeCorrection(ODE ode) {
        super(ode);
    }

    public void initialize(double stepSize) {
        super.initialize(stepSize);
        this.rate1 = new double[this.numEqn];
        this.rate2 = new double[this.numEqn];
        this.rate3 = new double[this.numEqn];
        this.rate4 = new double[this.numEqn];
        this.estimated_state = new double[this.numEqn];
    }

    public double step() {
        int i;
        double[] state = this.ode.getState();
        if (state == null) {
            return this.stepSize;
        }
        if (state.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        this.ode.getRate(state, this.rate1);
        for (i = 0; i < this.numEqn; ++i) {
            this.estimated_state[i] = state[i] + this.stepSize * this.rate1[i] / 2.0;
            this.estimated_state[i] = Math.max(this.estimated_state[i], 0.0);
        }
        this.ode.getRate(this.estimated_state, this.rate2);
        for (i = 0; i < this.numEqn; ++i) {
            this.estimated_state[i] = state[i] + this.stepSize * this.rate2[i] / 2.0;
            this.estimated_state[i] = Math.max(this.estimated_state[i], 0.0);
        }
        this.ode.getRate(this.estimated_state, this.rate3);
        for (i = 0; i < this.numEqn; ++i) {
            this.estimated_state[i] = state[i] + this.stepSize * this.rate3[i];
            this.estimated_state[i] = Math.max(this.estimated_state[i], 0.0);
        }
        this.ode.getRate(this.estimated_state, this.rate4);
        for (i = 0; i < this.numEqn; ++i) {
            state[i] = state[i] + this.stepSize * (this.rate1[i] + 2.0 * this.rate2[i] + 2.0 * this.rate3[i] + this.rate4[i]) / 6.0;
            state[i] = Math.max(state[i], 0.0);
        }
        return this.stepSize;
    }
}

