/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.dl;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.bl.GraphEdge;
import org.enfin.squad.bl.GraphNode;
import org.enfin.squad.bl.IEdge;
import org.enfin.squad.bl.NetworkState;
import org.enfin.squad.dl.MML2IO;
import org.enfin.squad.dl.MMLIO;
import org.enfin.squad.dl.NetIO;
import org.enfin.squad.dl.SBMLIO;
import org.enfin.squad.pl.GraphAnimator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class GraphContainer
implements Cloneable {
    String networkFileName;
    Graph theGraph;
    List<NetworkState> states;
    ArrayList<AbstractGraphNode> nodes;
    ArrayList<IEdge> edges;

    public GraphContainer(String fileName) throws IOException {
        this.networkFileName = fileName;
        this.loadGraphFromFile(fileName);
    }

    private Graph loadGraphFromFile(String fileName) throws IOException {
        block7: {
            try {
                if (fileName.endsWith(".mml")) {
                    SAXBuilder sx = new SAXBuilder();
                    File myFile = new File(fileName);
                    Document doc = sx.build(myFile.toURI().getPath());
                    Element root = doc.getRootElement();
                    if (root.getName().equals("mml") && root.getAttributeValue("level").endsWith("2")) {
                        MML2IO myMML2 = new MML2IO();
                        myMML2.load(fileName);
                        this.theGraph = myMML2.getGraph();
                        this.states = myMML2.getStates();
                    } else {
                        MMLIO mmlFile = new MMLIO();
                        this.theGraph = mmlFile.load(this.networkFileName);
                    }
                    break block7;
                }
                if (fileName.endsWith(".xml")) {
                    SBMLIO sbmlFile = new SBMLIO();
                    this.theGraph = sbmlFile.load(fileName);
                    break block7;
                }
                if (fileName.endsWith(".net")) {
                    NetIO netFile = new NetIO();
                    this.theGraph = NetIO.load(fileName);
                    break block7;
                }
                throw new IOException("The file type is not recognized");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("The file could not be loaded");
            }
        }
        return this.theGraph;
    }

    public static void saveGraphFromFile(Graph gr, List<NetworkState> networkstates, File fileOut, boolean saveCurrentConfiguration) throws IOException {
        try {
            MML2IO.writeToFile(gr, networkstates, fileOut, saveCurrentConfiguration);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("An error occured while saving the file");
        }
    }

    public GraphContainer(Graph aGraph) {
        this.theGraph = aGraph;
    }

    public void displayDirectedGraph() {
        GraphAnimator gr = new GraphAnimator(this.theGraph, GraphAnimator.DEFAULT_COLOR());
        gr.setVisible(true);
    }

    public static List<IEdge> getFilteredInputs(AbstractGraphNode targetNode, List<IEdge> edgeList, String sign) {
        Vector<IEdge> inputs = new Vector<IEdge>();
        for (IEdge ed : edgeList) {
            if (sign != null && !ed.getSign().equalsIgnoreCase(sign) || !ed.getTarget().equalsIgnoreCase(targetNode.getName())) continue;
            inputs.add(ed);
        }
        return inputs;
    }

    public static AbstractGraphNode getNodeByName(List<AbstractGraphNode> nodes, String nodeName) {
        for (AbstractGraphNode nd : nodes) {
            if (!nd.getName().equals(nodeName)) continue;
            return nd;
        }
        return null;
    }

    public static Vertex getVertexByName(String vertexName, Graph gr) {
        for (Vertex vt : gr.getVertices()) {
            if (!vt.getUserDatum((Object)"id").equals(vertexName)) continue;
            return vt;
        }
        return null;
    }

    public static int getNodeIndexByName(List<AbstractGraphNode> nodes, String nodeName) {
        for (int i = 0; i < nodes.size(); ++i) {
            if (!nodes.get(i).getName().equals(nodeName)) continue;
            return i;
        }
        return -1;
    }

    public int getNumberOfNodes() {
        return this.theGraph.getVertices().size();
    }

    public int getNumberOfEdges() {
        return this.theGraph.getEdges().size();
    }

    public String getFileName() {
        return this.networkFileName;
    }

    public Graph getGraph() {
        return this.theGraph;
    }

    public void setGraph(Graph theGraph) {
        this.theGraph = theGraph;
    }

    public List<NetworkState> getStates() {
        return this.states;
    }

    public void setStates(List<NetworkState> states) {
        this.states = states;
    }

    public ArrayList<AbstractGraphNode> getNodes() {
        if (this.nodes == null) {
            this.nodes = GraphNode.getNodesFromGraph(this.getGraph());
        }
        return this.nodes;
    }

    public ArrayList<IEdge> getEdges() {
        if (this.edges == null) {
            this.edges = GraphEdge.getIedgesFromGraph(this.getGraph());
        }
        return this.edges;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class VerticesNameSorter
    implements Comparator<Vertex> {
        @Override
        public int compare(Vertex o1, Vertex o2) {
            return o1.getUserDatum((Object)"id").toString().compareTo(o2.getUserDatum((Object)"id").toString());
        }
    }
}

