/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.dl;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedEdge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.io.GraphFile;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.PredicateUtils;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.collections.Predicate;
import org.enfin.squad.dl.MMLFileHandler;
import org.xml.sax.helpers.DefaultHandler;

public class MMLIO
implements GraphFile {
    private MMLFileHandler theFileHandler;
    protected boolean directed;
    protected boolean undirected;

    public MMLIO() {
        this.theFileHandler = new MMLFileHandler();
    }

    public MMLIO(MMLFileHandler handler) {
        this.theFileHandler = handler;
    }

    public Graph load(String filename) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File(filename), (DefaultHandler)this.theFileHandler);
        }
        catch (Exception e) {
            throw new FatalException("Error loading mml file: " + filename, (Throwable)e);
        }
        return this.theFileHandler.getGraph();
    }

    public List loadGraphCollection(String dirName, FilenameFilter filter) {
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            throw new FatalException("Parameter dirName must be a directory");
        }
        String[] files = dir.list(filter);
        ArrayList<Graph> graphCollection = new ArrayList<Graph>();
        for (int i = 0; i < files.length; ++i) {
            String currentFile = dirName + File.separatorChar + files[i];
            MMLIO graphmlFile = new MMLIO(this.theFileHandler);
            Graph graph = graphmlFile.load(currentFile);
            graphCollection.add(graph);
        }
        return graphCollection;
    }

    public void save(Graph g, String filename) {
        PrintStream out;
        try {
            out = new PrintStream(new FileOutputStream(filename, false));
        }
        catch (Exception e) {
            throw new FatalException("Could not open file \"" + filename + "\" for writing. " + e);
        }
        this.save(g, out);
        out.close();
    }

    public void save(Graph g, PrintStream out) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns/graphml\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  ");
        out.println("xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns/graphml\">");
        out.print("<graph edgedefault=\"");
        boolean directed = PredicateUtils.enforcesEdgeConstraint((ArchetypeGraph)g, (Predicate)Graph.DIRECTED_EDGE);
        boolean undirected = PredicateUtils.enforcesEdgeConstraint((ArchetypeGraph)g, (Predicate)Graph.UNDIRECTED_EDGE);
        if (directed) {
            out.print("directed\" ");
        } else if (undirected) {
            out.print("undirected\" ");
        } else {
            directed = true;
            out.print("directed\" ");
        }
        this.saveUserData((UserDataContainer)g, out);
        out.println(" >");
        this.saveVerticesSection(out, g);
        this.saveEdgesSection(out, g);
        out.println("</graph>");
        out.println("</graphml>");
    }

    private void saveVerticesSection(PrintStream out, Graph g) {
        int numVertices = g.getVertices().size();
        Indexer id = Indexer.getIndexer((ArchetypeGraph)g);
        for (int i = 0; i < numVertices; ++i) {
            Vertex v = (Vertex)id.getVertex(i);
            int vId = i + 1;
            out.print("<node id=\"" + vId + "\" ");
            this.saveUserData((UserDataContainer)v, out);
            out.println("/>");
        }
    }

    private void saveEdgesSection(PrintStream out, Graph g) {
        Indexer id = Indexer.getIndexer((ArchetypeGraph)g);
        for (Edge e : g.getEdges()) {
            Pair p = e.getEndpoints();
            Vertex src = (Vertex)p.getFirst();
            Vertex dest = (Vertex)p.getSecond();
            int srcId = id.getIndex((ArchetypeVertex)src) + 1;
            out.print("<edge source=\"" + srcId + "\" ");
            int destId = id.getIndex((ArchetypeVertex)dest) + 1;
            out.print("target=\"" + destId + "\" ");
            if (this.directed) {
                if (e instanceof UndirectedEdge) {
                    out.print("directed=\"false\"");
                }
            } else if (e instanceof DirectedEdge) {
                out.print("directed=\"true\"");
            }
            this.saveUserData((UserDataContainer)e, out);
            out.println("/>");
        }
    }

    private void saveUserData(UserDataContainer udc, PrintStream out) {
        Iterator udki = udc.getUserDatumKeyIterator();
        while (udki.hasNext()) {
            String datum;
            String key = udki.next().toString();
            if (this.invalidXMLData(key) || this.invalidXMLData(datum = udc.getUserDatum((Object)key).toString())) continue;
            out.print(key + "=\"" + datum + "\" ");
        }
    }

    private boolean invalidXMLData(String str) {
        if (str.indexOf("&") >= 0) {
            return true;
        }
        if (str.indexOf("<") >= 0) {
            return true;
        }
        if (str.indexOf(">") >= 0) {
            return true;
        }
        if (str.indexOf("'") >= 0) {
            return true;
        }
        return str.indexOf("\"") >= 0;
    }

    public void setGraphMLFileHandler(MMLFileHandler fileHandler) {
        this.theFileHandler = fileHandler;
    }
}

