/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.dl;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.utils.UserData;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jigcell.sbml2.Annotations;
import jigcell.sbml2.Model;
import jigcell.sbml2.Reaction;
import jigcell.sbml2.SBMLLevel2Document;
import jigcell.sbml2.SimpleSpeciesReference;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.bl.GraphEdge;
import org.enfin.squad.bl.GraphNode;
import org.enfin.squad.dl.MML2IO;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SBMLIO {
    String parsedFileName = "";

    public Graph load(String fileName) throws IOException {
        Graph theGraph = SBMLIO.parseSBML(fileName);
        return theGraph;
    }

    public static Graph parseSBML(String fileName) throws IOException {
        File fl = new File(fileName);
        DirectedSparseGraph gr = new DirectedSparseGraph();
        HashMap<String, AbstractGraphNode> nodeList = new HashMap<String, AbstractGraphNode>();
        ArrayList<String> edgeNameList = new ArrayList<String>();
        HashMap<String, Point2D.Double> positionList = new HashMap();
        try {
            SBMLLevel2Document document = SBMLLevel2Document.readDocument(fl.getAbsolutePath());
            Model model = document.getModel();
            List reactions = model.getReactions();
            Annotations annoModel = model.getAnnotations();
            if (annoModel.size() > 0) {
                String modelString = annoModel.get(0);
                Pattern pt = Pattern.compile("celldesigner:modelDisplay sizeX=.(\\d+)\" sizeY=.(\\d+).");
                Matcher mt = pt.matcher(modelString);
                if (mt.find()) {
                    Integer sizeX = Integer.parseInt(mt.group(1));
                    Integer sizeY = Integer.parseInt(mt.group(2));
                    gr.addUserDatum((Object)"sizex", (Object)sizeX, UserData.SHARED);
                    gr.addUserDatum((Object)"sizey", (Object)sizeY, UserData.SHARED);
                }
                positionList = SBMLIO.extractNodePositions(annoModel.get(0));
            }
            for (int f = 0; f < reactions.size(); ++f) {
                Reaction myReac = (Reaction)reactions.get(f);
                List reactants = myReac.getReactant();
                List products = myReac.getProduct();
                List modifiers = myReac.getModifier();
                for (int x = 0; x < products.size(); ++x) {
                    AbstractGraphNode startNode;
                    int posEnd;
                    int posStart;
                    AbstractGraphNode endNode = SBMLIO.createOrGetVertex((Graph)gr, products, nodeList, positionList, model, x);
                    String ann = myReac.getAnnotations().get(0);
                    String sbmlEdgeTypeString = ann.substring(posStart = ann.indexOf("<celldesigner:reactionType>") + 27, posEnd = ann.indexOf("</celldesigner:reactionType>")).trim();
                    String edgeType = sbmlEdgeTypeString.contains("INHIBITION") ? "negative" : "positive";
                    if (reactants != null) {
                        for (int y = 0; y < reactants.size(); ++y) {
                            startNode = SBMLIO.createOrGetVertex((Graph)gr, reactants, nodeList, positionList, model, y);
                            SBMLIO.createEdge((Graph)gr, startNode, endNode, edgeType, edgeNameList);
                        }
                    }
                    if (modifiers == null) continue;
                    for (int z = 0; z < modifiers.size(); ++z) {
                        startNode = SBMLIO.createOrGetVertex((Graph)gr, modifiers, nodeList, positionList, model, z);
                        SBMLIO.createEdge((Graph)gr, startNode, endNode, edgeType, edgeNameList);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("An error occurred while parsing the SBML file");
        }
        return gr;
    }

    private static AbstractGraphNode createOrGetVertex(Graph gr, List modifiers, HashMap<String, AbstractGraphNode> nodeList, HashMap<String, Point2D.Double> positionList, Model model, int indexOfSpecies) {
        AbstractGraphNode startNode;
        SimpleSpeciesReference refStartModif = (SimpleSpeciesReference)modifiers.get(indexOfSpecies);
        String refStartName = refStartModif.getSpecies(model).getName().trim();
        if (!nodeList.containsKey(refStartName = refStartName.replaceAll("\\s{1,}", "_").trim())) {
            startNode = new GraphNode(refStartName, 1.0, 10.0);
            nodeList.put(refStartName, startNode);
            Vertex vt = gr.addVertex(startNode.getVertex());
            Point2D.Double position = SBMLIO.getNodePosition(SBMLIO.getAlias(refStartModif), positionList);
            if (position != null) {
                vt.addUserDatum((Object)"posx", (Object)position.x, UserData.SHARED);
                vt.addUserDatum((Object)"posy", (Object)position.y, UserData.SHARED);
            }
        } else {
            startNode = nodeList.get(refStartName);
        }
        return startNode;
    }

    private static HashMap<String, Point2D.Double> extractNodePositions(String annotations) {
        HashMap<String, Point2D.Double> listNodePositions = new HashMap<String, Point2D.Double>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().parse(new InputSource(new StringReader(annotations)));
            Node node = doc.importNode(doc.getDocumentElement(), true);
            NodeList specRefList = node.getChildNodes().item(4).getChildNodes();
            for (int x = 0; x < specRefList.getLength(); ++x) {
                Node nd = specRefList.item(x);
                if (!nd.getNodeName().equals("celldesigner:speciesAlias")) continue;
                String speciesAlias = nd.getAttributes().getNamedItem("id").getNodeValue();
                for (int y = 0; y < nd.getChildNodes().getLength(); ++y) {
                    if (!nd.getChildNodes().item(y).getNodeName().equals("celldesigner:bounds")) continue;
                    Node bounds = nd.getChildNodes().item(y);
                    Double width = Double.parseDouble(bounds.getAttributes().getNamedItem("w").getNodeValue());
                    Double height = Double.parseDouble(bounds.getAttributes().getNamedItem("h").getNodeValue());
                    Double xpos = Double.parseDouble(bounds.getAttributes().getNamedItem("x").getNodeValue()) + width / 2.0;
                    Double ypos = Double.parseDouble(bounds.getAttributes().getNamedItem("y").getNodeValue()) + height / 2.0;
                    listNodePositions.put(speciesAlias, new Point2D.Double(xpos, ypos));
                }
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return listNodePositions;
    }

    private static Point2D.Double getNodePosition(String nodeAlias, HashMap<String, Point2D.Double> positionList) {
        return positionList.get(nodeAlias);
    }

    private static String getAlias(SimpleSpeciesReference sp) {
        if (sp.getAnnotations().size() > 0) {
            String ann = sp.getAnnotations().get(0);
            Pattern pt = Pattern.compile("celldesigner:alias.(s.\\d*).+celldesigner:alias");
            Matcher mt = pt.matcher(ann);
            if (mt.find()) {
                return mt.group(1);
            }
            return null;
        }
        return null;
    }

    private static void createEdge(Graph gr, AbstractGraphNode startNode, AbstractGraphNode endNode, String edgeType, ArrayList<String> edgeNameList) {
        GraphEdge newEdge = new GraphEdge(startNode, endNode, edgeType, 1.0);
        if (!edgeNameList.contains(newEdge.getDescription())) {
            edgeNameList.add(newEdge.getDescription());
            gr.addEdge(newEdge.getEdge());
        }
    }

    public static void outputToMML(String sbmlFileName, File fileOut) throws IOException {
        SBMLIO sb = new SBMLIO();
        Graph gr = SBMLIO.parseSBML(sbmlFileName);
        MML2IO.writeToFile(gr, null, fileOut, false);
    }

    public String getParsedDataFileName() {
        return this.parsedFileName;
    }
}

