/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.dl;

import com.tlabs.dcolt.DecoratedDoubleMatrix2D;
import com.tlabs.dcolt.DynamicDoubleFactory2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class TabSeparatedDataFile {
    private String fullFileName;

    public TabSeparatedDataFile(String fileName) {
        this.fullFileName = fileName;
    }

    public DecoratedDoubleMatrix2D readMatrix() throws IOException {
        DecoratedDoubleMatrix2D matrx = DynamicDoubleFactory2D.fulldynamic_dense.makeDecorated(0, 0);
        Vector rawData = new Vector();
        BufferedReader inputData = null;
        try {
            inputData = new BufferedReader(new FileReader(this.fullFileName));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        int lineNumber = 0;
        ArrayList<String> titles = new ArrayList<String>();
        try {
            String line;
            while ((line = inputData.readLine()) != null) {
                StringTokenizer tokens;
                Vector oneRow;
                if (lineNumber == 0) {
                    oneRow = new Vector();
                    tokens = new StringTokenizer(line);
                    while (tokens.hasMoreTokens()) {
                        titles.add(tokens.nextToken().toString());
                    }
                    matrx.extendTo(0, titles.size());
                    matrx.setColumnHeaders(titles);
                } else {
                    oneRow = new Vector();
                    tokens = new StringTokenizer(line);
                    matrx.extendTo(matrx.rows() + 1, matrx.columns());
                    int tokenCounter = 0;
                    while (tokens.hasMoreTokens()) {
                        matrx.set(lineNumber - 1, tokenCounter, Double.parseDouble(tokens.nextToken().toString()));
                        ++tokenCounter;
                    }
                }
                ++lineNumber;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            inputData.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return matrx;
    }

    public void writeMatrix(DecoratedDoubleMatrix2D fullData) throws IOException {
        TabSeparatedDataFile.writeMatrix(fullData, this.fullFileName);
    }

    public static BufferedWriter writeMatrix(DecoratedDoubleMatrix2D fullData, String fullFileName) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(fullFileName));
        String headers = "";
        for (Object colName : fullData.getColumnHeaders()) {
            headers = headers + colName.toString() + "\t";
        }
        headers = headers.trim();
        out.write(headers + "\n");
        String data = "";
        for (int row = 0; row < fullData.rows(); ++row) {
            data = "";
            for (int column = 0; column < fullData.columns(); ++column) {
                data = data + String.valueOf(fullData.get(row, column)) + "\t";
            }
            data = data.trim();
            out.write(data + "\n");
        }
        out.close();
        return out;
    }

    public Vector read() {
        Vector rawData = new Vector();
        BufferedReader inputData = null;
        try {
            inputData = new BufferedReader(new FileReader(this.fullFileName));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        try {
            String line;
            while ((line = inputData.readLine()) != null) {
                Vector<String> oneRow = new Vector<String>();
                StringTokenizer tokens = new StringTokenizer(line);
                while (tokens.hasMoreTokens()) {
                    oneRow.add(tokens.nextToken());
                }
                rawData.add(oneRow);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            inputData.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return rawData;
    }

    public void write(Vector fullData) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.fullFileName));
            for (int row = 0; row < fullData.size(); ++row) {
                Vector oneRow = (Vector)fullData.get(row);
                for (int column = 0; column < oneRow.size(); ++column) {
                    out.write(oneRow.get(column).toString() + "\t");
                }
                out.write("\n");
            }
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

