/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.perturbations.bl;

import com.tlabs.dcolt.DynamicDoubleMatrix2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.enfin.squad.bl.IObserver;
import org.enfin.squad.bl.ode.ODESystemSolver;
import org.enfin.squad.dl.GraphContainer;
import org.enfin.squad.perturbations.bl.Perturbator;
import org.enfin.squad.perturbations.bl.Protocol;

public class ODESytemSolverPoolPerturbation
extends ArrayList<ODESystemSolver> {
    private static final long serialVersionUID = 1L;
    private Protocol prot;
    private GraphContainer originalGrCont;

    public ODESytemSolverPoolPerturbation(GraphContainer gr, Protocol prot) throws IOException {
        this.originalGrCont = gr;
        this.prot = prot;
        this.initialize();
    }

    public void initialize() throws IOException {
        try {
            for (Perturbator pert : this.prot.getPerturbations()) {
                pert.initialize();
                GraphContainer grNew = (GraphContainer)this.originalGrCont.clone();
                ODESystemSolver OdeSim = new ODESystemSolver(grNew, pert);
                this.add(OdeSim);
                OdeSim.initialize();
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public void runSimulation(boolean stopAtSteadyState, Integer maxTime, Integer timeSlices) {
        for (ODESystemSolver sim : this) {
            if (stopAtSteadyState) {
                sim.setStopAtSteadyState(true);
            } else {
                sim.setStopAtSteadyState(false);
                sim.setTimeMax(maxTime);
                sim.setSlicesPerUnit(timeSlices);
            }
            sim.runSync();
        }
    }

    public void startStepSimulation(int initialSpeed) {
        for (ODESystemSolver sim : this) {
            sim.setStepDelay(initialSpeed);
            sim.start();
        }
    }

    public void stopStepSimulation() {
        for (ODESystemSolver sim : this) {
            sim.stop();
        }
    }

    public void reset() {
        for (ODESystemSolver sim : this) {
            sim.removeObserver(null);
        }
        try {
            this.initialize();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void registerObserver(IObserver observer) {
        for (ODESystemSolver sim : this) {
            sim.registerObserver(observer);
        }
    }

    public void removeObserver(IObserver observer) {
        for (ODESystemSolver sim : this) {
            sim.removeObserver(observer);
        }
    }

    public void updateDelayTime(int value) {
        for (ODESystemSolver sim : this) {
            sim.setStepDelay(value);
        }
    }

    public Map<String, DynamicDoubleMatrix2D> getResults() {
        HashMap<String, DynamicDoubleMatrix2D> res = new HashMap<String, DynamicDoubleMatrix2D>();
        for (int p = 0; p < this.prot.getPerturbations().size(); ++p) {
            res.put(this.prot.getPerturbations().get(p).getId(), ((ODESystemSolver)this.get(p)).getResults());
        }
        return res;
    }

    public void displayNodes(String nodeName, boolean display) {
        int nodeIndex = ((ODESystemSolver)this.get(0)).getNodes().indexOf(nodeName);
        for (ODESystemSolver od : this) {
            od.getNodes().get(nodeIndex).setVisible(display);
        }
    }

    public void dispose() {
        for (ODESystemSolver ds : this) {
            ds.dispose();
        }
    }
}

