/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.perturbations.bl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.enfin.squad.bl.NetworkState;
import org.enfin.squad.bl.NodeValueState;
import org.enfin.squad.dl.GraphContainer;
import org.enfin.squad.dl.MML2IO;
import org.enfin.squad.perturbations.bl.AbstractGraphAction;
import org.enfin.squad.perturbations.bl.GraphActionTimeConstant;
import org.enfin.squad.perturbations.bl.GraphActionTimePulse;
import org.enfin.squad.perturbations.bl.GraphActionTimeRange;
import org.enfin.squad.perturbations.bl.Perturbator;
import org.enfin.squad.perturbations.bl.Protocol;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ProtocolFactory {
    public static void main(String[] args) {
        try {
            Protocol pert = ProtocolFactory.generate("samples/2states_perturbation.xml");
            for (Perturbator p : pert) {
                System.out.println("initial state " + p.getInitialState().entrySet().toString());
                for (AbstractGraphAction act : p.getActionNodes()) {
                    System.out.println(act.getDescription());
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Protocol generate(String protocolFileName) throws Exception {
        ArrayList<NetworkState> initial_statesList = new ArrayList<NetworkState>();
        ArrayList<Perturbator> allPerturbations = new ArrayList<Perturbator>();
        SAXBuilder sx = new SAXBuilder();
        File input = new File(protocolFileName);
        Document doc = sx.build(input);
        Element root = doc.getRootElement();
        try {
            Element intialStateRoot = (Element)root.getChildren("states").get(0);
            List states = intialStateRoot.getChildren();
            for (int p = 0; p < states.size(); ++p) {
                initial_statesList.add(MML2IO.parseState((Element)states.get(p)));
            }
        }
        catch (RuntimeException e) {
            throw new Exception("An error occurred while parsing the initial states list of the perturbation file", e);
        }
        try {
            Element perturbationRoot = (Element)root.getChildren("perturbations").get(0);
            List perturbations = perturbationRoot.getChildren();
            for (int f = 0; f < perturbations.size(); ++f) {
                allPerturbations.add(ProtocolFactory.parsePerturBation((Element)perturbations.get(f), initial_statesList));
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new Exception("An error occurred while parsing the perturbation list", e);
        }
        Protocol prt = new Protocol(allPerturbations, initial_statesList);
        return prt;
    }

    public static Protocol generateDefaultProtocol(GraphContainer gr) {
        Map<String, NetworkState> states = ProtocolFactory.getDefaultNetworkStateList(gr);
        ArrayList<Perturbator> pts = new ArrayList<Perturbator>(ProtocolFactory.getDefaultPerturbationList(gr, new ArrayList<NetworkState>(states.values())).values());
        Protocol pt = new Protocol(pts, new ArrayList<NetworkState>(states.values()));
        return pt;
    }

    public static HashMap<String, AbstractGraphAction> getDefaultActions(GraphContainer gr) {
        HashMap<String, AbstractGraphAction> defaultActionList = new HashMap<String, AbstractGraphAction>();
        defaultActionList.put("new Single Pulse", new GraphActionTimePulse(gr.getNodes().get(0).getName(), "state", 2.0, 1.0));
        defaultActionList.put("new Constant Pulse", new GraphActionTimeConstant(gr.getNodes().get(0).getName(), "state", 2.0, 1.0));
        defaultActionList.put("new Time-range Pulse", new GraphActionTimeRange(gr.getNodes().get(0).getName(), "state", 2.0, 5.0, 1.0));
        return defaultActionList;
    }

    public static Map<String, NetworkState> getDefaultNetworkStateList(GraphContainer gr) {
        HashMap<String, NetworkState> defaulNetworkStateList = new HashMap<String, NetworkState>();
        if (gr.getStates() != null && gr.getStates().size() > 0) {
            defaulNetworkStateList.put("new Initial state", new NetworkState("State1"));
            for (NetworkState nt : gr.getStates()) {
                defaulNetworkStateList.put("copy of state [" + nt.getId() + "]", nt);
            }
        } else {
            defaulNetworkStateList.put("new Initial state", new NetworkState("State1"));
        }
        return defaulNetworkStateList;
    }

    public static Map<String, Perturbator> getDefaultPerturbationList(GraphContainer gr, List<NetworkState> states) {
        HashMap<String, Perturbator> defaultPerturbationList = new HashMap<String, Perturbator>();
        defaultPerturbationList.put("new Pertutbation", new Perturbator(states.get(0), "Perturbation1"));
        return defaultPerturbationList;
    }

    public static Map<String, NodeValueState> getDefaultActiveNodeList(GraphContainer gr) {
        HashMap<String, NodeValueState> defaultActiveNodeList = new HashMap<String, NodeValueState>();
        defaultActiveNodeList.put("new active node", new NodeValueState(gr.getNodes().get(0).getName(), 1.0));
        return defaultActiveNodeList;
    }

    private static Perturbator parsePerturBation(Element perturbationNode, List<NetworkState> initial_statesList) throws Exception {
        String name = perturbationNode.getAttributeValue("id");
        String initialNetId = perturbationNode.getAttributeValue("initialstate");
        NetworkState nt = null;
        for (NetworkState myNts : initial_statesList) {
            if (!myNts.getId().equals(initialNetId)) continue;
            nt = myNts;
            break;
        }
        Perturbator pert = new Perturbator(nt, name);
        List activenodes = perturbationNode.getChildren();
        for (Element actN : activenodes) {
            pert.addActionNode(ProtocolFactory.generateActionNode(actN));
        }
        return pert;
    }

    private static AbstractGraphAction generateActionNode(Element actNode) throws Exception {
        AbstractGraphAction igr = null;
        if (actNode.getName().equals("singlepulse")) {
            String target = actNode.getAttributeValue("target");
            Double time = Double.parseDouble(actNode.getAttributeValue("time"));
            Double newValue = Double.parseDouble(actNode.getAttributeValue("value"));
            String parameterName = actNode.getAttributeValue("parameter");
            igr = new GraphActionTimePulse(target, parameterName, time, newValue);
        } else if (actNode.getName().equals("rangepulse")) {
            String target = actNode.getAttributeValue("target");
            Double timeStart = Double.parseDouble(actNode.getAttributeValue("timestart"));
            Double timeEnd = Double.parseDouble(actNode.getAttributeValue("timestop"));
            Double newValue = Double.parseDouble(actNode.getAttributeValue("value"));
            String parameterName = actNode.getAttributeValue("parameter");
            igr = new GraphActionTimeRange(target, parameterName, timeStart, timeEnd, newValue);
        } else if (actNode.getName().equals("constantpulse")) {
            String target = actNode.getAttributeValue("target");
            Double time = Double.parseDouble(actNode.getAttributeValue("time"));
            Double newValue = Double.parseDouble(actNode.getAttributeValue("value"));
            String parameterName = actNode.getAttributeValue("parameter");
            igr = new GraphActionTimeConstant(target, parameterName, time, newValue);
        } else {
            igr = null;
        }
        return igr;
    }
}

