/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.pl;

import cern.colt.matrix.DoubleMatrix1D;
import com.tlabs.dcolt.DecoratedDoubleMatrix2D;
import de.javasoft.plaf.synthetica.SyntheticaStandardLookAndFeel;
import java.awt.AWTException;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferStrategy;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.bl.IObservable;
import org.enfin.squad.bl.IObserver;
import org.enfin.squad.bl.ode.ODESystemSolver;
import org.enfin.squad.dl.TabSeparatedDataFile;
import org.enfin.squad.pl.LegendEntry;
import org.enfin.squad.pl.LineColorDispatcher;
import org.enfin.squad.pl.PlotColorDataContainer;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.axes.DrawableAxes;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.tools.DatasetTool;

public class PlotFrameDisplay
implements IObserver {
    public SortedMap<String, Integer> datasetList = new TreeMap<String, Integer>();
    private JPanel legend;
    private JScrollPane scroll;
    private PlotFrame delegate;
    private Container parentComp;
    private boolean colorByName = false;
    private JSplitPane splitter;
    DecoratedDoubleMatrix2D rawData;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new SyntheticaStandardLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlotFrameDisplay plt = new PlotFrameDisplay("A", "B", "C", null);
                plt.setVisible(true);
                plt.setConnected(true);
                Random r = new Random();
                plt.getDatasetManager().setXYColumnNames(0, "time", "Alpha");
                for (int x = 0; x < 200; ++x) {
                    String token = Long.toString(Math.abs(r.nextLong()), 36);
                    plt.append(token, x, Math.sin(x));
                }
            }
        });
    }

    public PlotFrameDisplay(String xAxisName, String yAxisName, String plotName, Container parent) {
        this.delegate = new PlotFrame(xAxisName, yAxisName, plotName);
        this.parentComp = parent;
        this.setupDisplay();
    }

    public PlotFrameDisplay(String fileName) throws IOException {
        this("state", "time", "", null);
        this.getDataMatrix(fileName);
        this.buildPlot();
    }

    public PlotFrameDisplay(DecoratedDoubleMatrix2D data) {
        this("state", "time", "", null);
        this.rawData = data;
        this.buildPlot();
    }

    public JInternalFrame getAsInternalFrame(boolean displayLegend) {
        JInternalFrame jt = new JInternalFrame(this.delegate.getTitle());
        jt.getContentPane().setLayout(new BorderLayout());
        jt.setSize(this.delegate.getSize());
        jt.getContentPane().add((Component)this.delegate.getJMenuBar(), "North");
        jt.getContentPane().add((Component)this.delegate.getDrawingPanel(), "Center");
        if (displayLegend) {
            jt.getContentPane().add((Component)this.scroll, "South");
        }
        jt.pack();
        return jt;
    }

    private void buildPlot() {
        DoubleMatrix1D timeColumn = this.rawData.viewColumn(0);
        Integer i = 1;
        while (i < this.rawData.columns()) {
            String seriesName = this.rawData.getColumnHeaders().get(i).toString();
            DoubleMatrix1D seriesData = this.rawData.viewColumn(i);
            for (int j = 0; j < seriesData.size(); ++j) {
                this.append(seriesName, timeColumn.get(j), seriesData.get(j));
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    private void getDataMatrix(String fileName) throws IOException {
        TabSeparatedDataFile inputData = new TabSeparatedDataFile(fileName);
        this.rawData = inputData.readMatrix();
    }

    @Override
    public void updateObserver(IObservable obsvble, Object args) {
        if (obsvble.getClass() == ODESystemSolver.class) {
            ODESystemSolver OdeSolv = (ODESystemSolver)obsvble;
            Double currentTime = OdeSolv.getCurrentSimulationTime();
            for (AbstractGraphNode nd : ((ODESystemSolver)obsvble).getNodes()) {
                if (!nd.isVisible()) continue;
                this.append(nd.getName(), currentTime, nd.getState());
            }
            this.repaint();
        }
    }

    private void addToLegend(String name, Color lineColor, Color markerColor, Shape markerShape) {
        LegendEntry lg = new LegendEntry(name, lineColor, markerColor, markerShape);
        this.legend.add(lg);
        this.legend.setPreferredSize(new Dimension(this.scroll.getWidth(), this.legend.getComponentCount() / 3 * (this.legend.getComponent(0).getHeight() + 8)));
        this.scroll.validate();
    }

    public JScrollPane getLegendFrame() {
        return this.scroll;
    }

    public void append(String datasetName, double arg1, double arg2) {
        if (!this.datasetList.containsKey(datasetName)) {
            int datasetKey = this.datasetList.size();
            this.datasetList.put(datasetName, datasetKey);
            this.delegate.append(datasetKey, arg1, arg2);
            Dataset dt = (Dataset)this.delegate.getDatasetManager().getDatasets().get(datasetKey);
            dt.setName(datasetName);
            dt.setConnected(true);
            PlotColorDataContainer ptCol = this.colorByName ? LineColorDispatcher.getPlotColorDataFromName(datasetName) : LineColorDispatcher.getPlotColorDataFromIndex(datasetKey);
            dt.setLineColor(ptCol.lineColor);
            dt.setMarkerColor(ptCol.markerColor);
            dt.setCustomMarker(ptCol.markerShape);
            this.addToLegend(datasetName, dt.getLineColor(), dt.getFillColor(), ptCol.legendrShape);
        } else {
            int datasetKey = (Integer)this.datasetList.get(datasetName);
            this.delegate.append(datasetKey, arg1, arg2);
        }
    }

    public void showDataset(int DatasetIndex) {
        DatasetTool tl = new DatasetTool(this.getDataset(0));
        tl.setVisible(true);
    }

    private void setupDisplay() {
        this.legend = new JPanel();
        this.legend.setLayout(new FlowLayout(0));
        this.legend.setBackground(Color.white);
        this.scroll = new JScrollPane(this.legend);
        this.setLayout(new BorderLayout());
        this.splitter = new JSplitPane(0);
        this.splitter.setResizeWeight(0.7);
        this.splitter.setDividerSize(2);
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.splitter, "Center");
        if (this.parentComp != null) {
            this.delegate.setLocation(this.parentComp.getX() + this.parentComp.getWidth() + 1, this.parentComp.getY());
        }
        DrawingPanel dr = this.delegate.getDrawingPanel();
        dr.limitAutoscaleY(0.0, 1.0);
        dr.limitAutoscaleX(0.0, Double.NaN);
        dr.setAntialiasShapeOn(true);
        dr.setAntialiasTextOn(true);
        dr.setBackground(Color.white);
        this.delegate.setSize(new Dimension(600, 500));
        dr.setMinimumSize(new Dimension(0, 0));
        this.legend.setPreferredSize(new Dimension(600, 100));
        this.scroll.setPreferredSize(new Dimension(600, 100));
        this.scroll.setAutoscrolls(true);
        this.splitter.setTopComponent((Component)dr);
        this.splitter.setBottomComponent(this.scroll);
    }

    public void clearDatasets() {
        this.getDatasetManager().clear();
    }

    public Component add(Component comp, int index) {
        return this.delegate.add(comp, index);
    }

    public void add(Component comp, Object constraints, int index) {
        this.delegate.add(comp, constraints, index);
    }

    public void add(Component comp, Object constraints) {
        this.delegate.add(comp, constraints);
    }

    public Component add(Component comp) {
        return this.delegate.add(comp);
    }

    public void add(PopupMenu popup) {
        this.delegate.add(popup);
    }

    public Component add(String name, Component comp) {
        return this.delegate.add(name, comp);
    }

    public JButton addButton(String arg0, String arg1, String arg2, Object arg3) {
        return this.delegate.addButton(arg0, arg1, arg2, arg3);
    }

    public void addComponentListener(ComponentListener l) {
        this.delegate.addComponentListener(l);
    }

    public void addContainerListener(ContainerListener l) {
        this.delegate.addContainerListener(l);
    }

    public void addDrawable(Drawable arg0) {
        this.delegate.addDrawable(arg0);
    }

    public void addFocusListener(FocusListener l) {
        this.delegate.addFocusListener(l);
    }

    public void addHierarchyBoundsListener(HierarchyBoundsListener l) {
        this.delegate.addHierarchyBoundsListener(l);
    }

    public void addHierarchyListener(HierarchyListener l) {
        this.delegate.addHierarchyListener(l);
    }

    public void addInputMethodListener(InputMethodListener l) {
        this.delegate.addInputMethodListener(l);
    }

    public void addKeyListener(KeyListener l) {
        this.delegate.addKeyListener(l);
    }

    public void addMouseListener(MouseListener l) {
        this.delegate.addMouseListener(l);
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        this.delegate.addMouseMotionListener(l);
    }

    public void addMouseWheelListener(MouseWheelListener l) {
        this.delegate.addMouseWheelListener(l);
    }

    public void addNotify() {
        this.delegate.addNotify();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.delegate.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.delegate.addPropertyChangeListener(propertyName, listener);
    }

    public void addWindowFocusListener(WindowFocusListener l) {
        this.delegate.addWindowFocusListener(l);
    }

    public void addWindowListener(WindowListener l) {
        this.delegate.addWindowListener(l);
    }

    public void addWindowStateListener(WindowStateListener l) {
        this.delegate.addWindowStateListener(l);
    }

    public void applyComponentOrientation(ComponentOrientation o) {
        this.delegate.applyComponentOrientation(o);
    }

    public boolean areFocusTraversalKeysSet(int id) {
        return this.delegate.areFocusTraversalKeysSet(id);
    }

    public void bufferStrategyShow() {
        this.delegate.bufferStrategyShow();
    }

    public int checkImage(Image image, ImageObserver observer) {
        return this.delegate.checkImage(image, observer);
    }

    public int checkImage(Image image, int width, int height, ImageObserver observer) {
        return this.delegate.checkImage(image, width, height, observer);
    }

    public void clearData() {
        this.delegate.clearData();
    }

    public void clearDataAndRepaint() {
        this.delegate.clearDataAndRepaint();
    }

    public void clearDrawables() {
        this.delegate.clearDrawables();
    }

    public boolean contains(int x, int y) {
        return this.delegate.contains(x, y);
    }

    public boolean contains(Point p) {
        return this.delegate.contains(p);
    }

    public void createBufferStrategy() {
        this.delegate.createBufferStrategy();
    }

    public void createBufferStrategy(int numBuffers, BufferCapabilities caps) throws AWTException {
        this.delegate.createBufferStrategy(numBuffers, caps);
    }

    public void createBufferStrategy(int numBuffers) {
        this.delegate.createBufferStrategy(numBuffers);
    }

    public Image createImage(ImageProducer producer) {
        return this.delegate.createImage(producer);
    }

    public Image createImage(int width, int height) {
        return this.delegate.createImage(width, height);
    }

    public VolatileImage createVolatileImage(int width, int height, ImageCapabilities caps) throws AWTException {
        return this.delegate.createVolatileImage(width, height, caps);
    }

    public VolatileImage createVolatileImage(int width, int height) {
        return this.delegate.createVolatileImage(width, height);
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public void doLayout() {
        this.delegate.doLayout();
    }

    public void enableInputMethods(boolean enable) {
        this.delegate.enableInputMethods(enable);
    }

    public boolean equals(Object arg0) {
        return this.delegate.equals(arg0);
    }

    public Component findComponentAt(int x, int y) {
        return this.delegate.findComponentAt(x, y);
    }

    public Component findComponentAt(Point p) {
        return this.delegate.findComponentAt(p);
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        this.delegate.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        this.delegate.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.delegate.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        this.delegate.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        this.delegate.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        this.delegate.firePropertyChange(propertyName, oldValue, newValue);
    }

    public AccessibleContext getAccessibleContext() {
        return this.delegate.getAccessibleContext();
    }

    public float getAlignmentX() {
        return this.delegate.getAlignmentX();
    }

    public float getAlignmentY() {
        return this.delegate.getAlignmentY();
    }

    public DrawableAxes getAxes() {
        return this.delegate.getAxes();
    }

    public Color getBackground() {
        return this.delegate.getBackground();
    }

    public Rectangle getBounds() {
        return this.delegate.getBounds();
    }

    public Rectangle getBounds(Rectangle rv) {
        return this.delegate.getBounds(rv);
    }

    public BufferStrategy getBufferStrategy() {
        return this.delegate.getBufferStrategy();
    }

    public ColorModel getColorModel() {
        return this.delegate.getColorModel();
    }

    public Component getComponent(int n) {
        return this.delegate.getComponent(n);
    }

    public Component getComponentAt(int x, int y) {
        return this.delegate.getComponentAt(x, y);
    }

    public Component getComponentAt(Point p) {
        return this.delegate.getComponentAt(p);
    }

    public int getComponentCount() {
        return this.delegate.getComponentCount();
    }

    public ComponentListener[] getComponentListeners() {
        return this.delegate.getComponentListeners();
    }

    public ComponentOrientation getComponentOrientation() {
        return this.delegate.getComponentOrientation();
    }

    public Component[] getComponents() {
        return this.delegate.getComponents();
    }

    public ThreadGroup getConstructorThreadGroup() {
        return this.delegate.getConstructorThreadGroup();
    }

    public ContainerListener[] getContainerListeners() {
        return this.delegate.getContainerListeners();
    }

    public Container getContentPane() {
        return this.delegate.getContentPane();
    }

    public Cursor getCursor() {
        return this.delegate.getCursor();
    }

    public Dataset getDataset(int arg0) {
        return this.delegate.getDataset(arg0);
    }

    public DatasetManager getDatasetManager() {
        return this.delegate.getDatasetManager();
    }

    public int getDefaultCloseOperation() {
        return this.delegate.getDefaultCloseOperation();
    }

    public ArrayList getDrawables() {
        return this.delegate.getDrawables();
    }

    public ArrayList getDrawables(Class arg0) {
        return this.delegate.getDrawables(arg0);
    }

    public DrawingPanel getDrawingPanel() {
        return this.delegate.getDrawingPanel();
    }

    public DropTarget getDropTarget() {
        return this.delegate.getDropTarget();
    }

    public int getExtendedState() {
        return this.delegate.getExtendedState();
    }

    public boolean getFocusableWindowState() {
        return this.delegate.getFocusableWindowState();
    }

    public Container getFocusCycleRootAncestor() {
        return this.delegate.getFocusCycleRootAncestor();
    }

    public FocusListener[] getFocusListeners() {
        return this.delegate.getFocusListeners();
    }

    public Component getFocusOwner() {
        return this.delegate.getFocusOwner();
    }

    public Set<AWTKeyStroke> getFocusTraversalKeys(int id) {
        return this.delegate.getFocusTraversalKeys(id);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return this.delegate.getFocusTraversalKeysEnabled();
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        return this.delegate.getFocusTraversalPolicy();
    }

    public Font getFont() {
        return this.delegate.getFont();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.delegate.getFontMetrics(font);
    }

    public Color getForeground() {
        return this.delegate.getForeground();
    }

    public Component getGlassPane() {
        return this.delegate.getGlassPane();
    }

    public Graphics getGraphics() {
        return this.delegate.getGraphics();
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.delegate.getGraphicsConfiguration();
    }

    public int getHeight() {
        return this.delegate.getHeight();
    }

    public HierarchyBoundsListener[] getHierarchyBoundsListeners() {
        return this.delegate.getHierarchyBoundsListeners();
    }

    public HierarchyListener[] getHierarchyListeners() {
        return this.delegate.getHierarchyListeners();
    }

    public Image getIconImage() {
        return this.delegate.getIconImage();
    }

    public boolean getIgnoreRepaint() {
        return this.delegate.getIgnoreRepaint();
    }

    public InputContext getInputContext() {
        return this.delegate.getInputContext();
    }

    public InputMethodListener[] getInputMethodListeners() {
        return this.delegate.getInputMethodListeners();
    }

    public InputMethodRequests getInputMethodRequests() {
        return this.delegate.getInputMethodRequests();
    }

    public Insets getInsets() {
        return this.delegate.getInsets();
    }

    public JMenuBar getJMenuBar() {
        return this.delegate.getJMenuBar();
    }

    public KeyListener[] getKeyListeners() {
        return this.delegate.getKeyListeners();
    }

    public JLayeredPane getLayeredPane() {
        return this.delegate.getLayeredPane();
    }

    public LayoutManager getLayout() {
        return this.delegate.getLayout();
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.delegate.getListeners(listenerType);
    }

    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    public Point getLocation() {
        return this.delegate.getLocation();
    }

    public Point getLocation(Point rv) {
        return this.delegate.getLocation(rv);
    }

    public Point getLocationOnScreen() {
        return this.delegate.getLocationOnScreen();
    }

    public Rectangle getMaximizedBounds() {
        return this.delegate.getMaximizedBounds();
    }

    public Dimension getMaximumSize() {
        return this.delegate.getMaximumSize();
    }

    public JMenu getMenu(String arg0) {
        return this.delegate.getMenu(arg0);
    }

    public MenuBar getMenuBar() {
        return this.delegate.getMenuBar();
    }

    public Dimension getMinimumSize() {
        return this.delegate.getMinimumSize();
    }

    public Component getMostRecentFocusOwner() {
        return this.delegate.getMostRecentFocusOwner();
    }

    public MouseListener[] getMouseListeners() {
        return this.delegate.getMouseListeners();
    }

    public MouseMotionListener[] getMouseMotionListeners() {
        return this.delegate.getMouseMotionListeners();
    }

    public Point getMousePosition() throws HeadlessException {
        return this.delegate.getMousePosition();
    }

    public Point getMousePosition(boolean allowChildren) throws HeadlessException {
        return this.delegate.getMousePosition(allowChildren);
    }

    public MouseWheelListener[] getMouseWheelListeners() {
        return this.delegate.getMouseWheelListeners();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public ArrayList getObjectOfClass(Class arg0) {
        return this.delegate.getObjectOfClass(arg0);
    }

    public Window[] getOwnedWindows() {
        return this.delegate.getOwnedWindows();
    }

    public Window getOwner() {
        return this.delegate.getOwner();
    }

    public Container getParent() {
        return this.delegate.getParent();
    }

    public Dimension getPreferredSize() {
        return this.delegate.getPreferredSize();
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.delegate.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.delegate.getPropertyChangeListeners(propertyName);
    }

    public JRootPane getRootPane() {
        return this.delegate.getRootPane();
    }

    public Dimension getSize() {
        return this.delegate.getSize();
    }

    public Dimension getSize(Dimension rv) {
        return this.delegate.getSize(rv);
    }

    public int getState() {
        return this.delegate.getState();
    }

    public String getTitle() {
        return this.delegate.getTitle();
    }

    public Toolkit getToolkit() {
        return this.delegate.getToolkit();
    }

    public int getWidth() {
        return this.delegate.getWidth();
    }

    public WindowFocusListener[] getWindowFocusListeners() {
        return this.delegate.getWindowFocusListeners();
    }

    public WindowListener[] getWindowListeners() {
        return this.delegate.getWindowListeners();
    }

    public WindowStateListener[] getWindowStateListeners() {
        return this.delegate.getWindowStateListeners();
    }

    public int getX() {
        return this.delegate.getX();
    }

    public int getY() {
        return this.delegate.getY();
    }

    public boolean hasFocus() {
        return this.delegate.hasFocus();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        return this.delegate.imageUpdate(img, infoflags, x, y, w, h);
    }

    public void inspectXML() {
        this.delegate.inspectXML();
    }

    public void invalidate() {
        this.delegate.invalidate();
    }

    public void invalidateImage() {
        this.delegate.invalidateImage();
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    public boolean isAncestorOf(Component c) {
        return this.delegate.isAncestorOf(c);
    }

    public boolean isAnimated() {
        return this.delegate.isAnimated();
    }

    public boolean isAutoclear() {
        return this.delegate.isAutoclear();
    }

    public boolean isAutoscaleX() {
        return this.delegate.isAutoscaleX();
    }

    public boolean isAutoscaleY() {
        return this.delegate.isAutoscaleY();
    }

    public boolean isBackgroundSet() {
        return this.delegate.isBackgroundSet();
    }

    public boolean isCursorSet() {
        return this.delegate.isCursorSet();
    }

    public boolean isDisplayable() {
        return this.delegate.isDisplayable();
    }

    public boolean isDoubleBuffered() {
        return this.delegate.isDoubleBuffered();
    }

    public boolean isEnabled() {
        return this.delegate.isEnabled();
    }

    public boolean isFocusable() {
        return this.delegate.isFocusable();
    }

    public boolean isFocusCycleRoot() {
        return this.delegate.isFocusCycleRoot();
    }

    public boolean isFocusCycleRoot(Container container) {
        return this.delegate.isFocusCycleRoot(container);
    }

    public boolean isFocused() {
        return this.delegate.isFocused();
    }

    public boolean isFocusOwner() {
        return this.delegate.isFocusOwner();
    }

    public boolean isFocusTraversalPolicySet() {
        return this.delegate.isFocusTraversalPolicySet();
    }

    public boolean isFontSet() {
        return this.delegate.isFontSet();
    }

    public boolean isForegroundSet() {
        return this.delegate.isForegroundSet();
    }

    public boolean isIconified() {
        return this.delegate.isIconified();
    }

    public boolean isKeepHidden() {
        return this.delegate.isKeepHidden();
    }

    public boolean isLightweight() {
        return this.delegate.isLightweight();
    }

    public boolean isLocationByPlatform() {
        return this.delegate.isLocationByPlatform();
    }

    public boolean isMaximumSizeSet() {
        return this.delegate.isMaximumSizeSet();
    }

    public boolean isMinimumSizeSet() {
        return this.delegate.isMinimumSizeSet();
    }

    public boolean isOpaque() {
        return this.delegate.isOpaque();
    }

    public boolean isPreferredSizeSet() {
        return this.delegate.isPreferredSizeSet();
    }

    public boolean isResizable() {
        return this.delegate.isResizable();
    }

    public boolean isShowing() {
        return this.delegate.isShowing();
    }

    public boolean isUndecorated() {
        return this.delegate.isUndecorated();
    }

    public boolean isValid() {
        return this.delegate.isValid();
    }

    public boolean isVisible() {
        return this.delegate.isVisible();
    }

    public void limitAutoscaleX(double arg0, double arg1) {
        this.delegate.limitAutoscaleX(arg0, arg1);
    }

    public void limitAutoscaleY(double arg0, double arg1) {
        this.delegate.limitAutoscaleY(arg0, arg1);
    }

    public void list() {
        this.delegate.list();
    }

    public void list(PrintStream out, int indent) {
        this.delegate.list(out, indent);
    }

    public void list(PrintStream out) {
        this.delegate.list(out);
    }

    public void list(PrintWriter out, int indent) {
        this.delegate.list(out, indent);
    }

    public void list(PrintWriter out) {
        this.delegate.list(out);
    }

    public void lostOwnership(Clipboard arg0, Transferable arg1) {
        this.delegate.lostOwnership(arg0, arg1);
    }

    public void paint(Graphics arg0) {
        this.delegate.paint(arg0);
    }

    public void paintAll(Graphics g) {
        this.delegate.paintAll(g);
    }

    public void paintComponents(Graphics g) {
        this.delegate.paintComponents(g);
    }

    public void parseXMLMenu(String arg0, Class arg1) {
        this.delegate.parseXMLMenu(arg0, arg1);
    }

    public void parseXMLMenu(String arg0) {
        this.delegate.parseXMLMenu(arg0);
    }

    public boolean prepareImage(Image image, ImageObserver observer) {
        return this.delegate.prepareImage(image, observer);
    }

    public boolean prepareImage(Image image, int width, int height, ImageObserver observer) {
        return this.delegate.prepareImage(image, width, height, observer);
    }

    public int print(Graphics arg0, PageFormat arg1, int arg2) throws PrinterException {
        return this.delegate.print(arg0, arg1, arg2);
    }

    public void print(Graphics g) {
        this.delegate.print(g);
    }

    public void printAll(Graphics g) {
        this.delegate.printAll(g);
    }

    public void printComponents(Graphics g) {
        this.delegate.printComponents(g);
    }

    public void remove(Component comp) {
        this.delegate.remove(comp);
    }

    public void remove(int index) {
        this.delegate.remove(index);
    }

    public void remove(MenuComponent arg0) {
        this.delegate.remove(arg0);
    }

    public void removeAll() {
        this.delegate.removeAll();
    }

    public void removeComponentListener(ComponentListener l) {
        this.delegate.removeComponentListener(l);
    }

    public void removeContainerListener(ContainerListener l) {
        this.delegate.removeContainerListener(l);
    }

    public void removeDrawable(Drawable arg0) {
        this.delegate.removeDrawable(arg0);
    }

    public void removeFocusListener(FocusListener l) {
        this.delegate.removeFocusListener(l);
    }

    public void removeHierarchyBoundsListener(HierarchyBoundsListener l) {
        this.delegate.removeHierarchyBoundsListener(l);
    }

    public void removeHierarchyListener(HierarchyListener l) {
        this.delegate.removeHierarchyListener(l);
    }

    public void removeInputMethodListener(InputMethodListener l) {
        this.delegate.removeInputMethodListener(l);
    }

    public void removeKeyListener(KeyListener l) {
        this.delegate.removeKeyListener(l);
    }

    public JMenu removeMenu(String arg0) {
        return this.delegate.removeMenu(arg0);
    }

    public JMenuItem removeMenuItem(String arg0, String arg1) {
        return this.delegate.removeMenuItem(arg0, arg1);
    }

    public void removeMouseListener(MouseListener l) {
        this.delegate.removeMouseListener(l);
    }

    public void removeMouseMotionListener(MouseMotionListener l) {
        this.delegate.removeMouseMotionListener(l);
    }

    public void removeMouseWheelListener(MouseWheelListener l) {
        this.delegate.removeMouseWheelListener(l);
    }

    public void removeNotify() {
        this.delegate.removeNotify();
    }

    public void removeObjectsOfClass(Class arg0) {
        this.delegate.removeObjectsOfClass(arg0);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.delegate.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.delegate.removePropertyChangeListener(propertyName, listener);
    }

    public void removeWindowFocusListener(WindowFocusListener l) {
        this.delegate.removeWindowFocusListener(l);
    }

    public void removeWindowListener(WindowListener l) {
        this.delegate.removeWindowListener(l);
    }

    public void removeWindowStateListener(WindowStateListener l) {
        this.delegate.removeWindowStateListener(l);
    }

    public void render() {
        this.delegate.render();
    }

    public void repaint() {
        this.delegate.repaint();
    }

    public void repaint(int x, int y, int width, int height) {
        this.delegate.repaint(x, y, width, height);
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        this.delegate.repaint(tm, x, y, width, height);
    }

    public void repaint(long tm) {
        this.delegate.repaint(tm);
    }

    public void replaceAction(XMLControlElement arg0) {
        this.delegate.replaceAction(arg0);
    }

    public void replaceDrawable(Drawable arg0, Drawable arg1) {
        this.delegate.replaceDrawable(arg0, arg1);
    }

    public void requestFocus() {
        this.delegate.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.delegate.requestFocusInWindow();
    }

    public void saveXML() {
        this.delegate.saveXML();
    }

    public void setAnimated(boolean arg0) {
        this.delegate.setAnimated(arg0);
    }

    public void setAutoclear(boolean arg0) {
        this.delegate.setAutoclear(arg0);
    }

    public void setAutoscaleX(boolean arg0) {
        this.delegate.setAutoscaleX(arg0);
    }

    public void setAutoscaleY(boolean arg0) {
        this.delegate.setAutoscaleY(arg0);
    }

    public void setBackground(Color arg0) {
        this.delegate.setBackground(arg0);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.delegate.setBounds(x, y, width, height);
    }

    public void setBounds(Rectangle r) {
        this.delegate.setBounds(r);
    }

    public void setCartesian(String arg0, String arg1, String arg2) {
        this.delegate.setCartesian(arg0, arg1, arg2);
    }

    public void setComponentOrientation(ComponentOrientation o) {
        this.delegate.setComponentOrientation(o);
    }

    public void setConnected(boolean arg0) {
        this.delegate.setConnected(arg0);
    }

    public void setConnected(int arg0, boolean arg1) {
        this.delegate.setConnected(arg0, arg1);
    }

    public void setContentPane(Container contentPane) {
        this.delegate.setContentPane(contentPane);
    }

    public void setCursor(Cursor cursor) {
        this.delegate.setCursor(cursor);
    }

    public void setCustomInspector(Window arg0) {
        this.delegate.setCustomInspector(arg0);
    }

    public void setCustomMarker(int arg0, Shape arg1) {
        this.delegate.setCustomMarker(arg0, arg1);
    }

    public void setDefaultCloseOperation(int arg0) {
        this.delegate.setDefaultCloseOperation(arg0);
    }

    public void setDrawingPanel(DrawingPanel arg0) {
        this.delegate.setDrawingPanel(arg0);
    }

    public void setDropTarget(DropTarget dt) {
        this.delegate.setDropTarget(dt);
    }

    public void setEnabled(boolean b) {
        this.delegate.setEnabled(b);
    }

    public void setEnabledCopy(boolean arg0) {
        this.delegate.setEnabledCopy(arg0);
    }

    public void setEnabledPaste(boolean arg0) {
        this.delegate.setEnabledPaste(arg0);
    }

    public void setEnabledReplace(boolean arg0) {
        this.delegate.setEnabledReplace(arg0);
    }

    public void setExtendedState(int arg0) {
        this.delegate.setExtendedState(arg0);
    }

    public void setFocusable(boolean focusable) {
        this.delegate.setFocusable(focusable);
    }

    public void setFocusableWindowState(boolean focusableWindowState) {
        this.delegate.setFocusableWindowState(focusableWindowState);
    }

    public void setFocusCycleRoot(boolean focusCycleRoot) {
        this.delegate.setFocusCycleRoot(focusCycleRoot);
    }

    public void setFocusTraversalKeys(int id, Set<? extends AWTKeyStroke> keystrokes) {
        this.delegate.setFocusTraversalKeys(id, keystrokes);
    }

    public void setFocusTraversalKeysEnabled(boolean focusTraversalKeysEnabled) {
        this.delegate.setFocusTraversalKeysEnabled(focusTraversalKeysEnabled);
    }

    public void setFocusTraversalPolicy(FocusTraversalPolicy policy) {
        this.delegate.setFocusTraversalPolicy(policy);
    }

    public void setFont(Font f) {
        this.delegate.setFont(f);
    }

    public void setForeground(Color c) {
        this.delegate.setForeground(c);
    }

    public void setGlassPane(Component glassPane) {
        this.delegate.setGlassPane(glassPane);
    }

    public void setIconImage(Image image) {
        this.delegate.setIconImage(image);
    }

    public void setIgnoreRepaint(boolean ignoreRepaint) {
        this.delegate.setIgnoreRepaint(ignoreRepaint);
    }

    public void setInteractiveMouseHandler(InteractiveMouseHandler arg0) {
        this.delegate.setInteractiveMouseHandler(arg0);
    }

    public void setInteriorBackground(Color arg0) {
        this.delegate.setInteriorBackground(arg0);
    }

    public void setJMenuBar(JMenuBar menubar) {
        this.delegate.setJMenuBar(menubar);
    }

    public void setKeepHidden(boolean arg0) {
        this.delegate.setKeepHidden(arg0);
    }

    public void setLayeredPane(JLayeredPane layeredPane) {
        this.delegate.setLayeredPane(layeredPane);
    }

    public void setLayout(LayoutManager manager) {
        this.delegate.setLayout(manager);
    }

    public void setLineColor(int arg0, Color arg1) {
        this.delegate.setLineColor(arg0, arg1);
    }

    public void setLocale(Locale l) {
        this.delegate.setLocale(l);
    }

    public void setLocation(int x, int y) {
        this.delegate.setLocation(x, y);
    }

    public void setLocation(Point p) {
        this.delegate.setLocation(p);
    }

    public void setLocationByPlatform(boolean locationByPlatform) {
        this.delegate.setLocationByPlatform(locationByPlatform);
    }

    public void setLocationRelativeTo(Component c) {
        this.delegate.setLocationRelativeTo(c);
    }

    public void setLogScale(boolean arg0, boolean arg1) {
        this.delegate.setLogScale(arg0, arg1);
    }

    public void setLogScaleX(boolean arg0) {
        this.delegate.setLogScaleX(arg0);
    }

    public void setLogScaleY(boolean arg0) {
        this.delegate.setLogScaleY(arg0);
    }

    public void setMarkerColor(int arg0, Color arg1, Color arg2) {
        this.delegate.setMarkerColor(arg0, arg1, arg2);
    }

    public void setMarkerColor(int arg0, Color arg1) {
        this.delegate.setMarkerColor(arg0, arg1);
    }

    public void setMarkerShape(int arg0, int arg1) {
        this.delegate.setMarkerShape(arg0, arg1);
    }

    public void setMarkerSize(int arg0, int arg1) {
        this.delegate.setMarkerSize(arg0, arg1);
    }

    public void setMaximizedBounds(Rectangle arg0) {
        this.delegate.setMaximizedBounds(arg0);
    }

    public void setMaximumFractionDigits(int arg0) {
        this.delegate.setMaximumFractionDigits(arg0);
    }

    public void setMaximumFractionDigits(String arg0, int arg1) {
        this.delegate.setMaximumFractionDigits(arg0, arg1);
    }

    public void setMaximumSize(Dimension maximumSize) {
        this.delegate.setMaximumSize(maximumSize);
    }

    public void setMenuBar(MenuBar arg0) {
        this.delegate.setMenuBar(arg0);
    }

    public void setMessage(String arg0, int arg1) {
        this.delegate.setMessage(arg0, arg1);
    }

    public void setMessage(String arg0) {
        this.delegate.setMessage(arg0);
    }

    public void setMinimumSize(Dimension minimumSize) {
        this.delegate.setMinimumSize(minimumSize);
    }

    public void setName(String name) {
        this.delegate.setName(name);
    }

    public void setPixelsPerUnit(boolean arg0, double arg1, double arg2) {
        this.delegate.setPixelsPerUnit(arg0, arg1, arg2);
    }

    public void setPolar(String arg0, double arg1) {
        this.delegate.setPolar(arg0, arg1);
    }

    public void setPreferredMinMax(double arg0, double arg1, double arg2, double arg3) {
        this.delegate.setPreferredMinMax(arg0, arg1, arg2, arg3);
    }

    public void setPreferredMinMaxX(double arg0, double arg1) {
        this.delegate.setPreferredMinMaxX(arg0, arg1);
    }

    public void setPreferredMinMaxY(double arg0, double arg1) {
        this.delegate.setPreferredMinMaxY(arg0, arg1);
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.delegate.setPreferredSize(preferredSize);
    }

    public void setResizable(boolean arg0) {
        this.delegate.setResizable(arg0);
    }

    public void setRowNumberVisible(boolean arg0) {
        this.delegate.setRowNumberVisible(arg0);
    }

    public void setSize(Dimension d) {
        this.delegate.setSize(d);
    }

    public void setSize(int arg0, int arg1) {
        this.delegate.setSize(arg0, arg1);
    }

    public void setSquareAspect(boolean arg0) {
        this.delegate.setSquareAspect(arg0);
    }

    public void setState(int arg0) {
        this.delegate.setState(arg0);
    }

    public void setTitle(String arg0) {
        this.delegate.setTitle(arg0);
    }

    public void setUndecorated(boolean arg0) {
        this.delegate.setUndecorated(arg0);
    }

    public void setVisible(boolean arg0) {
        this.delegate.setVisible(arg0);
    }

    public void setXLabel(String arg0) {
        this.delegate.setXLabel(arg0);
    }

    public void setXPointsLinked(boolean arg0) {
        this.delegate.setXPointsLinked(arg0);
    }

    public void setXYColumnNames(int arg0, String arg1, String arg2, String arg3) {
        this.delegate.setXYColumnNames(arg0, arg1, arg2, arg3);
    }

    public void setXYColumnNames(int arg0, String arg1, String arg2) {
        this.delegate.setXYColumnNames(arg0, arg1, arg2);
    }

    public void setYLabel(String arg0) {
        this.delegate.setYLabel(arg0);
    }

    public void showDataTable(boolean arg0) {
        this.delegate.showDataTable(arg0);
    }

    public void toBack() {
        this.delegate.toBack();
    }

    public void toFront() {
        this.delegate.toFront();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void transferFocus() {
        this.delegate.transferFocus();
    }

    public void transferFocusBackward() {
        this.delegate.transferFocusBackward();
    }

    public void transferFocusDownCycle() {
        this.delegate.transferFocusDownCycle();
    }

    public void transferFocusUpCycle() {
        this.delegate.transferFocusUpCycle();
    }

    public void update(Graphics g) {
        this.delegate.update(g);
    }

    public void validate() {
        this.delegate.validate();
    }

    public boolean wishesToExit() {
        return this.delegate.wishesToExit();
    }

    public boolean isColorByName() {
        return this.colorByName;
    }

    public void setColorByName(boolean colorByName) {
        this.colorByName = colorByName;
    }
}

