/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.pl;

import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class StatesCellRender
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private DecimalFormat FORMAT_DOUBLE = new DecimalFormat("#, ##0.00");

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value.getClass().equals(Double.class)) {
            double d = (Double)value;
            d = Double.isNaN(d) || Double.isInfinite(d) ? 0.0 : d;
            this.setText(this.FORMAT_DOUBLE.format(d));
            this.setHorizontalAlignment(0);
        } else if (value.getClass().equals(String.class)) {
            this.setForeground(Color.blue);
            this.setHorizontalAlignment(0);
            if (value.toString().contains("->")) {
                this.setBackground(Color.green);
            } else if (value.toString().contains("-|")) {
                this.setBackground(Color.orange);
            } else {
                this.setBackground(Color.WHITE);
            }
        } else {
            this.setText("" + value);
        }
        return cell;
    }
}

