/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.pl;

import edu.uci.ics.jung.graph.Graph;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import org.enfin.squad.bl.IObservable;
import org.enfin.squad.bl.IObserver;
import org.enfin.squad.bl.NetworkState;
import org.enfin.squad.pl.GraphAnimator;
import org.enfin.squad.pl.StatesCellRender;
import org.enfin.squad.pl.SteadyStateTableModel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class SteadyStatePanel
extends JPanel
implements IObservable {
    private static final long serialVersionUID = 1L;
    ArrayList<IObserver> observers = new ArrayList();
    NetworkState ntState;
    SteadyStateTableModel tblModel;
    Graph theGraph;
    int index;
    private JButton butViewNetwork;
    private JPanel jPanel1;
    private JScrollPane pnlStates;
    private JRadioButton radSelect;
    private JTable tblState;

    public SteadyStatePanel() {
        this.initComponents();
    }

    public SteadyStatePanel(NetworkState netState, int panelIndex, Graph gr) {
        this();
        this.tblModel = new SteadyStateTableModel(netState);
        this.index = panelIndex;
        this.theGraph = gr;
        this.ntState = netState;
        this.loadState(this.ntState);
        this.setSize(100, 100);
    }

    @Override
    public void registerObserver(IObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(IObserver observer) {
        int obsKey = this.observers.indexOf(observer);
        this.observers.remove(obsKey);
    }

    public void updateStateChange() {
        for (IObserver obs : this.observers) {
            obs.updateObserver(this, this.index);
        }
    }

    public void setSelected(boolean isSelected) {
        this.radSelect.setSelected(isSelected);
    }

    private void loadState(NetworkState netState) {
        if (this.ntState.getNumberOfactiveNodes() > 0) {
            this.radSelect.setText(netState.getId());
            this.tblState.setModel(this.tblModel);
            this.tblState.setDefaultRenderer(Object.class, new StatesCellRender());
            this.tblModel.updateData(netState);
            this.revalidate();
        } else {
            this.radSelect.setText(netState.getId());
            this.pnlStates.setVisible(false);
            JLabel jl = new JLabel("All nodes have state 0");
            this.add(jl);
            this.revalidate();
        }
    }

    private void displayGraph() {
        GraphAnimator gr = new GraphAnimator(this.theGraph, GraphAnimator.STEADYSTATE_COLOR(this.ntState));
        gr.pack();
        gr.setModal(true);
        gr.setVisible(true);
    }

    private void initComponents() {
        this.pnlStates = new JScrollPane();
        this.tblState = new JTable();
        this.jPanel1 = new JPanel();
        this.radSelect = new JRadioButton();
        this.butViewNetwork = new JButton();
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(204, 204, 255));
        this.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.setMaximumSize(new Dimension(230, 130));
        this.setMinimumSize(new Dimension(230, 130));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(230, 130));
        this.pnlStates.setBorder(null);
        this.pnlStates.setViewportView(this.tblState);
        this.add((Component)this.pnlStates, "Center");
        this.jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel1.setBackground(new Color(204, 204, 255));
        this.radSelect.setAlignmentY(0.0f);
        this.radSelect.setBorder(null);
        this.radSelect.setHorizontalAlignment(2);
        this.radSelect.setHorizontalTextPosition(4);
        this.radSelect.setMargin(new Insets(0, 0, 0, 0));
        this.radSelect.setOpaque(false);
        this.radSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SteadyStatePanel.this.radSelectActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.radSelect, new AbsoluteConstraints(10, 5, 140, 20));
        this.radSelect.getAccessibleContext().setAccessibleName("radSelected");
        this.butViewNetwork.setText("view");
        this.butViewNetwork.setAlignmentY(0.0f);
        this.butViewNetwork.setOpaque(false);
        this.butViewNetwork.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SteadyStatePanel.this.butViewNetworkMousePressed(evt);
            }
        });
        this.jPanel1.add((Component)this.butViewNetwork, new AbsoluteConstraints(160, 5, 60, 20));
        this.add((Component)this.jPanel1, "North");
    }

    private void butViewNetworkMousePressed(MouseEvent evt) {
        this.displayGraph();
    }

    private void radSelectActionPerformed(ActionEvent evt) {
        if (this.radSelect.isSelected()) {
            this.updateStateChange();
        } else {
            this.radSelect.setSelected(true);
        }
    }
}

