/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.Animation;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPControl;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.GUIUtils;

public class AnimationControl
extends OSPControl {
    String resetToolTipText = ControlsRes.ANIMATION_RESET_TIP;
    String initToolTipText = ControlsRes.ANIMATION_INIT_TIP;
    String startToolTipText = ControlsRes.ANIMATION_START_TIP;
    String stopToolTipText = ControlsRes.ANIMATION_STOP_TIP;
    String newToolTipText = ControlsRes.ANIMATION_NEW_TIP;
    String stepToolTipText = ControlsRes.ANIMATION_STEP_TIP;
    String initText = ControlsRes.ANIMATION_INIT;
    String startText = ControlsRes.ANIMATION_START;
    String stopText = ControlsRes.ANIMATION_STOP;
    String resetText = ControlsRes.ANIMATION_RESET;
    String newText = ControlsRes.ANIMATION_NEW;
    boolean stepModeEditing = true;
    JButton startBtn = new JButton(ControlsRes.ANIMATION_INIT);
    JButton stepBtn = new JButton(ControlsRes.ANIMATION_STEP);
    JButton resetBtn = new JButton(ControlsRes.ANIMATION_RESET);

    public AnimationControl(Animation animation) {
        super(animation);
        if (this.model != null) {
            String name = this.model.getClass().getName();
            this.setTitle(name.substring(1 + name.lastIndexOf(".")) + " Controller");
        }
        this.startBtn.addActionListener(new StartBtnListener());
        this.startBtn.setToolTipText(this.initToolTipText);
        this.stepBtn.addActionListener(new StepBtnListener());
        this.stepBtn.setToolTipText(this.stepToolTipText);
        this.resetBtn.addActionListener(new ResetBtnListener());
        this.resetBtn.setToolTipText(this.resetToolTipText);
        this.stepBtn.setEnabled(false);
        this.buttonPanel.add(this.startBtn);
        this.buttonPanel.add(this.stepBtn);
        this.buttonPanel.add(this.resetBtn);
        this.validate();
        this.pack();
    }

    protected void refreshGUI() {
        super.refreshGUI();
        this.resetToolTipText = ControlsRes.ANIMATION_RESET_TIP;
        this.initToolTipText = ControlsRes.ANIMATION_INIT_TIP;
        this.startToolTipText = ControlsRes.ANIMATION_START_TIP;
        this.stopToolTipText = ControlsRes.ANIMATION_STOP_TIP;
        this.newToolTipText = ControlsRes.ANIMATION_NEW_TIP;
        this.stepToolTipText = ControlsRes.ANIMATION_STEP_TIP;
        this.stepBtn.setText(ControlsRes.ANIMATION_STEP);
        this.stepBtn.setToolTipText(this.stepToolTipText);
        if (this.startBtn.getText().equals(this.startText)) {
            this.startBtn.setText(ControlsRes.ANIMATION_START);
            this.startBtn.setToolTipText(this.startToolTipText);
        } else if (this.startBtn.getText().equals(this.stopText)) {
            this.startBtn.setText(ControlsRes.ANIMATION_STOP);
            this.startBtn.setToolTipText(this.stopToolTipText);
        } else {
            this.startBtn.setText(ControlsRes.ANIMATION_INIT);
            this.startBtn.setToolTipText(this.initToolTipText);
        }
        if (this.resetBtn.getText().equals(this.newText)) {
            this.resetBtn.setText(ControlsRes.ANIMATION_NEW);
            this.resetBtn.setToolTipText(this.newToolTipText);
        } else {
            this.resetBtn.setText(ControlsRes.ANIMATION_RESET);
            this.resetBtn.setToolTipText(this.resetToolTipText);
        }
        this.initText = ControlsRes.ANIMATION_INIT;
        this.startText = ControlsRes.ANIMATION_START;
        this.resetText = ControlsRes.ANIMATION_RESET;
        this.stopText = ControlsRes.ANIMATION_STOP;
        this.newText = ControlsRes.ANIMATION_NEW;
    }

    public void calculationDone(final String message) {
        if (this.model instanceof Animation) {
            ((Animation)this.model).stopAnimation();
        }
        Runnable doNow = new Runnable(){

            public void run() {
                AnimationControl.this.startBtnActionPerformed(new ActionEvent(this, 0, AnimationControl.this.stopText));
                AnimationControl.this.resetBtnActionPerformed(new ActionEvent(this, 0, AnimationControl.this.newText));
                AnimationControl.this.resetBtn.setEnabled(true);
                GUIUtils.enableMenubars(true);
                if (message != null) {
                    AnimationControl.this.println(message);
                }
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                doNow.run();
            } else {
                SwingUtilities.invokeAndWait(doNow);
            }
        }
        catch (InvocationTargetException ex1) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void startBtnActionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(this.initText)) {
            this.stepBtn.setEnabled(true);
            this.startBtn.setText(this.startText);
            this.startBtn.setToolTipText(this.startToolTipText);
            this.resetBtn.setText(this.newText);
            this.resetBtn.setToolTipText(this.newToolTipText);
            this.resetBtn.setEnabled(true);
            this.readItem.setEnabled(this.stepModeEditing);
            this.table.setEnabled(this.stepModeEditing);
            this.messageTextArea.setEditable(false);
            GUIUtils.clearDrawingFrameData(false);
            if (this.model == null) {
                this.println("This AnimationControl's model is null.");
            } else {
                ((Animation)this.model).initializeAnimation();
            }
            GUIUtils.showDrawingAndTableFrames();
        } else if (e.getActionCommand().equals(this.startText)) {
            this.setCustomButtonsEnabled(false);
            this.startBtn.setText(this.stopText);
            this.startBtn.setToolTipText(this.stopToolTipText);
            this.stepBtn.setEnabled(false);
            this.resetBtn.setEnabled(false);
            this.readItem.setEnabled(false);
            this.table.setEnabled(false);
            GUIUtils.enableMenubars(false);
            ((Animation)this.model).startAnimation();
        } else {
            this.startBtn.setText(this.startText);
            this.setCustomButtonsEnabled(true);
            this.startBtn.setToolTipText(this.startToolTipText);
            this.stepBtn.setEnabled(true);
            this.resetBtn.setEnabled(true);
            GUIUtils.enableMenubars(true);
            this.readItem.setEnabled(this.stepModeEditing);
            this.table.setEnabled(this.stepModeEditing);
            ((Animation)this.model).stopAnimation();
        }
    }

    void resetBtnActionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(this.resetText)) {
            GUIUtils.clearDrawingFrameData(true);
            if (this.model == null) {
                this.println("This AnimationControl's model is null.");
                return;
            }
            ((Animation)this.model).resetAnimation();
            if (this.xmlDefault != null) {
                this.xmlDefault.loadObject(this.getOSPApp());
            }
        } else {
            this.startBtn.setText(this.initText);
            this.startBtn.setToolTipText(this.initToolTipText);
            this.resetBtn.setText(this.resetText);
            this.resetBtn.setToolTipText(this.resetToolTipText);
            this.stepBtn.setEnabled(false);
            this.readItem.setEnabled(true);
            this.table.setEnabled(true);
            this.messageTextArea.setEditable(true);
            this.setCustomButtonsEnabled(true);
        }
    }

    void stepBtnActionPerformed(ActionEvent e) {
        ((Animation)this.model).stepAnimation();
    }

    private void setCustomButtonsEnabled(boolean enabled) {
        if (this.customButtons != null) {
            Iterator it = ((AbstractList)this.customButtons).iterator();
            while (it.hasNext()) {
                ((JButton)it.next()).setEnabled(enabled);
            }
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new AnimationControlLoader();
    }

    public static AnimationControl createApp(Animation model) {
        AnimationControl control = new AnimationControl(model);
        model.setControl(control);
        return control;
    }

    public static AnimationControl createApp(Animation model, String[] xml) {
        AnimationControl control = AnimationControl.createApp(model);
        control.loadXML(xml);
        return control;
    }

    static class AnimationControlLoader
    extends OSPControl.OSPControlLoader {
        AnimationControlLoader() {
        }

        public void saveObject(XMLControl element, Object obj) {
            AnimationControl control = (AnimationControl)obj;
            if (control.startBtn.getText().equals(control.stopText)) {
                control.startBtn.doClick();
            }
            element.setValue("initialize_mode", control.startBtn.getText().equals(control.initText));
            super.saveObject(element, obj);
        }

        public Object createObject(XMLControl element) {
            return new AnimationControl(null);
        }

        public Object loadObject(XMLControl element, Object obj) {
            AnimationControl animationControl = (AnimationControl)obj;
            if (animationControl.startBtn.getText().equals(animationControl.stopText)) {
                animationControl.startBtn.doClick();
            }
            boolean initMode = element.getBoolean("initialize_mode");
            element.setValue("initialize_mode", null);
            super.loadObject(element, obj);
            if (initMode) {
                element.setValue("initialize_mode", true);
            }
            if (initMode && animationControl.startBtn.getText().equals(animationControl.startText)) {
                animationControl.resetBtn.doClick();
            }
            if (!initMode && animationControl.startBtn.getText().equals(animationControl.initText)) {
                animationControl.startBtn.doClick();
            }
            animationControl.clearMessages();
            return obj;
        }
    }

    class StepBtnListener
    implements ActionListener {
        StepBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AnimationControl.this.stepBtnActionPerformed(e);
        }
    }

    class ResetBtnListener
    implements ActionListener {
        ResetBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AnimationControl.this.resetBtnActionPerformed(e);
        }
    }

    class StartBtnListener
    implements ActionListener {
        StartBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AnimationControl.this.startBtnActionPerformed(e);
        }
    }
}

