/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.opensourcephysics.controls.ConsoleLevel;
import org.opensourcephysics.controls.OSPLog;

class ConsoleFormatter
extends SimpleFormatter {
    ConsoleFormatter() {
    }

    public String format(LogRecord record) {
        String message = this.formatMessage(record);
        if (record.getLevel().intValue() == ConsoleLevel.OUT_CONSOLE.intValue() || record.getLevel().intValue() == ConsoleLevel.ERR_CONSOLE.intValue()) {
            StringBuffer sb = new StringBuffer();
            if (message.charAt(0) == '\t') {
                message = message.replaceFirst("\t", "    ");
            } else {
                sb.append("CONSOLE: ");
            }
            sb.append(message);
            sb.append(OSPLog.eol);
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    sb.append(sw.toString());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return sb.toString();
        }
        return super.format(record);
    }
}

