/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPApplication;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ToolsRes;

public abstract class ControlFrame
extends OSPFrame
implements Control {
    static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected Object model;
    protected JMenuItem[] languageItems;
    protected JMenu languageMenu;
    protected JMenu fileMenu;
    protected JMenu editMenu;
    protected JMenu displayMenu;
    protected JMenuItem readItem;
    protected JMenuItem clearItem;
    protected JMenuItem saveAsItem;
    protected JMenuItem copyItem;
    protected JMenuItem inspectItem;
    protected JMenuItem logToFileItem;
    protected JMenuItem sizeUpItem;
    protected JMenuItem sizeDownItem;
    protected OSPApplication ospApp;
    protected XMLControlElement xmlDefault;
    static /* synthetic */ Class class$org$opensourcephysics$controls$OSPApplication;

    protected ControlFrame(String title) {
        super(title);
        this.createMenuBar();
        this.setName("controlFrame");
    }

    private void createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        if (!OSPFrame.appletMode) {
            this.setJMenuBar(menuBar);
        }
        this.fileMenu = new JMenu(ControlsRes.getString("ControlFrame.File"));
        this.editMenu = new JMenu(ControlsRes.getString("ControlFrame.Edit"));
        menuBar.add(this.fileMenu);
        menuBar.add(this.editMenu);
        this.readItem = new JMenuItem(ControlsRes.getString("ControlFrame.Load_XML"));
        this.saveAsItem = new JMenuItem(ControlsRes.getString("ControlFrame.Save_XML"));
        this.inspectItem = new JMenuItem(ControlsRes.getString("ControlFrame.Inspect_XML"));
        this.clearItem = new JMenuItem(ControlsRes.getString("ControlFrame.Clear_XML"));
        this.copyItem = new JMenuItem(ControlsRes.getString("ControlFrame.Copy"));
        this.fileMenu.add(this.readItem);
        this.fileMenu.add(this.saveAsItem);
        this.fileMenu.add(this.inspectItem);
        this.fileMenu.add(this.clearItem);
        this.editMenu.add(this.copyItem);
        this.copyItem.setAccelerator(KeyStroke.getKeyStroke(67, MENU_SHORTCUT_KEY_MASK));
        this.copyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlFrame.this.copy();
            }
        });
        this.saveAsItem.setAccelerator(KeyStroke.getKeyStroke(83, MENU_SHORTCUT_KEY_MASK));
        this.saveAsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlFrame.this.saveXML();
            }
        });
        this.inspectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlFrame.this.inspectXML();
            }
        });
        this.readItem.setAccelerator(KeyStroke.getKeyStroke(76, MENU_SHORTCUT_KEY_MASK));
        this.readItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlFrame.this.loadXML((String)null);
            }
        });
        this.clearItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlFrame.this.xmlDefault = null;
            }
        });
        this.loadDisplayMenu();
        JMenu helpMenu = new JMenu(ControlsRes.getString("ControlFrame.Help"));
        menuBar.add(helpMenu);
        JMenuItem aboutItem = new JMenuItem(ControlsRes.getString("ControlFrame.About"));
        aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlFrame.showAboutDialog(ControlFrame.this);
            }
        });
        helpMenu.add(aboutItem);
        JMenuItem sysItem = new JMenuItem(ControlsRes.getString("ControlFrame.System"));
        sysItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlUtils.showSystemProperties(true);
            }
        });
        helpMenu.add(sysItem);
        JMenuItem showItem = new JMenuItem(ControlsRes.getString("ControlFrame.Display_All_Frames"));
        showItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIUtils.showDrawingAndTableFrames();
            }
        });
        helpMenu.add(showItem);
        helpMenu.addSeparator();
        JMenuItem logItem = new JMenuItem(ControlsRes.getString("ControlFrame.Message_Log"));
        logItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OSPLog.getOSPLog().setVisible(true);
            }
        });
        helpMenu.add(logItem);
        this.logToFileItem = new JCheckBoxMenuItem(ControlsRes.getString("ControlFrame.Log_to_File"));
        this.logToFileItem.setSelected(false);
        this.logToFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                OSPLog.getOSPLog().setLogToFile(item.isSelected());
            }
        });
        helpMenu.add(this.logToFileItem);
        this.validate();
    }

    protected JMenu loadDisplayMenu() {
        int i;
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return null;
        }
        this.displayMenu = super.loadDisplayMenu();
        if (this.displayMenu == null) {
            this.displayMenu = new JMenu();
            this.displayMenu.setText(ControlsRes.getString("ControlFrame.Display"));
            menuBar.add(this.displayMenu);
        }
        this.languageMenu = new JMenu();
        this.languageMenu.setText(ControlsRes.getString("ControlFrame.Language"));
        AbstractAction languageAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String language = e.getActionCommand();
                OSPLog.finest("setting language to " + language);
                for (int i = 0; i < ControlFrame.access$000().length; ++i) {
                    if (!language.equals(ControlFrame.access$100()[i].getDisplayName())) continue;
                    ToolsRes.setLocale(ControlFrame.access$200()[i]);
                    return;
                }
            }
        };
        ButtonGroup languageGroup = new ButtonGroup();
        this.languageItems = new JMenuItem[OSPFrame.defaultLocales.length];
        for (i = 0; i < OSPFrame.defaultLocales.length; ++i) {
            this.languageItems[i] = new JRadioButtonMenuItem(OSPFrame.defaultLocales[i].getDisplayName(OSPFrame.defaultLocales[i]));
            this.languageItems[i].setActionCommand(OSPFrame.defaultLocales[i].getDisplayName());
            this.languageItems[i].addActionListener(languageAction);
            this.languageMenu.add(this.languageItems[i]);
            languageGroup.add(this.languageItems[i]);
        }
        for (i = 0; i < OSPFrame.defaultLocales.length; ++i) {
            if (!OSPFrame.defaultLocales[i].getLanguage().equals(ToolsRes.getLanguage())) continue;
            this.languageItems[i].setSelected(true);
        }
        if (OSPFrame.authorMode || !OSPFrame.launcherMode) {
            this.displayMenu.add(this.languageMenu);
        }
        JMenu fontMenu = new JMenu(DisplayRes.getString("DrawingFrame.Font_menu_title"));
        this.displayMenu.add(fontMenu);
        JMenuItem sizeUpItem = new JMenuItem(ControlsRes.getString("ControlFrame.Increase_Font_Size"));
        sizeUpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontSizer.levelUp();
            }
        });
        fontMenu.add(sizeUpItem);
        final JMenuItem sizeDownItem = new JMenuItem(ControlsRes.getString("ControlFrame.Decrease_Font_Size"));
        sizeDownItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontSizer.levelDown();
            }
        });
        fontMenu.add(sizeDownItem);
        fontMenu.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                sizeDownItem.setEnabled(FontSizer.getLevel() > 0);
            }
        });
        return this.displayMenu;
    }

    protected void refreshGUI() {
        super.refreshGUI();
        this.createMenuBar();
    }

    public static void showAboutDialog(Component parent) {
        String aboutString = "OSP Library " + ControlUtils.version + " released " + ControlUtils.releaseDate + "\n" + "Open Source Physics Project \n" + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(parent, aboutString, "About Open Source Physics", 1);
    }

    public void save() {
        ControlUtils.saveToFile(this, this);
    }

    public void readParameters() {
        ControlUtils.loadParameters(this, this);
    }

    public void copy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(this.toString());
        clipboard.setContents(stringSelection, stringSelection);
    }

    public void saveXML() {
        JFileChooser chooser = OSPFrame.getChooser();
        if (chooser == null) {
            return;
        }
        String oldTitle = chooser.getDialogTitle();
        chooser.setDialogTitle(ControlsRes.getString("ControlFrame.Save_XML_Data"));
        int result = chooser.showSaveDialog(null);
        chooser.setDialogTitle(oldTitle);
        if (result == 0) {
            int selected;
            File file = chooser.getSelectedFile();
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(null, ControlsRes.getString("ControlFrame.Replace_existing") + file.getName() + ControlsRes.getString("ControlFrame.question_mark"), ControlsRes.getString("ControlFrame.Replace_File"), 1)) != 0) {
                return;
            }
            OSPFrame.chooserDir = chooser.getCurrentDirectory().toString();
            String fileName = file.getAbsolutePath();
            if (fileName == null || fileName.trim().equals("")) {
                return;
            }
            int i = fileName.toLowerCase().lastIndexOf(".xml");
            if (i != fileName.length() - 4) {
                fileName = fileName + ".xml";
            }
            XMLControlElement xml = new XMLControlElement(this.getOSPApp());
            xml.write(fileName);
        }
    }

    public void loadXML(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                this.loadXML(args[i]);
            }
        }
    }

    public void loadXML(String fileName) {
        XMLControlElement xml;
        if (fileName == null || fileName.trim().equals("")) {
            this.loadXML();
            return;
        }
        if ((class$org$opensourcephysics$controls$OSPApplication == null ? (class$org$opensourcephysics$controls$OSPApplication = ControlFrame.class$("org.opensourcephysics.controls.OSPApplication")) : class$org$opensourcephysics$controls$OSPApplication).isAssignableFrom((xml = new XMLControlElement(fileName)).getObjectClass())) {
            this.xmlDefault = xml;
            this.xmlDefault.loadObject(this.getOSPApp());
        } else {
            JOptionPane.showMessageDialog(this, "\"" + fileName + "\" is for " + xml.getObjectClass() + ".", "Incorrect XML Object Type", 2);
        }
    }

    public void loadXML() {
        JFileChooser chooser = OSPFrame.getChooser();
        if (chooser == null) {
            return;
        }
        String oldTitle = chooser.getDialogTitle();
        chooser.setDialogTitle(ControlsRes.getString("ControlFrame.Load_XML_Data"));
        int result = chooser.showOpenDialog(null);
        chooser.setDialogTitle(oldTitle);
        if (result == 0) {
            OSPFrame.chooserDir = chooser.getCurrentDirectory().toString();
            String fileName = chooser.getSelectedFile().getAbsolutePath();
            this.loadXML(fileName);
        }
    }

    public void inspectXML() {
        XMLControlElement xml = new XMLControlElement(this.getOSPApp());
        XMLTreePanel treePanel = new XMLTreePanel(xml);
        JDialog dialog = new JDialog((Frame)null, true);
        dialog.setContentPane(treePanel);
        ((Component)dialog).setSize(new Dimension(600, 300));
        ((Component)dialog).setVisible(true);
    }

    protected OSPApplication getOSPApp() {
        if (this.ospApp == null) {
            this.ospApp = new OSPApplication(this, this.model);
        }
        return this.ospApp;
    }

    static /* synthetic */ Locale[] access$000() {
        return OSPFrame.defaultLocales;
    }

    static /* synthetic */ Locale[] access$100() {
        return OSPFrame.defaultLocales;
    }

    static /* synthetic */ Locale[] access$200() {
        return OSPFrame.defaultLocales;
    }

    public abstract /* synthetic */ void calculationDone(String var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ void clearMessages();

    public abstract /* synthetic */ void clearValues();

    public abstract /* synthetic */ boolean getBoolean(String var1);

    public abstract /* synthetic */ double getDouble(String var1);

    public abstract /* synthetic */ int getInt(String var1);

    public abstract /* synthetic */ Object getObject(String var1);

    public abstract /* synthetic */ Collection getPropertyNames();

    public abstract /* synthetic */ String getString(String var1);

    public abstract /* synthetic */ void print(String var1);

    public abstract /* synthetic */ void println(String var1);

    public abstract /* synthetic */ void println();

    public abstract /* synthetic */ void setLockValues(boolean var1);

    public abstract /* synthetic */ void setValue(String var1, Object var2);

    public abstract /* synthetic */ void setValue(String var1, double var2);

    public abstract /* synthetic */ void setValue(String var1, int var2);

    public abstract /* synthetic */ void setValue(String var1, boolean var2);
}

