/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ListChooser
extends JDialog {
    private JPanel checkPane = new JPanel();
    private Object[] objects;
    private boolean[] selections;
    private JCheckBox[] checkBoxes;
    private boolean applyChanges = false;

    public ListChooser(String title, String text) {
        this(title, text, null);
    }

    public ListChooser(String title, String text, Component owner) {
        super(JOptionPane.getFrameForComponent(owner), true);
        this.setTitle(title);
        JLabel textLabel = new JLabel(" " + text);
        JButton cancelButton = new JButton("Cancel");
        JButton okButton = new JButton("OK");
        JButton selectAllButton = new JButton("Select_All");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((Component)ListChooser.this).setVisible(false);
            }
        });
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < ListChooser.this.checkBoxes.length; ++i) {
                    ((ListChooser)ListChooser.this).selections[i] = ListChooser.this.checkBoxes[i].isSelected();
                }
                ListChooser.this.applyChanges = true;
                ((Component)ListChooser.this).setVisible(false);
            }
        });
        selectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < ListChooser.this.checkBoxes.length; ++i) {
                    ListChooser.this.checkBoxes[i].setSelected(true);
                }
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        JPanel headerPane = new JPanel();
        headerPane.setLayout(new BoxLayout(headerPane, 0));
        headerPane.add(textLabel);
        headerPane.add(Box.createHorizontalGlue());
        headerPane.add(selectAllButton);
        headerPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.checkPane.setLayout(new BoxLayout(this.checkPane, 1));
        this.checkPane.setBackground(Color.white);
        JScrollPane scroller = new JScrollPane(this.checkPane);
        scroller.setPreferredSize(new Dimension(250, 180));
        JPanel scrollPane = new JPanel(new BorderLayout());
        scrollPane.add((Component)scroller, "Center");
        scrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(cancelButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(okButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)headerPane, "North");
        contentPane.add((Component)scrollPane, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        ((Component)this).setLocation(x, y);
    }

    public boolean choose(Collection choices, Collection names) {
        this.checkPane.removeAll();
        this.checkBoxes = new JCheckBox[choices.size()];
        this.selections = new boolean[choices.size()];
        this.objects = new Object[choices.size()];
        ArrayList nameList = new ArrayList();
        if (names != null) {
            nameList.addAll(names);
        }
        Iterator it = choices.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.objects[i] = it.next();
            this.selections[i] = false;
            this.checkBoxes[i] = nameList.get(i) == null ? new JCheckBox(this.objects[i].toString()) : new JCheckBox(nameList.get(i).toString());
            this.checkBoxes[i].setBackground(Color.white);
            this.checkPane.add(this.checkBoxes[i]);
            ++i;
        }
        ((Component)this).setVisible(true);
        if (!this.applyChanges) {
            return false;
        }
        for (i = 0; i < this.objects.length; ++i) {
            if (this.selections[i]) continue;
            choices.remove(this.objects[i]);
        }
        return true;
    }
}

