/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.opensourcephysics.controls.ConsoleLevel;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.tools.ToolsRes;

public class MessageFrame
extends JFrame {
    static final Color DARK_GREEN = new Color(0, 128, 0);
    static final Color DARK_BLUE = new Color(0, 0, 128);
    static final Color DARK_RED = new Color(128, 0, 0);
    static Style black;
    static Style red;
    static Style blue;
    static Style green;
    static Style magenta;
    static Style gray;
    static MessageFrame APPLET_MESSAGEFRAME;
    static int levelOSP;
    private static int OFF;
    private static int SEVERE;
    private static int WARNING;
    private static int INFO;
    private static int ERR;
    private static int OUT;
    private static int CONFIG;
    private static int FINE;
    private static int FINER;
    private static int FINEST;
    private static int ALL;
    private JTextPane textPane;
    private static ArrayList buttonList;

    private MessageFrame() {
        this.setTitle(ControlsRes.getString("MessageFrame.DefaultTitle"));
        JPanel logPanel = new JPanel(new BorderLayout());
        logPanel.setPreferredSize(new Dimension(480, 240));
        this.setContentPane(logPanel);
        this.textPane = new JTextPane();
        logPanel.setPreferredSize(new Dimension(200, 300));
        logPanel.setMinimumSize(new Dimension(100, 100));
        this.textPane.setEditable(false);
        this.textPane.setAutoscrolls(true);
        black = StyleContext.getDefaultStyleContext().getStyle("default");
        red = this.textPane.addStyle("red", black);
        StyleConstants.setForeground(red, DARK_RED);
        blue = this.textPane.addStyle("blue", black);
        StyleConstants.setForeground(blue, DARK_BLUE);
        green = this.textPane.addStyle("green", black);
        StyleConstants.setForeground(green, DARK_GREEN);
        magenta = this.textPane.addStyle("magenta", black);
        StyleConstants.setForeground(magenta, Color.MAGENTA);
        gray = this.textPane.addStyle("gray", black);
        StyleConstants.setForeground(gray, Color.GRAY);
        JScrollPane textScroller = new JScrollPane(this.textPane);
        textScroller.setWheelScrollingEnabled(true);
        logPanel.add((Component)textScroller, "Center");
        this.pack();
    }

    public static void showLog(boolean b) {
        if (APPLET_MESSAGEFRAME == null || !APPLET_MESSAGEFRAME.isDisplayable()) {
            MessageFrame.createAppletMessageFrame();
        }
        ((Component)APPLET_MESSAGEFRAME).setVisible(b);
    }

    private static void createAppletMessageFrame() {
        APPLET_MESSAGEFRAME = new MessageFrame();
        ((Component)APPLET_MESSAGEFRAME).setSize(300, 200);
        APPLET_MESSAGEFRAME.setDefaultCloseOperation(1);
        JMenuBar menuBar = new JMenuBar();
        APPLET_MESSAGEFRAME.setJMenuBar(menuBar);
        final JMenu editMenu = new JMenu(ControlsRes.getString("MessageFrame.Edit_menu"));
        menuBar.add(editMenu);
        final JMenuItem clearItem = new JMenuItem(ControlsRes.getString("MessageFrame.Clear_menu_item"));
        editMenu.add(clearItem);
        clearItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                APPLET_MESSAGEFRAME.textPane.setText("");
            }
        });
        final JMenu levelMenu = new JMenu(ControlsRes.getString("MessageFrame.Level_menu"));
        menuBar.add(levelMenu);
        ButtonGroup menubarGroup = new ButtonGroup();
        for (int i = 0; i < OSPLog.levels.length; ++i) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(OSPLog.levels[i].getName());
            buttonList.add(item);
            levelMenu.add((Component)item, 0);
            menubarGroup.add(item);
            if (levelOSP == OSPLog.levels[i].intValue()) {
                item.setSelected(true);
            }
            item.setActionCommand(OSPLog.levels[i].getName());
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MessageFrame.setLevel(Level.parse(e.getActionCommand()));
                }
            });
        }
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                APPLET_MESSAGEFRAME.setTitle(ControlsRes.getString("MessageFrame.DefaultTitle"));
                editMenu.setText(ControlsRes.getString("MessageFrame.Edit_menu"));
                clearItem.setText(ControlsRes.getString("MessageFrame.Clear_menu"));
                levelMenu.setText(ControlsRes.getString("MessageFrame.Level_menu"));
            }
        });
    }

    public static boolean isLogVisible() {
        if (APPLET_MESSAGEFRAME == null) {
            return false;
        }
        return APPLET_MESSAGEFRAME.isVisible();
    }

    public static void clear() {
        if (APPLET_MESSAGEFRAME != null) {
            MessageFrame.APPLET_MESSAGEFRAME.textPane.setText("");
        }
    }

    public static void setLevel(Level level) {
        levelOSP = level.intValue();
        int n = Math.min(OSPLog.levels.length, buttonList.size());
        for (int i = 0; i < n; ++i) {
            if (levelOSP != OSPLog.levels[i].intValue()) continue;
            ((JRadioButtonMenuItem)buttonList.get(i)).setSelected(true);
        }
    }

    public static void severe(String msg) {
        if (levelOSP <= SEVERE) {
            MessageFrame.appletLog(msg, red);
        }
    }

    public static void warning(String msg) {
        if (levelOSP <= WARNING) {
            MessageFrame.appletLog(msg, red);
        }
    }

    public static void info(String msg) {
        if (levelOSP <= INFO) {
            MessageFrame.appletLog(msg, black);
        }
    }

    public static void config(String msg) {
        if (levelOSP <= CONFIG) {
            MessageFrame.appletLog(msg, green);
        }
    }

    public static void fine(String msg) {
        if (levelOSP <= FINE) {
            MessageFrame.appletLog(msg, blue);
        }
    }

    public static void finer(String msg) {
        if (levelOSP <= FINER) {
            MessageFrame.appletLog(msg, blue);
        }
    }

    public static void finest(String msg) {
        if (levelOSP <= FINEST) {
            MessageFrame.appletLog(msg, blue);
        }
    }

    private static void appletLog(final String msg, final Style style) {
        if (APPLET_MESSAGEFRAME == null || !APPLET_MESSAGEFRAME.isDisplayable()) {
            MessageFrame.createAppletMessageFrame();
        }
        Runnable refreshText = new Runnable(){

            public synchronized void run() {
                try {
                    Document doc = APPLET_MESSAGEFRAME.textPane.getDocument();
                    doc.insertString(doc.getLength(), msg + '\n', style);
                    Rectangle rect = APPLET_MESSAGEFRAME.textPane.getBounds();
                    rect.y = rect.height;
                    APPLET_MESSAGEFRAME.textPane.scrollRectToVisible(rect);
                }
                catch (BadLocationException ex) {
                    System.err.println(ex);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            refreshText.run();
        } else {
            SwingUtilities.invokeLater(refreshText);
        }
    }

    static {
        levelOSP = Level.CONFIG.intValue();
        OFF = Level.OFF.intValue();
        SEVERE = Level.SEVERE.intValue();
        WARNING = Level.WARNING.intValue();
        INFO = Level.INFO.intValue();
        ERR = ConsoleLevel.ERR_CONSOLE.intValue();
        OUT = ConsoleLevel.OUT_CONSOLE.intValue();
        CONFIG = Level.CONFIG.intValue();
        FINE = Level.FINE.intValue();
        FINER = Level.FINER.intValue();
        FINEST = Level.FINEST.intValue();
        ALL = Level.ALL.intValue();
        buttonList = new ArrayList();
    }
}

