/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.OSPControl;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTable;
import org.opensourcephysics.numerics.DoubleArray;
import org.opensourcephysics.numerics.IntegerArray;
import org.opensourcephysics.numerics.Util;

public class OSPControlTable
extends XMLTable
implements Control {
    static Color ERROR_COLOR = Color.PINK;
    private HashMap valueCache = new HashMap();
    private boolean lockValues = false;
    private DecimalFormat format;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$org$opensourcephysics$numerics$DoubleArray;
    static /* synthetic */ Class class$org$opensourcephysics$numerics$IntegerArray;

    public OSPControlTable() {
        this(new XMLControlElement());
    }

    public OSPControlTable(XMLControlElement control) {
        super(control);
    }

    public void setLockValues(boolean lock) {
        this.tableModel.control.setLockValues(lock);
        this.lockValues = lock;
        if (!this.lockValues) {
            this.refresh();
        }
    }

    public void setValue(String par, Object val) {
        if (this.getBackgroundColor(par) == ERROR_COLOR) {
            this.setBackgroundColor(par, Color.WHITE);
        }
        this.tableModel.control.setValue(par, val);
        if (!this.lockValues) {
            this.refresh();
        }
    }

    public void setDecimalFormat(String pattern) {
        this.format = pattern == null ? null : new DecimalFormat(pattern);
    }

    public void setValue(String par, double val) {
        if (this.format == null) {
            this.setValue(par, Double.toString(val));
        } else {
            this.setValue(par, this.format.format(val));
        }
        if (!Double.isNaN(val)) {
            this.valueCache.put(par, new Double(val));
        }
    }

    public void setValue(String par, int val) {
        this.setValue(par, Integer.toString(val));
        this.valueCache.put(par, new Double(val));
    }

    public void setValue(String par, boolean val) {
        if (this.getBackgroundColor(par) == ERROR_COLOR) {
            this.setBackgroundColor(par, Color.WHITE);
        }
        this.tableModel.control.setValue(par, val);
    }

    public int getInt(String par) {
        String str = this.tableModel.control.getString(par);
        Color color = (Color)this.cellColors.get(par);
        boolean editable = this.isEditable(par);
        try {
            int val = Integer.parseInt(par);
            if (editable && color != Color.WHITE) {
                this.setBackgroundColor(par, Color.WHITE);
                this.refresh();
            } else if (!editable && color != OSPControl.NOT_EDITABLE_BACKGROUND) {
                this.setBackgroundColor(par, OSPControl.NOT_EDITABLE_BACKGROUND);
                this.refresh();
            }
            this.valueCache.put(par, new Double(val));
            return val;
        }
        catch (NumberFormatException ex) {
            try {
                int val = (int)Double.parseDouble(par);
                if (editable && color != Color.WHITE) {
                    this.setBackgroundColor(par, Color.WHITE);
                    this.refresh();
                } else if (!editable && color != OSPControl.NOT_EDITABLE_BACKGROUND) {
                    this.setBackgroundColor(par, OSPControl.NOT_EDITABLE_BACKGROUND);
                    this.refresh();
                }
                this.valueCache.put(par, new Double(val));
                return val;
            }
            catch (NumberFormatException ex2) {
                double dval = Util.evalMath(str);
                if (Double.isNaN(dval) && color != ERROR_COLOR) {
                    this.setBackgroundColor(par, ERROR_COLOR);
                    this.refresh();
                    if (this.valueCache.containsKey(par)) {
                        return (int)((Double)this.valueCache.get(par)).doubleValue();
                    }
                    return 0;
                }
                if (editable && color != Color.WHITE) {
                    this.setBackgroundColor(par, Color.WHITE);
                    this.refresh();
                } else if (!editable && color != OSPControl.NOT_EDITABLE_BACKGROUND) {
                    this.setBackgroundColor(par, OSPControl.NOT_EDITABLE_BACKGROUND);
                    this.refresh();
                }
                this.valueCache.put(par, new Double(dval));
                return (int)dval;
            }
        }
    }

    public boolean inputError(String par) {
        return this.getBackgroundColor(par) == ERROR_COLOR;
    }

    public double getDouble(String par) {
        String str = this.tableModel.control.getString(par);
        Color color = (Color)this.cellColors.get(par);
        boolean editable = this.isEditable(par);
        try {
            double val = Double.parseDouble(str);
            if (editable && color != Color.WHITE) {
                this.setBackgroundColor(par, Color.WHITE);
                this.refresh();
            } else if (!editable && color != OSPControl.NOT_EDITABLE_BACKGROUND) {
                this.setBackgroundColor(par, OSPControl.NOT_EDITABLE_BACKGROUND);
                this.refresh();
            }
            this.valueCache.put(par, new Double(val));
            return val;
        }
        catch (NumberFormatException ex) {
            double val = Util.evalMath(str);
            if (Double.isNaN(val) && color != ERROR_COLOR) {
                this.setBackgroundColor(par, ERROR_COLOR);
                this.refresh();
            } else if (editable && color != Color.WHITE) {
                this.setBackgroundColor(par, Color.WHITE);
                this.refresh();
            } else if (!editable && color != OSPControl.NOT_EDITABLE_BACKGROUND) {
                this.setBackgroundColor(par, OSPControl.NOT_EDITABLE_BACKGROUND);
                this.refresh();
            }
            if (Double.isNaN(val) && this.valueCache.containsKey(par)) {
                val = (Double)this.valueCache.get(par);
            } else {
                this.valueCache.put(par, new Double(val));
            }
            return val;
        }
    }

    public Object getObject(String par) throws UnsupportedOperationException {
        return this.tableModel.control.getObject(par);
    }

    public String getString(String par) {
        return this.tableModel.control.getString(par);
    }

    public boolean getBoolean(String par) {
        return this.tableModel.control.getBoolean(par);
    }

    public Collection getPropertyNames() {
        return this.tableModel.control.getPropertyNames();
    }

    public void removeParameter(String par) {
        this.tableModel.control.setValue(par, null);
        this.setBackgroundColor(par, Color.WHITE);
    }

    public void println(String s) {
        this.tableModel.control.println(s);
    }

    public void println() {
        this.tableModel.control.println();
    }

    public void print(String s) {
        this.tableModel.control.print(s);
    }

    public void clearMessages() {
        this.tableModel.control.clearMessages();
    }

    public void clearValues() {
        this.tableModel.control.clearValues();
    }

    public void calculationDone(String message) {
        if (message != null) {
            this.tableModel.control.calculationDone(message);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new OSPControlTableLoader();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class OSPControlTableLoader
    implements XML.ObjectLoader {
        OSPControlTableLoader() {
        }

        public void saveObject(XMLControl xmlControl, Object obj) {
            OSPControl ospControl = (OSPControl)obj;
            Iterator it = ospControl.getPropertyNames().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                Object val = ospControl.getObject(name);
                if (val.getClass() == (class$org$opensourcephysics$numerics$DoubleArray == null ? OSPControlTable.class$("org.opensourcephysics.numerics.DoubleArray") : class$org$opensourcephysics$numerics$DoubleArray)) {
                    xmlControl.setValue(name, ((DoubleArray)val).getArray());
                    continue;
                }
                if (val.getClass() == (class$org$opensourcephysics$numerics$IntegerArray == null ? OSPControlTable.class$("org.opensourcephysics.numerics.IntegerArray") : class$org$opensourcephysics$numerics$IntegerArray)) {
                    xmlControl.setValue(name, ((IntegerArray)val).getArray());
                    continue;
                }
                if (val.getClass() == (class$java$lang$Boolean == null ? OSPControlTable.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    xmlControl.setValue(name, (Boolean)val);
                    continue;
                }
                if (val.getClass() == (class$java$lang$Double == null ? OSPControlTable.class$("java.lang.Double") : class$java$lang$Double)) {
                    xmlControl.setValue(name, (Double)val);
                    continue;
                }
                if (val.getClass() == (class$java$lang$Integer == null ? OSPControlTable.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    xmlControl.setValue(name, (Integer)val);
                    continue;
                }
                if (val.getClass().isArray()) {
                    xmlControl.setValue(name, val);
                    continue;
                }
                xmlControl.setValue(name, val);
            }
        }

        public Object createObject(XMLControl control) {
            return new OSPControlTable();
        }

        public Object loadObject(XMLControl control, Object obj) {
            OSPControl cf = (OSPControl)obj;
            Iterator it = control.getPropertyNames().iterator();
            cf.control.setLockValues(true);
            while (it.hasNext()) {
                String name = (String)it.next();
                if (control.getPropertyType(name).equals("string")) {
                    cf.setValue(name, control.getString(name));
                    continue;
                }
                if (control.getPropertyType(name).equals("int")) {
                    cf.setValue(name, control.getInt(name));
                    continue;
                }
                if (control.getPropertyType(name).equals("double")) {
                    cf.setValue(name, control.getDouble(name));
                    continue;
                }
                if (control.getPropertyType(name).equals("boolean")) {
                    cf.setValue(name, control.getBoolean(name));
                    continue;
                }
                cf.setValue(name, control.getObject(name));
            }
            cf.control.setLockValues(false);
            return obj;
        }
    }
}

