/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.EventQueue;
import java.awt.Font;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JTextArea;
import org.opensourcephysics.controls.VariableNotFoundException;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;

public class ParsableTextArea
extends JTextArea {
    HashMap pendingMap = new LinkedHashMap();
    HashMap currentMap = new LinkedHashMap();
    HashMap lockedMap = new LinkedHashMap();
    boolean locked = false;

    public ParsableTextArea() {
        super(10, 10);
        this.setFont(new Font("Monospaced", 0, 12));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String variable) throws VariableNotFoundException {
        if (this.locked) {
            HashMap hashMap = this.lockedMap;
            synchronized (hashMap) {
                String val = (String)this.lockedMap.get(variable);
                if (val != null) {
                    return (String)this.lockedMap.get(variable);
                }
                throw new VariableNotFoundException("Variable " + variable + " not found.");
            }
        }
        HashMap hashMap = this.currentMap;
        synchronized (hashMap) {
            this.updateCurrentMap();
            Object val = this.pendingMap;
            synchronized (val) {
                this.currentMap.putAll(this.pendingMap);
            }
            val = (String)this.currentMap.get(variable);
            if (val != null) {
                return val;
            }
        }
        throw new VariableNotFoundException("Variable " + variable + " not found.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setLockValues(boolean lock) {
        if (this.locked == lock) {
            return;
        }
        this.locked = lock;
        if (this.locked) {
            HashMap hashMap = this.lockedMap;
            synchronized (hashMap) {
                this.lockedMap.clear();
                HashMap hashMap2 = this.currentMap;
                synchronized (hashMap2) {
                    this.updateCurrentMap();
                    this.lockedMap.putAll(this.currentMap);
                }
                hashMap2 = this.pendingMap;
                synchronized (hashMap2) {
                    this.lockedMap.putAll(this.pendingMap);
                }
            }
        }
        this.setValue(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String variable, String val) {
        HashMap hashMap;
        Runnable doLater = new Runnable(){

            public void run() {
                ParsableTextArea.this.updateText();
            }
        };
        if (variable != null) {
            hashMap = this.pendingMap;
            synchronized (hashMap) {
                this.pendingMap.put(variable, val);
            }
        }
        if (this.locked && variable != null) {
            hashMap = this.lockedMap;
            synchronized (hashMap) {
                this.lockedMap.put(variable, val);
            }
        }
        if (!this.locked) {
            EventQueue.invokeLater(doLater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getCurrentMap() {
        HashMap hashMap = this.currentMap;
        synchronized (hashMap) {
            this.updateCurrentMap();
            HashMap hashMap2 = this.pendingMap;
            synchronized (hashMap2) {
                this.currentMap.putAll(this.pendingMap);
            }
            return (HashMap)this.currentMap.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateText() {
        HashMap hashMap = this.currentMap;
        synchronized (hashMap) {
            HashMap hashMap2 = this.pendingMap;
            synchronized (hashMap2) {
                if (this.pendingMap.size() == 0) {
                    return;
                }
                this.updateCurrentMap();
                this.currentMap.putAll(this.pendingMap);
                this.pendingMap.clear();
            }
            Set set = this.currentMap.keySet();
            Iterator it = set.iterator();
            StringBuffer newText = new StringBuffer(set.size() * 25);
            while (it.hasNext()) {
                String variable = (String)it.next();
                newText.append(variable);
                newText.append('=');
                newText.append(this.currentMap.get(variable));
                newText.append('\n');
            }
            this.setText(newText.toString());
        }
    }

    private void updateCurrentMap() {
        this.currentMap.clear();
        String text = this.getText();
        StringTokenizer st = new StringTokenizer(text, "\n");
        while (st.hasMoreTokens()) {
            String aLine = st.nextToken().trim();
            int index = aLine.indexOf("=");
            if (aLine == null || index == -1) continue;
            this.currentMap.put(aLine.subSequence(0, index), aLine.subSequence(index + 1, aLine.length()));
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new ParsableTextAreaLoader();
    }

    static class ParsableTextAreaLoader
    implements XML.ObjectLoader {
        ParsableTextAreaLoader() {
        }

        public void saveObject(XMLControl element, Object obj) {
            HashMap map = ((ParsableTextArea)obj).getCurrentMap();
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String variable = (String)it.next();
                element.setValue(variable, map.get(variable));
            }
        }

        public Object createObject(XMLControl element) {
            return new ParsableTextArea();
        }

        public Object loadObject(XMLControl element, Object obj) {
            ParsableTextArea pta = (ParsableTextArea)obj;
            Iterator it = element.getPropertyNames().iterator();
            pta.setLockValues(true);
            while (it.hasNext()) {
                String variable = (String)it.next();
                pta.setValue(variable, element.getString(variable));
            }
            pta.setLockValues(false);
            return obj;
        }
    }
}

