/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.Cryptic;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.Password;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLPropertyElement;
import org.opensourcephysics.controls.XMLTree;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class XMLControlElement
implements XMLControl {
    public static final int ALWAYS_DECRYPT = 0;
    public static final int PASSWORD_DECRYPT = 3;
    public static final int NEVER_DECRYPT = 5;
    public static int compactArraySize = 0;
    protected static String encoding = "UTF-8";
    protected String className = (class$java$lang$Object == null ? (class$java$lang$Object = XMLControlElement.class$("java.lang.Object")) : class$java$lang$Object).getName();
    protected Class theClass = null;
    protected String name;
    protected Map counts = new HashMap();
    protected Object object;
    protected XMLProperty parent;
    protected int level;
    protected ArrayList propNames = new ArrayList();
    protected ArrayList props = new ArrayList();
    protected BufferedReader input;
    protected BufferedWriter output;
    public boolean canWrite;
    protected boolean valid = false;
    protected boolean readFailed = false;
    protected String version;
    protected String doctype = "osp10.dtd";
    private String basepath;
    private String password;
    private int decryptPolicy = 0;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$opensourcephysics$controls$Cryptic;

    public XMLControlElement() {
    }

    public XMLControlElement(Class type) {
        this();
        this.setObjectClass(type);
    }

    public XMLControlElement(Object obj) {
        this();
        this.setObjectClass(obj.getClass());
        this.saveObject(obj);
    }

    public XMLControlElement(XMLProperty parent) {
        this();
        this.parent = parent;
        this.level = parent.getLevel();
    }

    public XMLControlElement(String input) {
        this();
        if (input.startsWith("<?xml")) {
            this.readXML(input);
        } else {
            this.read(input);
        }
    }

    public XMLControlElement(XMLControl control) {
        this();
        this.readXML(control.toXML());
    }

    public void setLockValues(boolean lock) {
    }

    public void setValue(String name, boolean value) {
        if (name == null) {
            return;
        }
        this.setXMLProperty(name, "boolean", String.valueOf(value));
    }

    public void setValue(String name, double value) {
        if (name == null) {
            return;
        }
        this.setXMLProperty(name, "double", String.valueOf(value));
    }

    public void setValue(String name, int value) {
        if (name == null) {
            return;
        }
        this.setXMLProperty(name, "int", String.valueOf(value));
    }

    public void setValue(String name, Object obj) {
        if (name == null) {
            return;
        }
        if (obj == null) {
            Iterator it = ((AbstractList)this.props).iterator();
            while (it.hasNext()) {
                XMLProperty prop = (XMLProperty)it.next();
                if (!name.equals(prop.getPropertyName())) continue;
                it.remove();
                ((AbstractCollection)this.propNames).remove(name);
                break;
            }
            return;
        }
        String type = XML.getDataType(obj);
        if (type != null) {
            if (type.equals("int") || type.equals("double")) {
                obj = obj.toString();
            }
            this.setXMLProperty(name, type, obj);
        }
    }

    public boolean getBoolean(String name) {
        XMLProperty prop = this.getXMLProperty(name);
        if (prop != null && prop.getPropertyType().equals("boolean")) {
            return "true".equals(prop.getPropertyContent().get(0));
        }
        return false;
    }

    public double getDouble(String name) {
        XMLProperty prop = this.getXMLProperty(name);
        if (prop != null && (prop.getPropertyType().equals("double") || prop.getPropertyType().equals("int"))) {
            return Double.parseDouble((String)prop.getPropertyContent().get(0));
        }
        return Double.NaN;
    }

    public int getInt(String name) {
        XMLProperty prop = this.getXMLProperty(name);
        if (prop != null && prop.getPropertyType().equals("int")) {
            return Integer.parseInt((String)prop.getPropertyContent().get(0));
        }
        return Integer.MIN_VALUE;
    }

    public String getString(String name) {
        XMLProperty prop = this.getXMLProperty(name);
        if (prop != null && prop.getPropertyType().equals("string")) {
            String content = (String)prop.getPropertyContent().get(0);
            if (content.indexOf("<![CDATA[") != -1) {
                content = content.substring(content.indexOf("<![CDATA[") + "<![CDATA[".length(), content.indexOf("]]>"));
            }
            return content;
        }
        if (name.equals("basepath") && this.getRootControl() != null) {
            return this.getRootControl().basepath;
        }
        return null;
    }

    public Object getObject(String name) {
        XMLProperty prop = this.getXMLProperty(name);
        if (prop != null) {
            String type = prop.getPropertyType();
            if (type.equals("object")) {
                return this.objectValue(prop);
            }
            if (type.equals("array")) {
                return this.arrayValue(prop);
            }
            if (type.equals("collection")) {
                return this.collectionValue(prop);
            }
            if (type.equals("int")) {
                return new Integer(this.intValue(prop));
            }
            if (type.equals("double")) {
                return new Double(this.doubleValue(prop));
            }
            if (type.equals("boolean")) {
                return new Boolean(this.booleanValue(prop));
            }
            if (type.equals("string")) {
                return this.stringValue(prop);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getPropertyNames() {
        ArrayList arrayList = this.propNames;
        synchronized (arrayList) {
            return (List)this.propNames.clone();
        }
    }

    public String getPropertyType(String name) {
        XMLProperty prop = this.getXMLProperty(name);
        if (prop != null) {
            return prop.getPropertyType();
        }
        return null;
    }

    public void setPassword(String pass) {
        this.password = pass;
        if (this.getObjectClass() != (class$org$opensourcephysics$controls$Cryptic == null ? (class$org$opensourcephysics$controls$Cryptic = XMLControlElement.class$("org.opensourcephysics.controls.Cryptic")) : class$org$opensourcephysics$controls$Cryptic)) {
            this.setValue("xml_password", pass);
        }
    }

    public String getPassword() {
        if (this.password == null) {
            this.password = this.getString("xml_password");
        }
        return this.password;
    }

    public void setDecryptPolicy(int policy) {
        this.decryptPolicy = policy == 5 ? 5 : (policy == 3 ? 3 : 0);
    }

    public String read(String name) {
        OSPLog.finest("reading " + name);
        Resource res = ResourceLoader.getResource(name);
        if (res != null) {
            this.read(res.openReader());
            String path = XML.getDirectoryPath(name);
            if (!path.equals("")) {
                ResourceLoader.addSearchPath(path);
                this.basepath = path;
            } else {
                this.basepath = XML.getDirectoryPath(res.getAbsolutePath());
            }
            File file = res.getFile();
            this.canWrite = file != null && file.canWrite();
            return res.getAbsolutePath();
        }
        this.readFailed = true;
        return null;
    }

    public void readXML(String xml) {
        this.input = new BufferedReader(new StringReader(xml));
        this.readInput();
        if (!this.failedToRead()) {
            this.canWrite = false;
        }
    }

    public void read(Reader in) {
        this.input = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        this.readInput();
        try {
            this.input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean failedToRead() {
        return this.readFailed;
    }

    public String write(String fileName) {
        String dir;
        File file;
        this.canWrite = true;
        int n = fileName.lastIndexOf("/");
        if (n < 0) {
            n = fileName.lastIndexOf("\\");
        }
        if (n > 0 && !(file = new File(dir = fileName.substring(0, n + 1))).exists() && !file.mkdir()) {
            this.canWrite = false;
            return null;
        }
        try {
            File file2 = new File(fileName);
            if (file2.exists() && !file2.canWrite()) {
                JOptionPane.showMessageDialog(null, "File is read-only.");
                this.canWrite = false;
                return null;
            }
            FileOutputStream stream = new FileOutputStream(file2);
            Charset charset = Charset.forName(encoding);
            this.write(new OutputStreamWriter((OutputStream)stream, charset));
            if (file2.exists()) {
                String path = XML.getDirectoryPath(file2.getCanonicalPath());
                ResourceLoader.addSearchPath(path);
            }
            if (this.isValid()) {
                fileName = fileName.indexOf("/") != -1 ? fileName.substring(0, fileName.lastIndexOf("/") + 1) + this.getDoctype() : (fileName.indexOf("\\") != -1 ? fileName.substring(0, fileName.lastIndexOf("\\") + 1) + this.getDoctype() : this.doctype);
                this.writeDocType(new FileWriter(fileName));
            }
            if (file2.exists()) {
                return file2.getAbsolutePath();
            }
        }
        catch (IOException ex) {
            this.canWrite = false;
            OSPLog.warning(ex.getMessage());
        }
        return null;
    }

    public void write(Writer out) {
        try {
            this.output = new BufferedWriter(out);
            String xml = this.toXML();
            if (this.getPassword() != null) {
                Cryptic cryptic = new Cryptic(xml);
                XMLControlElement control = new XMLControlElement(cryptic);
                xml = control.toXML();
            }
            this.output.write(xml);
            this.output.flush();
            this.output.close();
        }
        catch (IOException ex) {
            OSPLog.info(ex.getMessage());
        }
    }

    public void writeDocType(Writer out) {
        try {
            this.output = new BufferedWriter(out);
            this.output.write(XML.getDTD(this.getDoctype()));
            this.output.flush();
            this.output.close();
        }
        catch (IOException ex) {
            OSPLog.info(ex.getMessage());
        }
    }

    public String toXML() {
        return this.toString();
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid && XML.getDTD(this.getDoctype()) != null;
    }

    public void setVersion(String vers) {
        this.version = vers;
    }

    public String getVersion() {
        return this.version;
    }

    public void setDoctype(String name) {
        if (XML.getDTD(name) != null) {
            // empty if block
        }
    }

    public String getDoctype() {
        return this.doctype;
    }

    public void setObjectClass(Class type) {
        if (this.object != null && !type.isInstance(this.object)) {
            throw new RuntimeException("Object " + this.object + " is not instance of " + type);
        }
        this.className = type.getName();
        this.theClass = type;
    }

    public Class getObjectClass() {
        if (this.className == null) {
            return null;
        }
        if (this.theClass != null && this.theClass.getName().equals(this.className)) {
            return this.theClass;
        }
        this.theClass = null;
        try {
            this.theClass = Class.forName(this.className);
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        ClassLoader loader = XML.getClassLoader();
        if (loader != null && this.theClass == null) {
            try {
                this.theClass = loader.loadClass(this.className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.theClass;
    }

    public String getObjectClassName() {
        return this.className;
    }

    public void saveObject(Object obj) {
        Class<?> type;
        if (obj == null) {
            obj = this.object;
        }
        if ((type = this.getObjectClass()) == null || type.equals(class$java$lang$Object == null ? (class$java$lang$Object = XMLControlElement.class$("java.lang.Object")) : class$java$lang$Object)) {
            if (obj == null) {
                return;
            }
            type = obj.getClass();
        }
        if (type.isInstance(obj)) {
            this.object = obj;
            this.className = obj.getClass().getName();
            this.clearValues();
            XML.ObjectLoader loader = XML.getLoader(type);
            loader.saveObject(this, obj);
        }
    }

    public Object loadObject(Object obj) {
        return this.loadObject(obj, false, false);
    }

    public Object loadObject(Object obj, boolean autoImport) {
        return this.loadObject(obj, autoImport, false);
    }

    public Object loadObject(Object obj, boolean autoImport, boolean importAll) {
        int result;
        Class<?> type = this.getObjectClass();
        if (type == null) {
            if (obj != null) {
                if (!autoImport && (result = JOptionPane.showConfirmDialog(null, "This XML data is for unknown class \"" + this.className + "\"." + XML.NEW_LINE + "Do you wish to import it into " + obj.getClass() + "?", "Mismatched Classes", 0, 2)) != 0) {
                    return obj;
                }
                if (!this.importInto(obj, importAll)) {
                    return obj;
                }
                type = obj.getClass();
            } else {
                return null;
            }
        }
        if (obj != null && !type.isInstance(obj)) {
            if (!autoImport && (result = JOptionPane.showConfirmDialog(null, "This XML data is for " + type + "." + XML.NEW_LINE + "Do you wish to import it into " + obj.getClass() + "?", "Mismatched Classes", 0, 2)) != 0) {
                return obj;
            }
            if (!this.importInto(obj, importAll)) {
                return obj;
            }
            type = obj.getClass();
        }
        XML.ObjectLoader loader = XML.getLoader(type);
        if (obj == null) {
            if (this.object == null) {
                this.object = loader.createObject(this);
            }
            obj = this.object;
        }
        if (obj == null) {
            return null;
        }
        if (type.isInstance(obj)) {
            this.object = obj = loader.loadObject(this, obj);
        }
        return obj;
    }

    public void clearValues() {
        this.props.clear();
        this.propNames.clear();
    }

    public void println(String s) {
        System.out.println(s);
    }

    public void println() {
        System.out.println();
    }

    public void print(String s) {
        System.out.print(s);
    }

    public void clearMessages() {
    }

    public void calculationDone(String s) {
    }

    public String getPropertyName() {
        XMLProperty parent = this.getParentProperty();
        if (this.className == null) {
            if (parent == null) {
                return "null";
            }
            return parent.getPropertyName();
        }
        if (this.isArrayOrCollectionItem()) {
            if (this.name == null) {
                XMLProperty root = this;
                while (root.getParentProperty() != null) {
                    root = root.getParentProperty();
                }
                if (root instanceof XMLControlElement) {
                    XMLProperty rootControl = root;
                    this.name = this.className.substring(this.className.lastIndexOf(".") + 1);
                    this.name = ((XMLControlElement)rootControl).addNumbering(this.name);
                }
            }
            return "" + this.name;
        }
        if (parent != null) {
            return parent.getPropertyName();
        }
        return this.className.substring(this.className.lastIndexOf(".") + 1);
    }

    public String getPropertyType() {
        return "object";
    }

    public Class getPropertyClass() {
        return this.getObjectClass();
    }

    public XMLProperty getParentProperty() {
        return this.parent;
    }

    public int getLevel() {
        return this.level;
    }

    public List getPropertyContent() {
        return this.props;
    }

    public XMLControl getChildControl(String name) {
        XMLControl[] children = this.getChildControls();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].getPropertyName().equals(name)) continue;
            return children[i];
        }
        return null;
    }

    public XMLControl[] getChildControls() {
        ArrayList list = new ArrayList();
        Iterator it = this.getPropertyContent().iterator();
        while (it.hasNext()) {
            XMLProperty prop = (XMLProperty)it.next();
            if (!prop.getPropertyType().equals("object")) continue;
            list.add(prop.getPropertyContent().get(0));
        }
        return list.toArray(new XMLControl[0]);
    }

    public XMLControlElement getRootControl() {
        if (this.parent == null) {
            return this;
        }
        XMLProperty prop = this.parent;
        while (prop.getParentProperty() != null) {
            prop = prop.getParentProperty();
        }
        if (prop instanceof XMLControlElement) {
            return (XMLControlElement)prop;
        }
        return null;
    }

    public String addNumbering(String name) {
        Integer count = (Integer)this.counts.get(name);
        if (count == null) {
            count = new Integer(0);
        }
        count = new Integer(count + 1);
        this.counts.put(name, count);
        return name + " " + count.toString();
    }

    public void setValue(String stringValue) {
    }

    public String toString() {
        List content;
        StringBuffer xml = new StringBuffer("");
        if (this.getLevel() == 0) {
            xml.append("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            if (this.isValid()) {
                xml.append(XML.NEW_LINE + "<!DOCTYPE object SYSTEM \"" + this.doctype + "\">");
            }
        }
        xml.append(XML.NEW_LINE + this.indent(this.getLevel()) + "<object class=\"" + this.className + "\"");
        if (this.version != null && this.getLevel() == 0) {
            xml.append(" version=\"" + this.version + "\"");
        }
        if ((content = this.getPropertyContent()).isEmpty()) {
            xml.append("/>");
        } else {
            xml.append(">");
            Iterator it = content.iterator();
            while (it.hasNext()) {
                xml.append(it.next().toString());
            }
            xml.append(XML.NEW_LINE + this.indent(this.getLevel()) + "</object>");
        }
        return xml.toString();
    }

    public List getObjects(Class type) {
        return this.getObjects(type, false);
    }

    public List getObjects(Class type, boolean useChooser) {
        List props;
        if (useChooser) {
            String name = type.getName();
            name = name.substring(name.lastIndexOf(".") + 1);
            XMLTreeChooser chooser = new XMLTreeChooser("Select Objects", "Class " + name, null);
            props = chooser.choose(this, type);
        } else {
            XMLTree tree = new XMLTree(this);
            tree.setHighlightedClass(type);
            tree.selectHighlightedProperties();
            props = tree.getSelectedProperties();
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        Iterator it = props.iterator();
        while (it.hasNext()) {
            XMLControl prop = (XMLControl)it.next();
            objects.add(prop.loadObject(null));
        }
        return objects;
    }

    public Object clone() {
        return new XMLControlElement(this);
    }

    private boolean isArrayOrCollectionItem() {
        XMLProperty parent = this.getParentProperty();
        if (parent != null) {
            return (parent = parent.getParentProperty()) != null && "arraycollection".indexOf(parent.getPropertyType()) >= 0;
        }
        return false;
    }

    private boolean importInto(Object obj, boolean importAll) {
        XMLControlElement control = new XMLControlElement(obj);
        Collection list = control.getPropertyNames();
        list.retainAll(this.getPropertyNames());
        ListChooser chooser = new ListChooser("Import", "Select items to import");
        if (importAll || chooser.choose(list, list)) {
            Iterator it = this.getPropertyContent().iterator();
            while (it.hasNext()) {
                XMLProperty prop = (XMLProperty)it.next();
                if (list.contains(prop.getPropertyName())) continue;
                it.remove();
                ((AbstractCollection)this.propNames).remove(prop.getPropertyName());
            }
            it = control.getPropertyNames().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                if (list.contains(name)) continue;
                String propType = control.getPropertyType(name);
                if (propType.equals("int")) {
                    this.setValue(name, control.getInt(name));
                    continue;
                }
                if (propType.equals("double")) {
                    this.setValue(name, control.getDouble(name));
                    continue;
                }
                if (propType.equals("boolean")) {
                    this.setValue(name, control.getBoolean(name));
                    continue;
                }
                if (propType.equals("string")) {
                    this.setValue(name, control.getString(name));
                    continue;
                }
                this.setValue(name, control.getObject(name));
            }
            return true;
        }
        return false;
    }

    private void setXMLProperty(String name, String type, Object value) {
        int i = -1;
        if (this.propNames.contains(name)) {
            Iterator it = ((AbstractList)this.props).iterator();
            while (it.hasNext()) {
                ++i;
                XMLProperty prop = (XMLProperty)it.next();
                if (!prop.getPropertyName().equals(name)) continue;
                it.remove();
                break;
            }
        } else {
            this.propNames.add(name);
        }
        if (i > -1) {
            this.props.add(i, new XMLPropertyElement(this, name, type, value));
        } else {
            this.props.add(new XMLPropertyElement(this, name, type, value));
        }
    }

    private XMLProperty getXMLProperty(String name) {
        if (name == null) {
            return null;
        }
        Iterator it = this.getPropertyContent().iterator();
        while (it.hasNext()) {
            XMLProperty prop = (XMLProperty)it.next();
            if (!name.equals(prop.getPropertyName())) continue;
            return prop;
        }
        return null;
    }

    private void readInput() {
        String xml;
        this.readFailed = false;
        try {
            String openingTag = this.input.readLine();
            while (openingTag != null && openingTag.indexOf("<object") == -1) {
                openingTag = this.input.readLine();
            }
            if (openingTag != null) {
                xml = openingTag;
                int i = xml.indexOf("version=");
                if (i != -1) {
                    xml = xml.substring(i + 9);
                    this.version = xml.substring(0, xml.indexOf("\""));
                }
            } else {
                this.readFailed = true;
                return;
            }
            this.readObject(this, openingTag);
        }
        catch (Exception ex) {
            this.readFailed = true;
            OSPLog.warning("Failed to read xml: " + ex.getMessage());
            return;
        }
        if ((class$org$opensourcephysics$controls$Cryptic == null ? (class$org$opensourcephysics$controls$Cryptic = XMLControlElement.class$("org.opensourcephysics.controls.Cryptic")) : class$org$opensourcephysics$controls$Cryptic).equals(this.getObjectClass())) {
            Cryptic cryptic = (Cryptic)this.loadObject(null);
            xml = cryptic.decrypt();
            XMLControlElement test = new XMLControlElement(xml);
            if (test.failedToRead()) {
                return;
            }
            String pass = this.password;
            this.password = test.getString("xml_password");
            switch (this.decryptPolicy) {
                case 5: {
                    return;
                }
                case 3: {
                    if (this.password == null || this.password.equals("") || this.password.equals(pass) || Password.verify(this.password, null)) break;
                    return;
                }
            }
            this.clearValues();
            this.object = null;
            this.className = (class$java$lang$Object == null ? (class$java$lang$Object = XMLControlElement.class$("java.lang.Object")) : class$java$lang$Object).getName();
            this.theClass = null;
            this.readXML(xml);
        }
    }

    private XMLControlElement readObject(XMLControlElement element, String xml) throws IOException {
        String packageName;
        element.clearValues();
        xml = xml.substring(xml.indexOf("class=") + 7);
        String className = xml.substring(0, xml.indexOf("\""));
        int i = className.lastIndexOf(".");
        if (i > -1 && (packageName = className.substring(0, i)).endsWith("org.opensourcephysics.media")) {
            className = packageName + ".core" + className.substring(i);
        }
        element.className = className;
        if (xml.indexOf("/>") != -1) {
            this.input.readLine();
            return element;
        }
        XMLControlElement prop = element;
        xml = this.input.readLine();
        while (xml != null) {
            if (xml.indexOf("</object>") != -1) {
                this.input.readLine();
                return element;
            }
            if (xml.indexOf("<property") != -1) {
                XMLPropertyElement child = this.readProperty(new XMLPropertyElement(prop), xml);
                element.props.add(child);
                element.propNames.add(child.getPropertyName());
            }
            xml = this.input.readLine();
        }
        return element;
    }

    private XMLPropertyElement readProperty(XMLPropertyElement prop, String xml) throws IOException {
        prop.name = xml.substring(xml.indexOf("name=") + 6, xml.indexOf("type=") - 2);
        xml = xml.substring(xml.indexOf("type=") + 6);
        prop.type = xml.substring(0, xml.indexOf("\""));
        if (prop.type.equals("array") || prop.type.equals("collection")) {
            String packageName;
            String className = (xml = xml.substring(xml.indexOf("class=") + 7)).substring(0, xml.indexOf("\""));
            int i = className.lastIndexOf(".");
            if (i > -1 && (packageName = className.substring(0, i)).endsWith("org.opensourcephysics.media")) {
                className = packageName + ".core" + className.substring(i);
            }
            prop.className = className;
            if (xml.indexOf("/>") != -1) {
                return prop;
            }
            xml = this.input.readLine();
            while (xml.indexOf("<property") != -1) {
                prop.content.add(this.readProperty(new XMLPropertyElement(prop), xml));
                xml = this.input.readLine();
            }
        } else if (prop.type.equals("object")) {
            XMLControlElement control = this.readObject(new XMLControlElement(prop), this.input.readLine());
            prop.content.add(control);
            prop.className = control.className;
        } else {
            if (xml.indexOf("<![CDATA[") != -1) {
                String s = xml.substring(xml.indexOf("<![CDATA["));
                while (s.indexOf("]]></property>") == -1) {
                    s = s + XML.NEW_LINE + this.input.readLine();
                }
                xml = s.substring(0, s.indexOf("]]></property>") + "]]>".length());
            } else {
                String s = xml.substring(xml.indexOf(">") + 1);
                while (s.indexOf("</property>") == -1) {
                    s = s + XML.NEW_LINE + this.input.readLine();
                }
                xml = s.substring(0, s.indexOf("</property>"));
            }
            prop.content.add(xml);
        }
        return prop;
    }

    private String indent(int level) {
        String space = "";
        for (int i = 0; i < 4 * level; ++i) {
            space = space + " ";
        }
        return space;
    }

    private Object objectValue(XMLProperty prop) {
        if (!prop.getPropertyType().equals("object")) {
            return null;
        }
        XMLControl control = (XMLControl)prop.getPropertyContent().get(0);
        return control.loadObject(null);
    }

    private double doubleValue(XMLProperty prop) {
        if (!prop.getPropertyType().equals("double")) {
            return Double.NaN;
        }
        return Double.parseDouble((String)prop.getPropertyContent().get(0));
    }

    private int intValue(XMLProperty prop) {
        if (!prop.getPropertyType().equals("int")) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt((String)prop.getPropertyContent().get(0));
    }

    private boolean booleanValue(XMLProperty prop) {
        return prop.getPropertyContent().get(0).equals("true");
    }

    private String stringValue(XMLProperty prop) {
        if (!prop.getPropertyType().equals("string")) {
            return null;
        }
        return (String)prop.getPropertyContent().get(0);
    }

    /*
     * Could not resolve type clashes
     */
    private Object arrayValue(XMLProperty prop) {
        if (!prop.getPropertyType().equals("array")) {
            return null;
        }
        Class<?> componentType = prop.getPropertyClass().getComponentType();
        List content = prop.getPropertyContent();
        if (content.isEmpty()) {
            return Array.newInstance(componentType, 0);
        }
        XMLProperty first = (XMLProperty)content.get(0);
        if (first.getPropertyName().equals("array")) {
            Object obj = first.getPropertyContent().get(0);
            if (obj instanceof String) {
                return this.arrayValue((String)obj, componentType);
            }
            return null;
        }
        XMLProperty last = (XMLProperty)content.get(content.size() - 1);
        String index = last.getPropertyName();
        int n = Integer.parseInt(index.substring(1, index.indexOf("]")));
        Object array = Array.newInstance(componentType, n + 1);
        Iterator it = content.iterator();
        while (it.hasNext()) {
            boolean val;
            XMLProperty next = (XMLProperty)it.next();
            index = next.getPropertyName();
            n = Integer.parseInt(index.substring(1, index.indexOf("]")));
            String type = next.getPropertyType();
            if (type.equals("object")) {
                Array.set(array, n, this.objectValue(next));
                continue;
            }
            if (type.equals("int")) {
                val = this.intValue(next);
                if ((class$java$lang$Object == null ? XMLControlElement.class$("java.lang.Object") : class$java$lang$Object).isAssignableFrom(componentType)) {
                    Array.set(array, n, new Integer(val ? 1 : 0));
                    continue;
                }
                Array.setInt(array, n, val ? 1 : 0);
                continue;
            }
            if (type.equals("double")) {
                double val2 = this.doubleValue(next);
                if ((class$java$lang$Object == null ? XMLControlElement.class$("java.lang.Object") : class$java$lang$Object).isAssignableFrom(componentType)) {
                    Array.set(array, n, new Double(val2));
                    continue;
                }
                Array.setDouble(array, n, val2);
                continue;
            }
            if (type.equals("boolean")) {
                val = this.booleanValue(next);
                if ((class$java$lang$Object == null ? XMLControlElement.class$("java.lang.Object") : class$java$lang$Object).isAssignableFrom(componentType)) {
                    Array.set(array, n, new Boolean(val));
                    continue;
                }
                Array.setBoolean(array, n, val);
                continue;
            }
            if (type.equals("string")) {
                Array.set(array, n, this.stringValue(next));
                continue;
            }
            if (type.equals("array")) {
                Array.set(array, n, this.arrayValue(next));
                continue;
            }
            if (!type.equals("collection")) continue;
            Array.set(array, n, this.collectionValue(next));
        }
        return array;
    }

    private Object arrayValue(String arrayString, Class componentType) {
        if (!arrayString.startsWith("{") || !arrayString.endsWith("}")) {
            return null;
        }
        String trimmed = arrayString.substring(1, arrayString.length() - 1);
        if (componentType.isArray()) {
            String opening = "";
            String closing = "";
            int n = 0;
            while (trimmed.substring(n, n + 1).equals("{")) {
                opening = opening + "{";
                closing = closing + "}";
                ++n;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            Class<?> arrayType = componentType.getComponentType();
            int i = trimmed.indexOf(opening);
            int j = trimmed.indexOf(closing);
            while (j > 0) {
                String nextArray = trimmed.substring(i, j + closing.length());
                Object obj = this.arrayValue(nextArray, arrayType);
                list.add(obj);
                trimmed = trimmed.substring(j + closing.length());
                i = trimmed.indexOf(opening);
                j = trimmed.indexOf(closing);
            }
            Object array = Array.newInstance(componentType, list.size());
            Iterator it = ((AbstractList)list).iterator();
            int n2 = 0;
            while (it.hasNext()) {
                Object obj = it.next();
                Array.set(array, n2++, obj);
            }
            return array;
        }
        ArrayList<String> list = new ArrayList<String>();
        while (!trimmed.equals("")) {
            int i = trimmed.indexOf(",");
            if (i > -1) {
                list.add(trimmed.substring(0, i));
                trimmed = trimmed.substring(i + 1);
                continue;
            }
            list.add(trimmed);
            break;
        }
        Object array = Array.newInstance(componentType, list.size());
        Iterator it = ((AbstractList)list).iterator();
        int n = 0;
        while (it.hasNext()) {
            if (componentType == Integer.TYPE) {
                int i = Integer.parseInt((String)it.next());
                Array.setInt(array, n++, i);
                continue;
            }
            if (componentType == Double.TYPE) {
                double x = Double.parseDouble((String)it.next());
                Array.setDouble(array, n++, x);
                continue;
            }
            if (componentType != Boolean.TYPE) continue;
            boolean bool = it.next().equals("true");
            Array.setBoolean(array, n++, bool);
        }
        return array;
    }

    private Object collectionValue(XMLProperty prop) {
        if (!prop.getPropertyType().equals("collection")) {
            return null;
        }
        Class classType = prop.getPropertyClass();
        try {
            Collection c = (Collection)classType.newInstance();
            List content = prop.getPropertyContent();
            Iterator it = content.iterator();
            while (it.hasNext()) {
                XMLProperty next = (XMLProperty)it.next();
                String type = next.getPropertyType();
                if (type.equals("object")) {
                    c.add(this.objectValue(next));
                    continue;
                }
                if (type.equals("string")) {
                    c.add(this.stringValue(next));
                    continue;
                }
                if (type.equals("array")) {
                    c.add(this.arrayValue(next));
                    continue;
                }
                if (!type.equals("collection")) continue;
                c.add(this.collectionValue(next));
            }
            return c;
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

