/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.OSPControlTable;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTable;

public class XMLTableInspector
extends JDialog
implements PropertyChangeListener {
    static final String FRAME_TITLE = "Properties of";
    private XMLTable table;

    public XMLTableInspector(XMLControl control) {
        this(control, true, true);
    }

    public XMLTableInspector(XMLControl control, boolean editable) {
        this(control, editable, true);
    }

    public XMLTableInspector(XMLControl control, boolean editable, boolean modal) {
        super((Frame)null, modal);
        this.table = new XMLTable(control);
        this.table.setEditable(editable);
        this.table.addPropertyChangeListener("cell", this);
        this.createGUI();
        String s = XML.getExtension(control.getObjectClassName());
        this.setTitle("Properties of " + s + " \"" + control.getPropertyName() + "\" ");
    }

    public XMLTableInspector(boolean editable, boolean modal) {
        super((Frame)null, modal);
        this.table = new OSPControlTable(new XMLControlElement());
        this.table.setEditable(editable);
        this.table.addPropertyChangeListener("cell", this);
        this.createGUI();
        String s = XML.getExtension(this.getXMLControl().getObjectClassName());
        this.setTitle("Properties of " + s + " \"" + this.getXMLControl().getPropertyName() + "\" ");
    }

    public Control getControl() {
        return this.table instanceof Control ? (Control)((Object)this.table) : this.table.tableModel.control;
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
    }

    public XMLTable getTable() {
        return this.table;
    }

    public XMLControl getXMLControl() {
        return this.table.tableModel.control;
    }

    private void createGUI() {
        ((Component)this).setSize(400, 300);
        this.setContentPane(new JPanel(new BorderLayout()));
        JScrollPane scrollpane = new JScrollPane(this.table);
        scrollpane.createHorizontalScrollBar();
        this.getContentPane().add((Component)scrollpane, "Center");
    }
}

