/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.util.Collection;
import java.util.HashSet;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.tools.ArrayInspector;

public class XMLTableModel
extends AbstractTableModel {
    XMLControl control;
    boolean editable = true;
    Collection uneditablePropNames = new HashSet();

    public XMLTableModel(XMLControl control) {
        this.control = control;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        return column == 0 ? ControlsRes.XML_NAME : ControlsRes.XML_VALUE;
    }

    public int getRowCount() {
        return this.control.getPropertyContent().size();
    }

    public Object getValueAt(int row, int column) {
        try {
            XMLProperty val = (XMLProperty)this.control.getPropertyContent().get(row);
            return column == 0 ? val.getPropertyName() : val.getPropertyContent().get(0);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        String propName = (String)this.getValueAt(row, 0);
        if (this.uneditablePropNames.contains(propName)) {
            return false;
        }
        Object value = this.getValueAt(row, col);
        if (value instanceof XMLControl) {
            return true;
        }
        if (value instanceof XMLProperty) {
            XMLProperty prop = (XMLProperty)value;
            XMLProperty parent = prop.getParentProperty();
            if (parent.getPropertyType().equals("array")) {
                return ArrayInspector.canInspect(parent);
            }
            return false;
        }
        return true;
    }

    public void setValueAt(Object value, int row, int col) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            String s = (String)value;
            XMLProperty prop = (XMLProperty)this.control.getPropertyContent().get(row);
            String type = prop.getPropertyType();
            if (type.equals("string")) {
                this.control.setValue(prop.getPropertyName(), s);
            } else if (type.equals("int")) {
                try {
                    int i = Integer.parseInt(s);
                    this.control.setValue(prop.getPropertyName(), i);
                }
                catch (NumberFormatException ex) {}
            } else if (type.equals("double")) {
                try {
                    double x = Double.parseDouble(s);
                    this.control.setValue(prop.getPropertyName(), x);
                }
                catch (NumberFormatException ex) {}
            } else if (type.equals("boolean")) {
                boolean bool = s.toLowerCase().startsWith("t");
                this.control.setValue(prop.getPropertyName(), bool);
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

