/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTreeNode;
import org.opensourcephysics.tools.ArrayInspector;
import org.opensourcephysics.tools.ResourceLoader;

public class XMLTreePanel
extends JPanel {
    protected JLabel label;
    protected JTextField input;
    protected JTextPane xmlPane;
    protected JTree tree;
    protected JScrollPane treeScroller = new JScrollPane();
    protected Icon valueIcon;
    protected Icon inspectIcon;
    protected Icon inspectFolderIcon;
    protected Icon folderIcon;
    protected XMLControl control;
    protected XMLProperty property;
    protected boolean editable;
    protected JPopupMenu popup;
    int maxStringLength = 24;

    public XMLTreePanel(XMLControl control) {
        this(control, true);
    }

    public XMLTreePanel(XMLControl control, boolean editable) {
        super(new BorderLayout());
        this.control = control;
        this.editable = editable;
        this.createGUI();
    }

    public void refresh() {
        XMLTreeNode root = this.createTree(this.control);
        this.displayProperty(root, this.editable);
    }

    public XMLControl getControl() {
        return this.control;
    }

    public XMLTreeNode setSelectedNode(String propertyName) {
        XMLTreeNode root = (XMLTreeNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            XMLTreeNode node = (XMLTreeNode)e.nextElement();
            XMLProperty prop = node.getProperty();
            if (!prop.getPropertyName().equals(propertyName)) continue;
            TreePath path = new TreePath(node.getPath());
            this.tree.setSelectionPath(path);
            this.tree.scrollPathToVisible(path);
            this.showInspector(node);
            return node;
        }
        return null;
    }

    protected void displayProperty(XMLTreeNode node, boolean editable) {
        Object value;
        this.input.setVisible(false);
        XMLProperty prop = node.getProperty();
        this.label.setText(prop.getPropertyType() + " " + prop.getPropertyName());
        if (!prop.getPropertyContent().isEmpty() && (value = prop.getPropertyContent().get(0)) instanceof String) {
            this.property = prop;
            String content = (String)value;
            if (content.indexOf("<![CDATA[") != -1) {
                content = content.substring(content.indexOf("<![CDATA[") + "<![CDATA[".length(), content.length() - "]]>".length());
            }
            this.input.setText(content);
            this.input.setEditable(editable);
            this.input.setVisible(true);
        }
        String xml = prop.toString();
        this.xmlPane.setText(this.getDisplay(xml));
        this.xmlPane.setCaretPosition(0);
    }

    protected String getDisplay(String xml) {
        String newXML = "";
        String preArray = "name=\"array\" type=\"string\">";
        String postArray = "</property>";
        int i = xml.indexOf(preArray);
        while (i > 0) {
            newXML = newXML + xml.substring(0, i += preArray.length());
            xml = xml.substring(i);
            i = xml.indexOf(postArray);
            String array = xml.substring(0, i);
            xml = xml.substring(i, xml.length());
            if (array.length() > this.maxStringLength) {
                array = array.substring(0, this.maxStringLength - 3) + "...";
            }
            newXML = newXML + array;
            i = xml.indexOf(preArray);
        }
        newXML = newXML + xml;
        return newXML;
    }

    protected void createGUI() {
        String imageFile = "/org/opensourcephysics/resources/controls/images/inspect.gif";
        this.inspectIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/controls/images/value.gif";
        this.valueIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/controls/images/folder.gif";
        this.folderIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/controls/images/inspectfolder.gif";
        this.inspectFolderIcon = ResourceLoader.getIcon(imageFile);
        this.popup = new JPopupMenu();
        JMenuItem item = new JMenuItem("Inspect...");
        this.popup.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XMLTreeNode node = (XMLTreeNode)XMLTreePanel.this.tree.getLastSelectedPathComponent();
                if (node != null) {
                    XMLTreePanel.this.showInspector(node);
                }
            }
        });
        XMLTreeNode root = this.createTree(this.control);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        this.label = new JLabel();
        toolbar.add(this.label);
        this.input = new JTextField(20);
        this.input.setVisible(false);
        this.input.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XMLTreePanel.this.property.setValue(XMLTreePanel.this.input.getText());
                Object obj = XMLTreePanel.this.control.loadObject(null);
                if (obj instanceof Component) {
                    ((Component)obj).repaint();
                }
                XMLTreePanel.this.input.setText((String)XMLTreePanel.this.property.getPropertyContent().get(0));
                XMLTreePanel.this.input.selectAll();
                XMLTreeNode node = (XMLTreeNode)XMLTreePanel.this.tree.getLastSelectedPathComponent();
                if (node != null) {
                    XMLTreePanel.this.displayProperty(node, XMLTreePanel.this.editable);
                }
            }
        });
        this.input.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!XMLTreePanel.this.editable) {
                    return;
                }
                JComponent comp = (JComponent)e.getSource();
                if (e.getKeyCode() == 10) {
                    comp.setBackground(Color.white);
                } else {
                    comp.setBackground(Color.yellow);
                }
            }
        });
        this.input.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                JComponent comp = (JComponent)e.getSource();
                comp.setBackground(Color.white);
            }
        });
        toolbar.add(this.input);
        this.xmlPane = new JTextPane();
        this.xmlPane.setPreferredSize(new Dimension(360, 200));
        this.xmlPane.setEditable(false);
        JScrollPane xmlScroller = new JScrollPane(this.xmlPane);
        JPanel dataPanel = new JPanel(new BorderLayout());
        dataPanel.add((Component)toolbar, "North");
        dataPanel.add((Component)xmlScroller, "Center");
        JSplitPane splitPane = new JSplitPane(1, this.treeScroller, dataPanel);
        this.add((Component)splitPane, "Center");
        this.treeScroller.setPreferredSize(new Dimension(140, 200));
        this.displayProperty(root, this.editable);
    }

    private XMLTreeNode createTree(XMLControl control) {
        XMLTreeNode root = new XMLTreeNode(control);
        this.tree = new JTree(root);
        this.tree.setCellRenderer(new XMLRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                XMLTreeNode node = (XMLTreeNode)XMLTreePanel.this.tree.getLastSelectedPathComponent();
                if (node != null) {
                    XMLTreePanel.this.displayProperty(node, XMLTreePanel.this.editable);
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger() || e.getButton() == 3 || e.isControlDown() && System.getProperty("os.name").indexOf("Mac") > -1) {
                    TreePath path = XMLTreePanel.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (path == null) {
                        return;
                    }
                    XMLTreePanel.this.tree.setSelectionPath(path);
                    XMLTreeNode node = (XMLTreeNode)XMLTreePanel.this.tree.getLastSelectedPathComponent();
                    if (node.isInspectable()) {
                        XMLTreePanel.this.popup.show(XMLTreePanel.this.tree, e.getX(), e.getY() + 8);
                    }
                }
            }
        });
        this.treeScroller.setViewportView(this.tree);
        return root;
    }

    private void showInspector(XMLTreeNode node) {
        XMLProperty arrayProp;
        ArrayInspector inspector;
        if (node == null) {
            return;
        }
        if (node.getProperty().getPropertyType().equals("array") && (inspector = ArrayInspector.getInspector(arrayProp = node.getProperty())) != null) {
            String name = arrayProp.getPropertyName();
            XMLProperty parent = arrayProp.getParentProperty();
            while (!(parent instanceof XMLControl)) {
                name = parent.getPropertyName();
                arrayProp = parent;
                parent = parent.getParentProperty();
            }
            final XMLControl arrayControl = (XMLControl)parent;
            final String arrayName = name;
            final Object arrayObj = inspector.getArray();
            final XMLTreeNode parentNode = (XMLTreeNode)node.getParent();
            inspector.setEditable(this.editable);
            inspector.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("cell")) {
                        arrayControl.setValue(arrayName, arrayObj);
                        XMLTreePanel.this.control.loadObject(null);
                        Iterator it = arrayControl.getPropertyContent().iterator();
                        block0: while (it.hasNext()) {
                            XMLProperty next = (XMLProperty)it.next();
                            if (!next.getPropertyName().equals(arrayName)) continue;
                            for (int i = 0; i < parentNode.getChildCount(); ++i) {
                                XMLTreeNode node = (XMLTreeNode)parentNode.getChildAt(i);
                                if (!node.getProperty().getPropertyName().equals(arrayName)) continue;
                                XMLTreeNode child = new XMLTreeNode(next);
                                TreeModel model = XMLTreePanel.this.tree.getModel();
                                if (!(model instanceof DefaultTreeModel)) break block0;
                                DefaultTreeModel treeModel = (DefaultTreeModel)model;
                                treeModel.removeNodeFromParent(node);
                                treeModel.insertNodeInto(child, parentNode, i);
                                TreePath path = new TreePath(child.getPath());
                                XMLTreePanel.this.tree.setSelectionPath(path);
                                break block0;
                            }
                        }
                    }
                }
            });
            Container cont = this.getTopLevelAncestor();
            Point p = cont.getLocationOnScreen();
            ((Component)inspector).setLocation(p.x + 30, p.y + 30);
            ((Component)inspector).setVisible(true);
        }
    }

    private class XMLRenderer
    extends DefaultTreeCellRenderer {
        private XMLRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            XMLTreeNode node = (XMLTreeNode)value;
            if (node.isLeaf()) {
                if (node.isInspectable()) {
                    this.setIcon(XMLTreePanel.this.inspectIcon);
                } else {
                    this.setIcon(XMLTreePanel.this.valueIcon);
                }
            } else if (node.isInspectable()) {
                this.setIcon(XMLTreePanel.this.inspectFolderIcon);
            } else {
                this.setIcon(XMLTreePanel.this.folderIcon);
            }
            return this;
        }
    }
}

