/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.Trail;
import org.opensourcephysics.display2d.ComplexColorMapper;

public class ComplexDataset
extends AbstractTableModel
implements Drawable,
Measurable {
    static final double PI2 = Math.PI * 2;
    public static final int AMP_CURVE = 0;
    public static final int RE_IM_CURVE = 1;
    public static final int PHASE_CURVE = 2;
    public static final int PHASE_BAR = 3;
    public static final int PHASE_POST = 4;
    protected double[] xpoints;
    protected double[] re_points;
    protected double[] im_points;
    protected double[] amp_points;
    protected int index;
    private int markerShape = 2;
    private int markerSize = 5;
    private boolean centered = true;
    private boolean showPhase = true;
    private double xmin;
    private double xmax;
    private double ampmin;
    private double ampmax;
    private double remax;
    private double remin;
    private double immax;
    private double immin;
    private boolean sorted = false;
    private boolean connected = true;
    private int initialSize;
    private Color lineColor = Color.black;
    private GeneralPath ampPath;
    private Trail reTrail = new Trail();
    private Trail imTrail = new Trail();
    private String xColumnName;
    private String reColumnName;
    private String imColumnName;
    private int stride = 1;
    private AffineTransform flip;
    private ComplexColorMapper colorMap = new ComplexColorMapper(1.0);
    static /* synthetic */ Class class$java$lang$Double;

    public ComplexDataset() {
        this.reTrail.color = Color.RED;
        this.imTrail.color = Color.BLUE;
        this.initialSize = 10;
        this.xColumnName = "x";
        this.reColumnName = "re";
        this.imColumnName = "im";
        this.ampPath = new GeneralPath();
        this.index = 0;
        this.flip = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        this.clear();
    }

    public JFrame showLegend() {
        return this.colorMap.showLegend();
    }

    public boolean isMeasured() {
        return this.index >= 1;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        if (this.markerShape == 1) {
            return -this.ampmax;
        }
        if (this.centered && (this.markerShape == 3 || this.markerShape == 2)) {
            return -this.ampmax / 2.0;
        }
        return 0.0;
    }

    public double getYMax() {
        if (this.markerShape == 1) {
            return this.ampmax;
        }
        if (this.centered && (this.markerShape == 3 || this.markerShape == 2)) {
            return this.ampmax / 2.0;
        }
        if (this.markerShape == 4) {
            return 1.1 * this.ampmax;
        }
        return this.ampmax;
    }

    public double[] getXPoints() {
        double[] temp = new double[this.index];
        System.arraycopy(this.xpoints, 0, temp, 0, this.index);
        return temp;
    }

    public double[] getYPoints() {
        double[] temp = new double[this.index];
        System.arraycopy(this.amp_points, 0, temp, 0, this.index);
        return temp;
    }

    public double[][] getPoints() {
        double[][] temp = new double[this.index][3];
        for (int i = 0; i < this.index; ++i) {
            temp[i] = new double[]{this.xpoints[i], this.re_points[i], this.im_points[i]};
        }
        return temp;
    }

    public void setMarkerShape(int _markerShape) {
        this.markerShape = _markerShape;
    }

    public int getMarkerShape() {
        return this.markerShape;
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public void setMarkerSize(int size) {
        this.markerSize = size;
    }

    public void setSorted(boolean _sorted) {
        this.sorted = _sorted;
        if (this.sorted) {
            this.insertionSort();
        }
    }

    public void setStride(int _stride) {
        this.stride = _stride;
        this.stride = Math.max(1, this.stride);
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setConnected(boolean _connected) {
        this.connected = _connected;
    }

    public void setCentered(boolean _centered) {
        this.centered = _centered;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setLineColor(Color _lineColor) {
        this.reTrail.color = this.lineColor = _lineColor;
        this.imTrail.color = this.lineColor;
    }

    public void setLineColor(Color reColor, Color imColor) {
        this.lineColor = reColor;
        this.reTrail.color = reColor;
        this.imTrail.color = imColor;
    }

    public void setXYColumnNames(String _xColumnName, String _reColumnName, String _imColumnName) {
        this.xColumnName = _xColumnName;
        this.reColumnName = _reColumnName;
        this.imColumnName = _imColumnName;
    }

    public void append(double x, double re, double im) {
        if (Double.isNaN(x) || Double.isInfinite(x) || Double.isNaN(re) || Double.isInfinite(re) || Double.isNaN(im) || Double.isInfinite(im)) {
            return;
        }
        if (this.index >= this.xpoints.length) {
            this.setCapacity(this.xpoints.length * 2);
        }
        this.xpoints[this.index] = x;
        this.re_points[this.index] = re;
        this.im_points[this.index] = im;
        double amp = Math.sqrt(re * re + im * im);
        if (this.index == 0) {
            this.ampPath.moveTo((float)x, (float)amp);
        } else {
            this.ampPath.lineTo((float)x, (float)amp);
        }
        this.reTrail.addPoint(x, re);
        this.imTrail.addPoint(x, im);
        this.xmax = Math.max(x, this.xmax);
        this.xmin = Math.min(x, this.xmin);
        this.remin = Math.min(re, this.remin);
        this.remax = Math.max(re, this.remax);
        this.immin = Math.min(im, this.immin);
        this.immax = Math.max(im, this.immax);
        this.ampmin = Math.min(amp, this.ampmin);
        this.ampmax = Math.max(amp, this.ampmax);
        ++this.index;
        if (this.sorted && this.index > 1 && x < this.xpoints[this.index - 2]) {
            this.moveDatum(this.index - 1);
            this.recalculatePath();
        }
    }

    public void append(double[] _xpoints, double[] _repoints, double[] _impoints) {
        if (_xpoints == null) {
            return;
        }
        if (_repoints == null || _impoints == null || _xpoints.length != _repoints.length || _xpoints.length != _impoints.length) {
            throw new IllegalArgumentException("Array lenghts must be equal to append data.");
        }
        boolean badData = false;
        for (int i = 0; i < _xpoints.length; ++i) {
            if (Double.isNaN(_xpoints[i]) || Double.isInfinite(_xpoints[i]) || Double.isNaN(_repoints[i]) || Double.isInfinite(_repoints[i]) || Double.isNaN(_impoints[i]) || Double.isInfinite(_impoints[i])) {
                badData = true;
                continue;
            }
            this.xmax = Math.max(_xpoints[i], this.xmax);
            this.xmin = Math.min(_xpoints[i], this.xmin);
            this.remin = Math.min(_repoints[i], this.remin);
            this.remax = Math.max(_repoints[i], this.remax);
            this.immin = Math.min(_impoints[i], this.immin);
            this.immax = Math.max(_impoints[i], this.immax);
            double amp = Math.sqrt(_repoints[i] * _repoints[i] + _impoints[i] * _impoints[i]);
            this.ampmin = Math.min(amp, this.ampmin);
            this.ampmax = Math.max(amp, this.ampmax);
            if (this.index == 0 && i == 0) {
                this.ampPath.moveTo((float)_xpoints[i], (float)amp);
            } else {
                this.ampPath.lineTo((float)_xpoints[i], (float)amp);
            }
            this.reTrail.addPoint(_xpoints[i], _repoints[i]);
            this.imTrail.addPoint(_xpoints[i], _impoints[i]);
        }
        int pointsAdded = _xpoints.length;
        int availableSpots = this.xpoints.length - this.index;
        if (pointsAdded > availableSpots) {
            this.setCapacity(this.xpoints.length + pointsAdded);
        }
        System.arraycopy(_xpoints, 0, this.xpoints, this.index, pointsAdded);
        System.arraycopy(_repoints, 0, this.re_points, this.index, pointsAdded);
        System.arraycopy(_impoints, 0, this.im_points, this.index, pointsAdded);
        this.index += pointsAdded;
        if (badData) {
            this.cleanBadData();
        }
        if (this.sorted) {
            this.insertionSort();
        }
    }

    public void append(double[] _xpoints, double[] _zpoints) {
        if (_xpoints == null) {
            return;
        }
        if (_zpoints == null || 2 * _xpoints.length != _zpoints.length) {
            throw new IllegalArgumentException("Length of z array must be twice the length of the x array.");
        }
        boolean badData = false;
        int pointsAdded = _xpoints.length;
        int availableSpots = this.xpoints.length - this.index;
        if (pointsAdded > availableSpots) {
            this.setCapacity(this.xpoints.length + pointsAdded);
        }
        for (int i = 0; i < _xpoints.length; ++i) {
            if (Double.isNaN(_xpoints[i]) || Double.isInfinite(_xpoints[i]) || Double.isNaN(_zpoints[2 * i]) || Double.isInfinite(_zpoints[2 * i]) || Double.isNaN(_zpoints[2 * i + 1]) || Double.isInfinite(_zpoints[2 * i + 1])) {
                badData = true;
                continue;
            }
            this.xmax = Math.max(_xpoints[i], this.xmax);
            this.xmin = Math.min(_xpoints[i], this.xmin);
            this.remin = Math.min(_zpoints[2 * i], this.remin);
            this.remax = Math.max(_zpoints[2 * i], this.remax);
            this.immin = Math.min(_zpoints[2 * i + 1], this.immin);
            this.immax = Math.max(_zpoints[2 * i + 1], this.immax);
            double amp = Math.sqrt(_zpoints[2 * i] * _zpoints[2 * i] + _zpoints[2 * i + 1] * _zpoints[2 * i + 1]);
            this.ampmin = Math.min(amp, this.ampmin);
            this.ampmax = Math.max(amp, this.ampmax);
            this.xpoints[this.index + i] = _xpoints[i];
            this.re_points[this.index + i] = _zpoints[2 * i];
            this.im_points[this.index + i] = _zpoints[2 * i + 1];
            if (this.index == 0 && i == 0) {
                this.ampPath.moveTo((float)_xpoints[i], (float)amp);
            } else {
                this.ampPath.lineTo((float)_xpoints[i], (float)amp);
            }
            this.reTrail.addPoint(_xpoints[i], _zpoints[2 * i]);
            this.imTrail.addPoint(_xpoints[i], _zpoints[2 * i + 1]);
        }
        this.index += pointsAdded;
        if (badData) {
            this.cleanBadData();
        }
        if (this.sorted) {
            this.insertionSort();
        }
    }

    private void cleanBadData() {
        for (int i = 0; i < this.index; ++i) {
            if (!Double.isNaN(this.xpoints[i]) && !Double.isInfinite(this.xpoints[i]) && !Double.isNaN(this.re_points[i]) && !Double.isInfinite(this.re_points[i]) && !Double.isNaN(this.im_points[i]) && !Double.isInfinite(this.im_points[i])) continue;
            if (this.index == 1 || i == this.index - 1) {
                --this.index;
                break;
            }
            System.arraycopy(this.xpoints, i + 1, this.xpoints, i, this.index - i - 1);
            System.arraycopy(this.re_points, i + 1, this.re_points, i, this.index - i - 1);
            System.arraycopy(this.im_points, i + 1, this.im_points, i, this.index - i - 1);
            --this.index;
        }
    }

    private void setCapacity(int newCapacity) {
        double[] tempx = this.xpoints;
        this.xpoints = new double[newCapacity];
        System.arraycopy(tempx, 0, this.xpoints, 0, tempx.length);
        double[] tempre = this.re_points;
        this.re_points = new double[newCapacity];
        System.arraycopy(tempre, 0, this.re_points, 0, tempre.length);
        double[] tempim = this.im_points;
        this.im_points = new double[newCapacity];
        System.arraycopy(tempim, 0, this.im_points, 0, tempim.length);
        double[] tempamp = this.amp_points;
        this.amp_points = new double[newCapacity];
        System.arraycopy(tempamp, 0, this.amp_points, 0, tempamp.length);
    }

    public void draw(DrawingPanel drawingPanel, Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        switch (this.markerShape) {
            case 0: {
                this.drawLinePlot(drawingPanel, g2);
                break;
            }
            case 1: {
                this.drawReImPlot(drawingPanel, g2);
                break;
            }
            case 2: {
                this.drawPhaseCurve(drawingPanel, g2);
                break;
            }
            case 3: {
                this.drawPhaseBars(drawingPanel, g2);
                break;
            }
            case 4: {
                this.drawPhasePosts(drawingPanel, g2);
            }
        }
    }

    public void clear() {
        this.index = 0;
        this.xpoints = new double[this.initialSize];
        this.re_points = new double[this.initialSize];
        this.im_points = new double[this.initialSize];
        this.amp_points = new double[this.initialSize];
        this.ampPath.reset();
        this.reTrail.clear();
        this.imTrail.clear();
        this.resetXYMinMax();
    }

    public String toString() {
        if (this.index == 0) {
            return "Dataset empty.";
        }
        String s = this.xpoints[0] + "\t" + this.re_points[0] + "\t" + this.im_points[0] + "\n";
        StringBuffer b = new StringBuffer(this.index * s.length());
        for (int i = 0; i < this.index; ++i) {
            b.append(this.xpoints[i]);
            b.append('\t');
            b.append(this.re_points[i]);
            b.append('\t');
            b.append(this.im_points[i]);
            b.append('\n');
        }
        return b.toString();
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        return (this.index + this.stride - 1) / this.stride;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.xColumnName;
            }
            case 1: {
                return this.reColumnName;
            }
            case 2: {
                return this.imColumnName;
            }
        }
        return "";
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        rowIndex *= this.stride;
        switch (columnIndex) {
            case 0: {
                return new Double(this.xpoints[rowIndex]);
            }
            case 1: {
                return new Double(this.re_points[rowIndex]);
            }
            case 2: {
                return new Double(this.im_points[rowIndex]);
            }
        }
        return new Double(0.0);
    }

    public Class getColumnClass(int columnIndex) {
        return class$java$lang$Double == null ? (class$java$lang$Double = ComplexDataset.class$("java.lang.Double")) : class$java$lang$Double;
    }

    private void resetXYMinMax() {
        this.xmin = Double.MAX_VALUE;
        this.xmax = -1.7976931348623157E308;
        this.remax = -1.7976931348623157E308;
        this.remin = Double.MAX_VALUE;
        this.immax = -1.7976931348623157E308;
        this.immin = Double.MAX_VALUE;
        this.ampmax = -1.7976931348623157E308;
        this.ampmin = Double.MAX_VALUE;
        for (int i = 0; i < this.index; ++i) {
            this.xmin = Math.min(this.xpoints[i], this.xmin);
            this.xmax = Math.max(this.xpoints[i], this.xmax);
            this.remax = Math.max(this.re_points[i], this.remax);
            this.remin = Math.min(this.re_points[i], this.remin);
            this.immax = Math.max(this.im_points[i], this.immax);
            this.immin = Math.min(this.im_points[i], this.immin);
            this.ampmax = Math.max(this.amp_points[i], this.ampmax);
            this.ampmin = Math.min(this.amp_points[i], this.ampmin);
        }
    }

    protected void insertionSort() {
        boolean dataChanged = false;
        if (this.index < 2) {
            return;
        }
        for (int i = 1; i < this.index; ++i) {
            if (!(this.xpoints[i] < this.xpoints[i - 1])) continue;
            dataChanged = true;
            this.moveDatum(i);
        }
        if (dataChanged) {
            this.recalculatePath();
        }
    }

    protected void recalculatePath() {
        this.ampPath.reset();
        if (this.index < 1) {
            return;
        }
        float amp = (float)Math.sqrt(this.re_points[0] * this.re_points[0] + this.im_points[0] * this.im_points[0]);
        this.ampPath.moveTo((float)this.xpoints[0], amp);
        for (int i = 1; i < this.index; ++i) {
            amp = (float)Math.sqrt(this.re_points[i] * this.re_points[i] + this.im_points[i] * this.im_points[i]);
            this.ampPath.lineTo((float)this.xpoints[i], amp);
        }
    }

    protected void moveDatum(int loc) {
        if (loc < 1) {
            return;
        }
        double x = this.xpoints[loc];
        double re = this.re_points[loc];
        double im = this.im_points[loc];
        for (int i = 0; i < this.index; ++i) {
            if (!(this.xpoints[i] > x)) continue;
            System.arraycopy(this.xpoints, i, this.xpoints, i + 1, loc - i);
            this.xpoints[i] = x;
            System.arraycopy(this.re_points, i, this.re_points, i + 1, loc - i);
            this.re_points[i] = re;
            System.arraycopy(this.im_points, i, this.im_points, i + 1, loc - i);
            this.im_points[i] = im;
            return;
        }
    }

    protected void drawLinePlot(DrawingPanel drawingPanel, Graphics2D g2) {
        AffineTransform at = (AffineTransform)drawingPanel.getPixelTransform().clone();
        Shape s = this.ampPath.createTransformedShape(at);
        g2.setColor(this.lineColor);
        g2.draw(s);
        if (this.showPhase) {
            at.concatenate(this.flip);
            s = this.ampPath.createTransformedShape(at);
            g2.draw(s);
        }
    }

    protected void drawReImPlot(DrawingPanel drawingPanel, Graphics2D g2) {
        this.reTrail.draw(drawingPanel, g2);
        this.imTrail.draw(drawingPanel, g2);
    }

    protected void drawPhaseCurve(DrawingPanel drawingPanel, Graphics2D g2) {
        double[] xpoints = this.xpoints;
        double[] re_points = this.re_points;
        double[] im_points = this.im_points;
        int index = this.index;
        if (index < 1) {
            return;
        }
        if (xpoints.length < index || xpoints.length != re_points.length || xpoints.length != im_points.length) {
            return;
        }
        int yorigin = drawingPanel.yToPix(0.0);
        int[] xpix = new int[4];
        int[] ypix = new int[4];
        xpix[2] = drawingPanel.xToPix(xpoints[0]);
        double oldY = Math.sqrt(re_points[0] * re_points[0] + im_points[0] * im_points[0]);
        ypix[3] = drawingPanel.yToPix(-oldY);
        ypix[2] = drawingPanel.yToPix(oldY);
        double oldRe = re_points[0];
        double oldIm = im_points[0];
        for (int i = 0; i < index; ++i) {
            double re = re_points[i];
            double im = im_points[i];
            double y = Math.sqrt(re * re + im * im);
            if (y > 0.0) {
                g2.setColor(this.colorMap.complexToColor((oldRe + re) / 2.0, (im + oldIm) / 2.0));
            }
            xpix[0] = drawingPanel.xToPix(xpoints[i]);
            if (this.centered) {
                ypix[0] = drawingPanel.yToPix(-y / 2.0);
                ypix[1] = drawingPanel.yToPix(y / 2.0);
            } else {
                ypix[0] = yorigin;
                ypix[1] = drawingPanel.yToPix(y);
            }
            xpix[1] = xpix[0];
            xpix[3] = xpix[2];
            g2.fillPolygon(xpix, ypix, 4);
            xpix[2] = xpix[0];
            ypix[3] = ypix[0];
            ypix[2] = ypix[1];
            oldIm = im;
            oldRe = re;
            oldY = y;
        }
    }

    protected void drawPhaseBars(DrawingPanel drawingPanel, Graphics2D g2) {
        if (this.index < 1) {
            return;
        }
        double[] xpoints = this.xpoints;
        double[] re_points = this.re_points;
        double[] im_points = this.im_points;
        if (xpoints.length < this.index || xpoints.length != re_points.length || xpoints.length != im_points.length) {
            return;
        }
        int barWidth = (int)(0.5 + (double)(drawingPanel.xToPix(this.xmax) - drawingPanel.xToPix(this.xmin)) / (2.0 * (double)(this.index - 1)));
        barWidth = Math.min(this.markerSize, barWidth);
        int yorigin = drawingPanel.yToPix(0.0);
        for (int i = 0; i < this.index; ++i) {
            double re = re_points[i];
            double im = im_points[i];
            double y = Math.sqrt(re * re + im * im);
            g2.setColor(this.colorMap.complexToColor(re, im));
            int xpix = drawingPanel.xToPix(xpoints[i]);
            int height = Math.abs(yorigin - drawingPanel.yToPix(y));
            if (this.centered) {
                g2.fillRect(xpix - barWidth, yorigin - height / 2, 2 * barWidth + 1, height);
                continue;
            }
            g2.fillRect(xpix - barWidth, yorigin - height, 2 * barWidth + 1, height);
        }
    }

    protected void drawPhasePosts(DrawingPanel drawingPanel, Graphics2D g2) {
        if (this.index < 1) {
            return;
        }
        double[] xpoints = this.xpoints;
        double[] re_points = this.re_points;
        double[] im_points = this.im_points;
        if (xpoints.length < this.index || xpoints.length != re_points.length || xpoints.length != im_points.length) {
            return;
        }
        int postWidth = (int)(0.5 + (double)(drawingPanel.xToPix(this.xmax) - drawingPanel.xToPix(this.xmin)) / (2.0 * (double)(this.index - 1)));
        postWidth = Math.min(this.markerSize, postWidth);
        for (int i = 0; i < this.index; ++i) {
            double re = re_points[i];
            double im = im_points[i];
            double y = Math.sqrt(re * re + im * im);
            this.drawPost(drawingPanel, g2, xpoints[i], y, postWidth, this.colorMap.complexToColor(re, im));
        }
    }

    private void drawPost(DrawingPanel drawingPanel, Graphics2D g2, double x, double y, int postWidth, Color fillColor) {
        Color edgeColor = Color.BLACK;
        int xp = drawingPanel.xToPix(x);
        int yp = drawingPanel.yToPix(y);
        int size = postWidth * 2 + 1;
        int bottom = Math.min(drawingPanel.yToPix(0.0), drawingPanel.yToPix(drawingPanel.getYMin()));
        Rectangle2D.Double shape = new Rectangle2D.Double(xp - postWidth, yp - postWidth, size, size);
        g2.setColor(edgeColor);
        g2.drawLine(xp, yp, xp, bottom);
        g2.setColor(fillColor);
        g2.fill(shape);
        g2.setColor(edgeColor);
        g2.draw(shape);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            ComplexDataset data = (ComplexDataset)obj;
            control.setValue("points", data.getPoints());
            control.setValue("marker_shape", data.getMarkerShape());
            control.setValue("marker_size", data.getMarkerSize());
            control.setValue("sorted", data.isSorted());
            control.setValue("connected", data.isConnected());
            control.setValue("x_name", data.xColumnName);
            control.setValue("re_name", data.reColumnName);
            control.setValue("im_name", data.imColumnName);
            control.setValue("line_color", data.lineColor);
        }

        public Object createObject(XMLControl control) {
            return new ComplexDataset();
        }

        public Object loadObject(XMLControl control, Object obj) {
            ComplexDataset data = (ComplexDataset)obj;
            double[][] points = (double[][])control.getObject("points");
            if (points != null && points[0] != null) {
                data.clear();
                for (int i = 0; i < points.length; ++i) {
                    data.append(points[i][0], points[i][1], points[i][2]);
                }
            }
            double[] xPoints = (double[])control.getObject("x_points");
            double[] yPoints = (double[])control.getObject("y_points");
            if (xPoints != null && yPoints != null) {
                data.clear();
                data.append(xPoints, yPoints);
            }
            if (control.getPropertyNames().contains("marker_shape")) {
                data.setMarkerShape(control.getInt("marker_shape"));
            }
            if (control.getPropertyNames().contains("marker_size")) {
                data.setMarkerSize(control.getInt("marker_size"));
            }
            data.setSorted(control.getBoolean("sorted"));
            data.setConnected(control.getBoolean("connected"));
            data.xColumnName = control.getString("x_name");
            data.reColumnName = control.getString("re_name");
            data.imColumnName = control.getString("im_name");
            Color color = (Color)control.getObject("line_color");
            if (color != null) {
                data.lineColor = color;
            }
            return obj;
        }
    }
}

