/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.Measurable;

public class Dataset
extends AbstractTableModel
implements Measurable {
    protected int datasetID = this.hashCode();
    public static final int NO_MARKER = 0;
    public static final int CIRCLE = 1;
    public static final int SQUARE = 2;
    public static final int AREA = 5;
    public static final int PIXEL = 6;
    public static final int BAR = 7;
    public static final int POST = 8;
    public static final int CUSTOM = -1;
    protected double[] xpoints;
    protected double[] ypoints;
    protected GeneralPath generalPath;
    protected double xmax;
    protected double ymax;
    protected double xmin;
    protected double ymin;
    protected int index;
    protected boolean sorted = false;
    private int initialSize;
    private int markerSize = 2;
    private int markerShape = 2;
    private Color lineColor;
    private Color fillColor;
    private Color edgeColor;
    private Color errorBarColor;
    private boolean connected;
    private String name = null;
    private String xColumnName;
    private String yColumnName;
    private boolean[] visible = new boolean[2];
    private int stride = 1;
    protected int maxPoints = 16384;
    protected ArrayList errorBars = new ArrayList();
    protected Shape customMarker = new Rectangle2D.Double(-this.markerSize / 2, -this.markerSize / 2, this.markerSize, this.markerSize);
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$opensourcephysics$display$Dataset;

    public Dataset() {
        this(Color.black, Color.black, false);
    }

    public Dataset(Color _markerColor) {
        this(_markerColor, Color.black, false);
    }

    public Dataset(Color markerColor, Color _lineColor, boolean _connected) {
        this.fillColor = markerColor;
        this.edgeColor = markerColor;
        this.errorBarColor = markerColor;
        this.lineColor = _lineColor;
        this.connected = _connected;
        this.markerSize = 2;
        this.initialSize = 10;
        this.xColumnName = "x";
        this.yColumnName = "y";
        this.generalPath = new GeneralPath();
        this.index = 0;
        Arrays.fill(this.visible, true);
        this.clear();
    }

    public void setID(int id) {
        this.datasetID = id;
    }

    public int getID() {
        return this.datasetID;
    }

    public void setSorted(boolean _sorted) {
        this.sorted = _sorted;
        if (this.sorted) {
            this.insertionSort();
        }
    }

    public void setConnected(boolean _connected) {
        this.connected = _connected;
        if (this.connected) {
            this.recalculatePath();
        }
    }

    public void setMarkerColor(Color markerColor) {
        this.fillColor = markerColor;
        this.edgeColor = markerColor;
        this.errorBarColor = markerColor;
    }

    public void setMarkerColor(Color _fillColor, Color _edgeColor) {
        this.fillColor = _fillColor;
        this.edgeColor = _edgeColor;
        this.errorBarColor = _edgeColor;
    }

    public void setMarkerColor(Color _fillColor, Color _edgeColor, Color _errorBarColor) {
        this.fillColor = _fillColor;
        this.edgeColor = _edgeColor;
        this.errorBarColor = _errorBarColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setCustomMarker(Shape marker) {
        this.customMarker = marker;
        if (this.customMarker == null) {
            this.markerShape = 2;
            this.customMarker = new Rectangle2D.Double(-this.markerSize / 2, -this.markerSize / 2, this.markerSize, this.markerSize);
        } else {
            this.markerShape = -1;
        }
    }

    public void setMarkerShape(int _markerShape) {
        this.markerShape = _markerShape;
    }

    public int getMarkerShape() {
        return this.markerShape;
    }

    public void setMarkerSize(int _markerSize) {
        this.markerSize = _markerSize;
    }

    public void setMaximumPoints(int maxPoints) {
        this.maxPoints = maxPoints;
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public void setLineColor(Color _lineColor) {
        this.lineColor = _lineColor;
    }

    public void setXYColumnNames(String _xColumnName, String _yColumnName) {
        this.xColumnName = GUIUtils.parseTeX(_xColumnName);
        this.yColumnName = GUIUtils.parseTeX(_yColumnName);
    }

    public void setXYColumnNames(String xColumnName, String yColumnName, String name) {
        this.setXYColumnNames(xColumnName, yColumnName);
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMeasured() {
        return this.ymin < Double.MAX_VALUE;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getYMax() {
        return this.ymax;
    }

    public double[][] getPoints() {
        double[][] temp = new double[this.index][2];
        for (int i = 0; i < this.index; ++i) {
            temp[i] = new double[]{this.xpoints[i], this.ypoints[i]};
        }
        return temp;
    }

    public double[] getXPoints() {
        double[] temp = new double[this.index];
        System.arraycopy(this.xpoints, 0, temp, 0, this.index);
        return temp;
    }

    public double[] getYPoints() {
        double[] temp = new double[this.index];
        System.arraycopy(this.ypoints, 0, temp, 0, this.index);
        return temp;
    }

    public double[] getValidXPoints() {
        return this.getValidPoints(this.getXPoints());
    }

    public double[] getValidYPoints() {
        return this.getValidPoints(this.getYPoints());
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getColumnCount() {
        return Dataset.countColumnsVisible(this.visible);
    }

    public int getIndex() {
        return this.index;
    }

    public int getRowCount() {
        return (this.index + this.stride - 1) / this.stride;
    }

    public String getColumnName(int columnIndex) {
        if ((columnIndex = Dataset.convertTableColumnIndex(this.visible, columnIndex)) == 0) {
            return this.xColumnName;
        }
        return this.yColumnName;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        columnIndex = Dataset.convertTableColumnIndex(this.visible, columnIndex);
        rowIndex *= this.stride;
        if (columnIndex == 0) {
            return new Double(this.xpoints[rowIndex]);
        }
        if (Double.isNaN(this.ypoints[rowIndex])) {
            return null;
        }
        return new Double(this.ypoints[rowIndex]);
    }

    public Class getColumnClass(int columnIndex) {
        return class$java$lang$Double == null ? (class$java$lang$Double = Dataset.class$("java.lang.Double")) : class$java$lang$Double;
    }

    public void append(double x, double y, double delx, double dely) {
        this.errorBars.add(new ErrorBar(x, y, delx, dely));
        this.append(x, y);
    }

    public void append(double x, double y) {
        if (Double.isNaN(x) || Double.isInfinite(x) || Double.isInfinite(y)) {
            return;
        }
        if (this.index >= this.xpoints.length) {
            this.increaseCapacity(this.xpoints.length * 2);
        }
        this.xpoints[this.index] = x;
        this.ypoints[this.index] = y;
        if (!Double.isNaN(y)) {
            Point2D curPt = this.generalPath.getCurrentPoint();
            if (curPt == null) {
                this.generalPath.moveTo((float)x, (float)y);
            } else {
                this.generalPath.lineTo((float)x, (float)y);
            }
            this.ymax = Math.max(y, this.ymax);
            this.ymin = Math.min(y, this.ymin);
        }
        this.xmax = Math.max(x, this.xmax);
        this.xmin = Math.min(x, this.xmin);
        ++this.index;
        if (this.sorted && this.index > 1 && x < this.xpoints[this.index - 2]) {
            this.moveDatum(this.index - 1);
            this.recalculatePath();
        }
    }

    public void append(double[] xpoints, double[] ypoints, double[] delx, double[] dely) {
        int n = xpoints.length;
        for (int i = 0; i < n; ++i) {
            this.errorBars.add(new ErrorBar(xpoints[i], ypoints[i], delx[i], dely[i]));
        }
        this.append(xpoints, ypoints);
    }

    public void append(double[] _xpoints, double[] _ypoints) {
        boolean badData = false;
        for (int i = 0; i < _xpoints.length; ++i) {
            if (Double.isNaN(_xpoints[i]) || Double.isInfinite(_xpoints[i]) || Double.isInfinite(_ypoints[i])) {
                badData = true;
                continue;
            }
            this.xmax = Math.max(_xpoints[i], this.xmax);
            this.xmin = Math.min(_xpoints[i], this.xmin);
            if (Double.isNaN(_ypoints[i])) continue;
            this.ymax = Math.max(_ypoints[i], this.ymax);
            this.ymin = Math.min(_ypoints[i], this.ymin);
            Point2D curPt = this.generalPath.getCurrentPoint();
            if (curPt == null) {
                this.generalPath.moveTo((float)_xpoints[i], (float)_ypoints[i]);
                continue;
            }
            this.generalPath.lineTo((float)_xpoints[i], (float)_ypoints[i]);
        }
        int pointsAdded = _xpoints.length;
        int availableSpots = this.xpoints.length - this.index;
        if (pointsAdded > availableSpots) {
            this.increaseCapacity(this.xpoints.length + pointsAdded);
        }
        System.arraycopy(_xpoints, 0, this.xpoints, this.index, pointsAdded);
        System.arraycopy(_ypoints, 0, this.ypoints, this.index, pointsAdded);
        this.index += pointsAdded;
        if (badData) {
            this.removeBadData();
        }
        if (this.sorted) {
            this.insertionSort();
        }
    }

    public void read(String inputFile) {
        try {
            String s;
            BufferedReader reader = new BufferedReader(new FileReader(inputFile));
            block8: while ((s = reader.readLine()) != null) {
                if ((s = s.trim()).charAt(0) == '#') continue;
                StringTokenizer st = new StringTokenizer(s, "\t");
                switch (st.countTokens()) {
                    case 0: {
                        continue block8;
                    }
                    case 2: {
                        this.append(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
                        continue block8;
                    }
                }
                throw new IOException();
            }
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("File " + inputFile + " not found.");
        }
        catch (IOException ioe) {
            System.err.println("Error reading file " + inputFile);
        }
        catch (NumberFormatException nfe) {
            System.err.println("Error reading file " + inputFile);
        }
    }

    public void write(String outputFile) {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            for (int i = 0; i < this.index; ++i) {
                writer.println(this.xpoints[i] + "\t" + this.ypoints[i]);
            }
            writer.close();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("File " + outputFile + " not found.");
        }
        catch (IOException ioe) {
            System.err.println("Error writing file " + outputFile);
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics g) {
        try {
            Graphics2D g2 = (Graphics2D)g;
            if (this.markerShape != 0) {
                this.drawScatterPlot(drawingPanel, g2);
            }
            if (this.connected) {
                this.drawLinePlot(drawingPanel, g2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clear() {
        this.index = 0;
        this.xpoints = new double[this.initialSize];
        this.ypoints = new double[this.initialSize];
        this.generalPath.reset();
        this.errorBars.clear();
        this.resetXYMinMax();
    }

    public String toString() {
        if (this.index == 0) {
            return "No data in dataset.";
        }
        String s = this.xpoints[0] + " " + this.ypoints[0] + "\n";
        StringBuffer b = new StringBuffer(this.index * s.length());
        for (int i = 0; i < this.index; ++i) {
            b.append(this.xpoints[i]);
            String eol = "\n";
            try {
                eol = System.getProperty("line.separator", "\n");
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            b.append(" ");
            if (Double.isNaN(this.ypoints[i])) {
                b.append("null");
            } else {
                b.append(this.ypoints[i]);
            }
            b.append(eol);
        }
        return b.toString();
    }

    public static int countColumnsVisible(boolean[] visible) {
        int count = 0;
        for (int i = 0; i < visible.length; ++i) {
            if (!visible[i]) continue;
            ++count;
        }
        return count;
    }

    public static int convertTableColumnIndex(boolean[] visible, int columnIndex) {
        if (columnIndex == 0 && !visible[0]) {
            ++columnIndex;
        } else if (columnIndex == 1 && !visible[1]) {
            --columnIndex;
        }
        return columnIndex;
    }

    public void setXColumnVisible(boolean b) {
        this.visible[0] = b;
    }

    public void setYColumnVisible(boolean b) {
        this.visible[1] = b;
    }

    public void setStride(int _stride) {
        this.stride = _stride;
    }

    public boolean isXColumnVisible() {
        return this.visible[0];
    }

    public boolean isYColumnVisible() {
        return this.visible[1];
    }

    protected void insertionSort() {
        boolean dataChanged = false;
        if (this.index < 2) {
            return;
        }
        for (int i = 1; i < this.index; ++i) {
            if (!(this.xpoints[i] < this.xpoints[i - 1])) continue;
            dataChanged = true;
            this.moveDatum(i);
        }
        if (dataChanged) {
            this.recalculatePath();
        }
    }

    protected void recalculatePath() {
        this.generalPath.reset();
        if (this.index < 1) {
            return;
        }
        for (int i = 0; i < this.index; ++i) {
            if (Double.isNaN(this.ypoints[i])) continue;
            this.generalPath.moveTo((float)this.xpoints[i], (float)this.ypoints[i]);
            break;
        }
        for (int j = i + 1; j < this.index; ++j) {
            if (Double.isNaN(this.ypoints[j])) continue;
            this.generalPath.lineTo((float)this.xpoints[j], (float)this.ypoints[j]);
        }
    }

    protected void moveDatum(int loc) {
        if (loc < 1) {
            return;
        }
        double x = this.xpoints[loc];
        double y = this.ypoints[loc];
        for (int i = 0; i < this.index; ++i) {
            if (!(this.xpoints[i] > x)) continue;
            System.arraycopy(this.xpoints, i, this.xpoints, i + 1, loc - i);
            this.xpoints[i] = x;
            System.arraycopy(this.ypoints, i, this.ypoints, i + 1, loc - i);
            this.ypoints[i] = y;
            return;
        }
    }

    protected void drawLinePlot(DrawingPanel drawingPanel, Graphics2D g2) {
        boolean noNumbers = true;
        for (int i = 0; i < this.index && (noNumbers = Double.isNaN(this.ypoints[i])); ++i) {
        }
        if (noNumbers) {
            return;
        }
        AffineTransform at = drawingPanel.getPixelTransform();
        Shape s = this.generalPath.createTransformedShape(at);
        g2.setColor(this.lineColor);
        g2.draw(s);
    }

    protected void drawFilledPlot(DrawingPanel drawingPanel, Graphics2D g2) {
        boolean noNumbers = true;
        for (int i = 0; i < this.index && (noNumbers = Double.isNaN(this.ypoints[i])); ++i) {
        }
        if (noNumbers) {
            return;
        }
        AffineTransform at = drawingPanel.getPixelTransform();
        Shape s = this.generalPath.createTransformedShape(at);
        g2.setColor(this.fillColor);
        g2.fill(s);
        g2.setColor(this.edgeColor);
        g2.draw(s);
    }

    protected void drawScatterPlot(DrawingPanel drawingPanel, Graphics2D g2) {
        if (this.markerShape == 5) {
            this.drawFilledPlot(drawingPanel, g2);
            return;
        }
        double xp = 0.0;
        double yp = 0.0;
        RectangularShape shape = null;
        int size = this.markerSize * 2 + 1;
        Shape clipShape = g2.getClip();
        g2.setClip(drawingPanel.leftGutter - this.markerSize - 1, drawingPanel.topGutter - this.markerSize - 1, drawingPanel.getWidth() - drawingPanel.leftGutter - drawingPanel.rightGutter + 2 + 2 * this.markerSize, drawingPanel.getHeight() - drawingPanel.bottomGutter - drawingPanel.topGutter + 2 + 2 * this.markerSize);
        Rectangle viewRect = drawingPanel.getViewRect();
        if (viewRect != null) {
            g2.clipRect(viewRect.x, viewRect.y, viewRect.x + viewRect.width, viewRect.y + viewRect.height);
        }
        block8: for (int i = 0; i < this.index; ++i) {
            if (Double.isNaN(this.ypoints[i])) continue;
            xp = drawingPanel.xToPix(this.xpoints[i]);
            yp = drawingPanel.yToPix(this.ypoints[i]);
            switch (this.markerShape) {
                case 7: {
                    double bottom = Math.min(drawingPanel.yToPix(0.0), drawingPanel.yToPix(drawingPanel.getYMin()));
                    double barHeight = bottom - yp;
                    shape = barHeight > 0.0 ? new Rectangle2D.Double(xp - (double)this.markerSize, yp, size, barHeight) : new Rectangle2D.Double(xp - (double)this.markerSize, bottom, size, -barHeight);
                    g2.setColor(this.fillColor);
                    g2.fill(shape);
                    if (this.edgeColor == this.fillColor) continue block8;
                    g2.setColor(this.edgeColor);
                    g2.draw(shape);
                    continue block8;
                }
                case 8: {
                    double bottom = Math.min(drawingPanel.yToPix(0.0), drawingPanel.yToPix(drawingPanel.getYMin()));
                    shape = new Rectangle2D.Double(xp - (double)this.markerSize, yp - (double)this.markerSize, size, size);
                    g2.setColor(this.edgeColor);
                    g2.drawLine((int)xp, (int)yp, (int)xp, (int)bottom);
                    g2.setColor(this.fillColor);
                    g2.fill(shape);
                    if (this.edgeColor == this.fillColor) continue block8;
                    g2.setColor(this.edgeColor);
                    g2.draw(shape);
                    continue block8;
                }
                case 2: {
                    shape = new Rectangle2D.Double(xp - (double)this.markerSize, yp - (double)this.markerSize, size, size);
                    g2.setColor(this.fillColor);
                    g2.fill(shape);
                    if (this.edgeColor == this.fillColor) continue block8;
                    g2.setColor(this.edgeColor);
                    g2.draw(shape);
                    continue block8;
                }
                case 1: {
                    shape = new Ellipse2D.Double(xp - (double)this.markerSize, yp - (double)this.markerSize, size, size);
                    g2.setColor(this.fillColor);
                    g2.fill(shape);
                    if (this.edgeColor == this.fillColor) continue block8;
                    g2.setColor(this.edgeColor);
                    g2.draw(shape);
                    continue block8;
                }
                case 6: {
                    shape = new Rectangle2D.Double(xp, yp, 0.0, 0.0);
                    g2.draw(shape);
                    continue block8;
                }
                case -1: {
                    Shape temp = AffineTransform.getTranslateInstance(xp, yp).createTransformedShape(this.customMarker);
                    g2.setColor(this.fillColor);
                    g2.fill(temp);
                    if (this.edgeColor == this.fillColor) continue block8;
                    g2.setColor(this.edgeColor);
                    g2.draw(temp);
                    continue block8;
                }
                default: {
                    shape = new Rectangle2D.Double(xp - (double)this.markerSize, yp - (double)this.markerSize, size, size);
                    g2.setColor(this.fillColor);
                    g2.fill(shape);
                    if (this.edgeColor == this.fillColor) continue block8;
                    g2.setColor(this.edgeColor);
                    g2.draw(shape);
                }
            }
        }
        Iterator it = ((AbstractList)this.errorBars).iterator();
        while (it.hasNext()) {
            ((ErrorBar)it.next()).draw(drawingPanel, g2);
        }
        g2.setClip(clipShape);
    }

    private void removeBadData() {
        for (int i = 0; i < this.index; ++i) {
            if (!Double.isNaN(this.xpoints[i]) && !Double.isInfinite(this.xpoints[i]) && !Double.isInfinite(this.ypoints[i])) continue;
            if (this.index == 1 || i == this.index - 1) {
                --this.index;
                break;
            }
            System.arraycopy(this.xpoints, i + 1, this.xpoints, i, this.index - i - 1);
            System.arraycopy(this.ypoints, i + 1, this.ypoints, i, this.index - i - 1);
            --this.index;
        }
    }

    private synchronized void increaseCapacity(int newCapacity) {
        int pointsAdded = newCapacity - this.xpoints.length;
        newCapacity = Math.min(newCapacity, this.maxPoints);
        int newIndex = Math.min(this.index, 3 * newCapacity / 4);
        newIndex = Math.min(newIndex, newCapacity - pointsAdded);
        double[] tempx = this.xpoints;
        this.xpoints = new double[newCapacity];
        System.arraycopy(tempx, this.index - newIndex, this.xpoints, 0, newIndex);
        double[] tempy = this.ypoints;
        this.ypoints = new double[newCapacity];
        System.arraycopy(tempy, this.index - newIndex, this.ypoints, 0, newIndex);
        if (this.index != newIndex) {
            this.index = newIndex;
            this.resetXYMinMax();
            this.recalculatePath();
        }
        this.index = newIndex;
    }

    private void resetXYMinMax() {
        this.xmax = -1.7976931348623157E308;
        this.ymax = -1.7976931348623157E308;
        this.xmin = Double.MAX_VALUE;
        this.ymin = Double.MAX_VALUE;
        for (int i = 0; i < this.index; ++i) {
            if (Double.isNaN(this.xpoints[i]) || Double.isInfinite(this.xpoints[i]) || Double.isInfinite(this.ypoints[i])) continue;
            this.xmax = Math.max(this.xpoints[i], this.xmax);
            this.xmin = Math.min(this.xpoints[i], this.xmin);
            if (Double.isNaN(this.ypoints[i])) continue;
            this.ymax = Math.max(this.ypoints[i], this.ymax);
            this.ymin = Math.min(this.ypoints[i], this.ymin);
        }
    }

    private double[] getValidPoints(double[] pts) {
        int nans = 0;
        for (int i = 0; i < pts.length; ++i) {
            if (nans > 0) {
                pts[i - nans] = pts[i];
            }
            if (!Double.isNaN(this.ypoints[i])) continue;
            ++nans;
        }
        if (nans == 0) {
            return pts;
        }
        double[] temp = new double[this.index - nans];
        System.arraycopy(pts, 0, temp, 0, this.index - nans);
        return temp;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class Loader
    extends XMLLoader {
        protected Loader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            Dataset data = (Dataset)obj;
            control.setValue("points", data.getPoints());
            control.setValue("index", data.index);
            control.setValue("marker_shape", data.getMarkerShape());
            control.setValue("marker_size", data.getMarkerSize());
            control.setValue("sorted", data.isSorted());
            control.setValue("connected", data.isConnected());
            control.setValue("name", data.name);
            control.setValue("x_name", data.xColumnName);
            control.setValue("y_name", data.yColumnName);
            control.setValue("line_color", data.lineColor);
            control.setValue("fill_color", data.fillColor);
            control.setValue("edge_color", data.edgeColor);
            control.setValue("errorbar_color", data.errorBarColor);
            control.setValue("datasetID", data.datasetID);
        }

        public Object createObject(XMLControl control) {
            Class type;
            if ((class$org$opensourcephysics$display$Dataset == null ? (class$org$opensourcephysics$display$Dataset = Dataset.class$("org.opensourcephysics.display.Dataset")) : class$org$opensourcephysics$display$Dataset).isAssignableFrom(type = control.getObjectClass()) && !(class$org$opensourcephysics$display$Dataset == null ? (class$org$opensourcephysics$display$Dataset = Dataset.class$("org.opensourcephysics.display.Dataset")) : class$org$opensourcephysics$display$Dataset).equals(type)) {
                try {
                    return type.newInstance();
                }
                catch (InstantiationException ex) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return new Dataset();
        }

        public Object loadObject(XMLControl control, Object obj) {
            Dataset data = (Dataset)obj;
            double[][] points = (double[][])control.getObject("points");
            if (points != null && points.length > 0 && points[0] != null) {
                data.clear();
                for (int i = 0; i < points.length; ++i) {
                    data.append(points[i][0], points[i][1]);
                }
            }
            double[] xPoints = (double[])control.getObject("x_points");
            double[] yPoints = (double[])control.getObject("y_points");
            if (xPoints != null && yPoints != null) {
                data.clear();
                data.append(xPoints, yPoints);
            }
            data.index = control.getInt("index");
            if (control.getPropertyNames().contains("marker_shape")) {
                data.setMarkerShape(control.getInt("marker_shape"));
            }
            if (control.getPropertyNames().contains("marker_size")) {
                data.setMarkerSize(control.getInt("marker_size"));
            }
            data.setSorted(control.getBoolean("sorted"));
            data.setConnected(control.getBoolean("connected"));
            data.name = control.getString("name");
            data.xColumnName = control.getString("x_name");
            data.yColumnName = control.getString("y_name");
            Color color = (Color)control.getObject("line_color");
            if (color != null) {
                data.lineColor = color;
            }
            if ((color = (Color)control.getObject("fill_color")) != null) {
                data.fillColor = color;
            }
            if ((color = (Color)control.getObject("edge_color")) != null) {
                data.edgeColor = color;
            }
            if ((color = (Color)control.getObject("errorbar_color")) != null) {
                data.errorBarColor = color;
            }
            data.setID(control.getInt("datasetID"));
            return obj;
        }
    }

    class ErrorBar
    implements Drawable {
        double x;
        double y;
        double delx;
        double dely;
        int tick = 3;

        ErrorBar(double _x, double _y, double _delx, double _dely) {
            this.x = _x;
            this.y = _y;
            this.delx = _delx;
            this.dely = _dely;
        }

        public void draw(DrawingPanel panel, Graphics g) {
            if (Double.isNaN(this.y)) {
                return;
            }
            int xpix = panel.xToPix(this.x);
            int xpix1 = panel.xToPix(this.x - this.delx);
            int xpix2 = panel.xToPix(this.x + this.delx);
            int ypix = panel.yToPix(this.y);
            int ypix1 = panel.yToPix(this.y - this.dely);
            int ypix2 = panel.yToPix(this.y + this.dely);
            g.setColor(Dataset.this.errorBarColor);
            g.drawLine(xpix1, ypix, xpix2, ypix);
            g.drawLine(xpix, ypix1, xpix, ypix2);
            g.drawLine(xpix1, ypix - this.tick, xpix1, ypix + this.tick);
            g.drawLine(xpix2, ypix - this.tick, xpix2, ypix + this.tick);
            g.drawLine(xpix - this.tick, ypix1, xpix + this.tick, ypix1);
            g.drawLine(xpix - this.tick, ypix2, xpix + this.tick, ypix2);
        }
    }
}

