/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;

public class DrawableBuffer
implements Drawable,
Measurable {
    Image image;
    boolean invalid = true;
    ArrayList drawableList = new ArrayList();
    Color background = Color.white;
    boolean measured = false;
    double xmin;
    double xmax;
    double ymin;
    double ymax;
    boolean visible = true;

    public DrawableBuffer() {
    }

    public DrawableBuffer(Drawable drawable) {
        this.addDrawable(drawable);
    }

    public synchronized void addDrawable(Drawable drawable) {
        if (!this.drawableList.contains(drawable)) {
            this.drawableList.add(drawable);
        }
        this.invalidateImage();
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setVisible(boolean vis) {
        this.visible = vis;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public synchronized void clear() {
        this.drawableList.clear();
        this.invalidateImage();
    }

    public void invalidateImage() {
        this.measured = false;
        ArrayList tempList = (ArrayList)this.drawableList.clone();
        Iterator it = ((AbstractList)tempList).iterator();
        this.xmin = Double.MAX_VALUE;
        this.xmax = -1.7976931348623157E308;
        this.ymin = Double.MAX_VALUE;
        this.ymax = -1.7976931348623157E308;
        while (it.hasNext()) {
            Drawable drawable = (Drawable)it.next();
            if (!(drawable instanceof Measurable) || !((Measurable)drawable).isMeasured()) continue;
            this.xmin = Math.min(this.xmin, ((Measurable)drawable).getXMin());
            this.xmax = Math.max(this.xmax, ((Measurable)drawable).getXMax());
            this.ymin = Math.min(this.ymin, ((Measurable)drawable).getYMin());
            this.ymax = Math.max(this.ymax, ((Measurable)drawable).getYMax());
            this.measured = true;
        }
        this.invalid = true;
    }

    public void updateImage(DrawingPanel drawingPanel) {
        this.invalid = false;
        Image newImage = this.image;
        int iw = drawingPanel.getWidth();
        int ih = drawingPanel.getHeight();
        if (this.image == null || this.image.getWidth(drawingPanel) != iw || this.image.getHeight(drawingPanel) != ih) {
            newImage = drawingPanel.createImage(iw, ih);
        }
        if (newImage == null) {
            return;
        }
        Graphics g = newImage.getGraphics();
        if (g != null) {
            if (this.background == null) {
                g.clearRect(0, 0, iw, ih);
            } else {
                g.setColor(this.background);
                g.fillRect(0, 0, iw, ih);
            }
            this.paintMyDrawableList(drawingPanel, g);
            g.dispose();
        }
        this.image = newImage;
    }

    public void draw(DrawingPanel drawingPanel, Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.invalid || this.image == null || this.image.getWidth(drawingPanel) != drawingPanel.getWidth() || this.image.getHeight(drawingPanel) != drawingPanel.getHeight()) {
            this.updateImage(drawingPanel);
        }
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, drawingPanel);
        }
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getYMax() {
        return this.ymax;
    }

    public boolean isMeasured() {
        return this.measured;
    }

    private void paintMyDrawableList(DrawingPanel drawingPanel, Graphics g) {
        ArrayList tempList = (ArrayList)this.drawableList.clone();
        Iterator it = ((AbstractList)tempList).iterator();
        while (it.hasNext()) {
            Drawable drawable = (Drawable)it.next();
            drawable.draw(drawingPanel, g);
        }
    }
}

