/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawableShapeLoader;
import org.opensourcephysics.display.DrawingPanel;

public class DrawableShape
implements Drawable {
    public Color color = new Color(255, 128, 128, 128);
    public Color edgeColor = Color.RED;
    Shape shape;
    double x;
    double y;
    double theta;
    public String shapeClass;

    public DrawableShape(Shape shape, double x, double y) {
        this.x = x;
        this.y = y;
        this.shapeClass = shape.getClass().getName();
        this.shape = AffineTransform.getTranslateInstance(x, y).createTransformedShape(shape);
    }

    public static DrawableShape createCircle(double x, double y, double d) {
        return new DrawableShape(new Ellipse2D.Double(-d / 2.0, -d / 2.0, d, d), x, y);
    }

    public static DrawableShape createRectangle(double x, double y, double w, double h) {
        return new DrawableShape(new Rectangle2D.Double(-w / 2.0, -h / 2.0, w, h), x, y);
    }

    public void setMarkerColor(Color fillColor, Color edgeColor) {
        this.color = fillColor;
        this.edgeColor = edgeColor;
    }

    public void setTheta(double theta) {
        this.shape = AffineTransform.getRotateInstance(theta - this.theta, this.x, this.y).createTransformedShape(this.shape);
        this.theta = theta;
    }

    public double getTheta() {
        return this.theta;
    }

    public void transform(AffineTransform transformation) {
        this.shape = transformation.createTransformedShape(this.shape);
    }

    public void tranform(double[][] mat) {
        this.shape = new AffineTransform(mat[0][0], mat[1][0], mat[0][1], mat[1][1], mat[0][2], mat[1][2]).createTransformedShape(this.shape);
    }

    public void setXY(double _x, double _y) {
        this.shape = AffineTransform.getTranslateInstance(_x - this.x, _y - this.y).createTransformedShape(this.shape);
        this.x = _x;
        this.y = _y;
    }

    public void setX(double _x) {
        this.shape = AffineTransform.getTranslateInstance(_x - this.x, 0.0).createTransformedShape(this.shape);
        this.x = _x;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double _y) {
        this.shape = AffineTransform.getTranslateInstance(0.0, _y - this.y).createTransformedShape(this.shape);
        this.y = _y;
    }

    public double getY() {
        return this.y;
    }

    public String toString() {
        String name = this.getClass().getName();
        name = name.substring(1 + name.lastIndexOf(".")) + '[';
        name = name + "x=" + this.x;
        name = name + ",y=" + this.y + ']';
        return name;
    }

    public void draw(DrawingPanel panel, Graphics g) {
        Shape temp = panel.getPixelTransform().createTransformedShape(this.shape);
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.color);
        g2.fill(temp);
        g2.setPaint(this.edgeColor);
        g2.draw(temp);
        g2.setPaint(Color.BLACK);
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawableShapeLoader();
    }
}

