/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.TextLine;

public class DrawableTextLine
extends TextLine
implements Drawable {
    double x;
    double y;
    double theta = 0.0;
    protected boolean pixelXY = false;

    public DrawableTextLine(String text, double x, double y) {
        super(text);
        this.x = x;
        this.y = y;
        this.color = Color.BLACK;
    }

    public void setPixelXY(boolean enable) {
        this.pixelXY = enable;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setTheta(double theta) {
        this.theta = theta;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (this.text == null || this.text.equals("")) {
            return;
        }
        Font oldFont = g.getFont();
        if (this.pixelXY) {
            this.drawWithPix(panel, g);
        } else {
            this.drawWithWorld(panel, g);
        }
        g.setFont(oldFont);
    }

    void drawWithPix(DrawingPanel panel, Graphics g) {
        if (this.theta != 0.0) {
            ((Graphics2D)g).transform(AffineTransform.getRotateInstance(-this.theta, this.x, this.y));
            this.drawText(g, (int)this.x, (int)this.y);
            ((Graphics2D)g).transform(AffineTransform.getRotateInstance(this.theta, this.x, this.y));
        } else {
            this.drawText(g, (int)this.x, (int)this.y);
        }
    }

    void drawWithWorld(DrawingPanel panel, Graphics g) {
        Point2D pt = new Point2D.Double(this.x, this.y);
        pt = panel.getPixelTransform().transform(pt, pt);
        if (this.theta != 0.0) {
            ((Graphics2D)g).transform(AffineTransform.getRotateInstance(-this.theta, pt.getX(), pt.getY()));
            this.drawText(g, (int)pt.getX(), (int)pt.getY());
            ((Graphics2D)g).transform(AffineTransform.getRotateInstance(this.theta, pt.getX(), pt.getY()));
        } else {
            this.drawText(g, (int)pt.getX(), (int)pt.getY());
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawableTextLineLoader();
    }

    protected static class DrawableTextLineLoader
    extends XMLLoader {
        protected DrawableTextLineLoader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            DrawableTextLine drawableTextLine = (DrawableTextLine)obj;
            control.setValue("text", drawableTextLine.getText());
            control.setValue("x", drawableTextLine.x);
            control.setValue("y", drawableTextLine.y);
            control.setValue("theta", drawableTextLine.theta);
            control.setValue("color", drawableTextLine.color);
            control.setValue("pixel position", drawableTextLine.pixelXY);
        }

        public Object createObject(XMLControl control) {
            return new DrawableTextLine("", 0.0, 0.0);
        }

        public Object loadObject(XMLControl control, Object obj) {
            DrawableTextLine drawableTextLine = (DrawableTextLine)obj;
            drawableTextLine.x = control.getDouble("x");
            drawableTextLine.y = control.getDouble("y");
            drawableTextLine.theta = control.getDouble("theta");
            drawableTextLine.pixelXY = control.getBoolean("pixel position");
            drawableTextLine.setText(control.getString("text"));
            drawableTextLine.color = (Color)control.getObject("color");
            return obj;
        }
    }
}

