/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.ControlFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.DrawableAxes;
import org.opensourcephysics.tools.DatasetTool;
import org.opensourcephysics.tools.ExportTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.Tool;

public class DrawingFrame
extends OSPFrame
implements ClipboardOwner {
    protected JMenu fileMenu;
    protected JMenu editMenu;
    protected JMenuItem copyItem;
    protected JMenuItem pasteItem;
    protected JMenuItem replaceItem;
    protected DrawingPanel drawingPanel;
    protected static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected Window customInspector;
    protected Tool reply;
    static /* synthetic */ Class class$org$opensourcephysics$display$Dataset;
    static /* synthetic */ Class class$org$opensourcephysics$display$Drawable;

    public DrawingFrame() {
        this(DisplayRes.getString("DrawingFrame.DefaultTitle"), new InteractivePanel());
    }

    public DrawingFrame(DrawingPanel drawingPanel) {
        this(DisplayRes.getString("DrawingFrame.DefaultTitle"), drawingPanel);
    }

    public DrawingFrame(String title, DrawingPanel _drawingPanel) {
        super(title);
        this.drawingPanel = _drawingPanel;
        if (this.drawingPanel != null) {
            this.getContentPane().add((Component)this.drawingPanel, "Center");
        }
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
        if (!OSPFrame.appletMode) {
            this.createMenuBar();
        }
        this.reply = new Tool(){

            public void send(Job job, Tool replyTo) throws RemoteException {
                XMLControlElement control = new XMLControlElement();
                try {
                    control.readXML(job.getXML());
                }
                catch (RemoteException ex) {
                    // empty catch block
                }
                ArrayList datasets = DrawingFrame.this.drawingPanel.getObjectOfClass(class$org$opensourcephysics$display$Dataset == null ? (class$org$opensourcephysics$display$Dataset = DrawingFrame.class$("org.opensourcephysics.display.Dataset")) : class$org$opensourcephysics$display$Dataset);
                Iterator it = control.getObjects(class$org$opensourcephysics$display$Dataset == null ? (class$org$opensourcephysics$display$Dataset = DrawingFrame.class$("org.opensourcephysics.display.Dataset")) : class$org$opensourcephysics$display$Dataset).iterator();
                block2: while (it.hasNext()) {
                    Dataset newData = (Dataset)it.next();
                    int id = newData.getID();
                    int n = datasets.size();
                    for (int i = 0; i < n; ++i) {
                        if (((Dataset)datasets.get(i)).getID() != id) continue;
                        XMLControlElement xml = new XMLControlElement(newData);
                        Dataset.getLoader().loadObject(xml, datasets.get(i));
                        continue block2;
                    }
                }
                DrawingFrame.this.drawingPanel.repaint();
            }
        };
    }

    public void render() {
        if (this.isIconified() || !this.isShowing()) {
            return;
        }
        if (this.drawingPanel != null) {
            this.drawingPanel.render();
        } else {
            this.repaint();
        }
    }

    public void invalidateImage() {
        if (this.drawingPanel != null) {
            this.drawingPanel.invalidateImage();
        }
    }

    public DrawingPanel getDrawingPanel() {
        return this.drawingPanel;
    }

    public void setXLabel(String label) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setXLabel(label);
        }
    }

    public void setYLabel(String label) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setYLabel(label);
        }
    }

    public void setPolar(String plotTitle, double deltaR) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setPolar(plotTitle, deltaR);
        }
    }

    public void setCartesian(String xLabel, String yLabel, String plotTitle) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setCartesian(xLabel, yLabel, plotTitle);
        }
    }

    public void limitAutoscaleX(double floor, double ceil) {
        this.drawingPanel.limitAutoscaleX(floor, ceil);
    }

    public void limitAutoscaleY(double floor, double ceil) {
        this.drawingPanel.limitAutoscaleY(floor, ceil);
    }

    public void setAutoscaleX(boolean autoscale) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setAutoscaleX(autoscale);
        }
    }

    public boolean isAutoscaleX() {
        if (this.drawingPanel != null) {
            return this.drawingPanel.isAutoscaleX();
        }
        return false;
    }

    public void setAutoscaleY(boolean autoscale) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setAutoscaleY(autoscale);
        }
    }

    public boolean isAutoscaleY() {
        if (this.drawingPanel != null) {
            return this.drawingPanel.isAutoscaleY();
        }
        return false;
    }

    public void setSquareAspect(boolean isSquare) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setSquareAspect(isSquare);
        }
    }

    public void setLogScale(boolean logX, boolean logY) {
        if (this.drawingPanel != null && this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setLogScale(logX, logY);
        }
    }

    public void setPixelsPerUnit(boolean enable, double xPixPerUnit, double yPixPerUnit) {
        this.drawingPanel.setPixelsPerUnit(enable, xPixPerUnit, yPixPerUnit);
    }

    public void setPreferredMinMax(double xmin, double xmax, double ymin, double ymax) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setPreferredMinMax(xmin, xmax, ymin, ymax);
        }
    }

    public void setPreferredMinMaxY(double ymin, double ymax) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setPreferredMinMaxY(ymin, ymax);
        }
    }

    public void setPreferredMinMaxX(double xmin, double xmax) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setPreferredMinMaxX(xmin, xmax);
        }
    }

    public void clearDataAndRepaint() {
        this.clearData();
        this.drawingPanel.repaint();
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
    }

    public synchronized void addDrawable(Drawable drawable) {
        if (this.drawingPanel != null) {
            this.drawingPanel.addDrawable(drawable);
        }
    }

    public synchronized void replaceDrawable(Drawable oldDrawable, Drawable newDrawable) {
        if (this.drawingPanel != null) {
            this.drawingPanel.replaceDrawable(oldDrawable, newDrawable);
        }
    }

    public synchronized void removeDrawable(Drawable drawable) {
        if (this.drawingPanel != null) {
            this.drawingPanel.removeDrawable(drawable);
        }
    }

    public void setMessage(String msg) {
        this.drawingPanel.setMessage(msg);
    }

    public void setMessage(String msg, int location) {
        this.drawingPanel.setMessage(msg, location);
    }

    public synchronized ArrayList getObjectOfClass(Class c) {
        if (this.drawingPanel != null) {
            return this.drawingPanel.getObjectOfClass(c);
        }
        return null;
    }

    public synchronized ArrayList getDrawables() {
        if (this.drawingPanel != null) {
            return this.drawingPanel.getDrawables();
        }
        return new ArrayList();
    }

    public DrawableAxes getAxes() {
        if (this.drawingPanel instanceof PlottingPanel) {
            return ((PlottingPanel)this.drawingPanel).getAxes();
        }
        return null;
    }

    public synchronized ArrayList getDrawables(Class c) {
        if (this.drawingPanel != null) {
            return this.drawingPanel.getDrawables(c);
        }
        return new ArrayList();
    }

    public synchronized void removeObjectsOfClass(Class c) {
        this.drawingPanel.removeObjectsOfClass(c);
    }

    public void setInteractiveMouseHandler(InteractiveMouseHandler handler) {
        ((InteractivePanel)this.drawingPanel).setInteractiveMouseHandler(handler);
    }

    public void setDrawingPanel(DrawingPanel _drawingPanel) {
        if (this.drawingPanel != null) {
            this.getContentPane().remove(this.drawingPanel);
        }
        this.drawingPanel = _drawingPanel;
        if (this.drawingPanel != null) {
            this.getContentPane().add((Component)this.drawingPanel, "Center");
        }
    }

    public void setInteriorBackground(Color color) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).getAxes().setInteriorBackground(color);
        } else {
            this.drawingPanel.setBackground(color);
        }
    }

    public void paint(Graphics g) {
        if (!OSPFrame.appletMode) {
            super.paint(g);
            return;
        }
        try {
            super.paint(g);
        }
        catch (Exception ex) {
            System.err.println("OSPFrame paint error: " + ex.toString());
            System.err.println("Title: " + this.getTitle());
        }
    }

    public void setEnabledPaste(boolean enable) {
        this.pasteItem.setEnabled(enable);
    }

    protected void pasteAction(XMLControlElement control) {
        XMLTreeChooser chooser = new XMLTreeChooser(DisplayRes.getString("DrawingFrame.SelectDrawables_chooser_title"), DisplayRes.getString("DrawingFrame.SelectDrawables_chooser_message"), this);
        List props = chooser.choose(control, class$org$opensourcephysics$display$Drawable == null ? (class$org$opensourcephysics$display$Drawable = DrawingFrame.class$("org.opensourcephysics.display.Drawable")) : class$org$opensourcephysics$display$Drawable);
        if (!props.isEmpty()) {
            Iterator it = props.iterator();
            while (it.hasNext()) {
                XMLControl prop = (XMLControl)it.next();
                Drawable drawable = (Drawable)prop.loadObject(null);
                this.addDrawable(drawable);
            }
        }
        this.drawingPanel.repaint();
    }

    public void setEnabledReplace(boolean enable) {
        this.replaceItem.setEnabled(enable);
    }

    public void replaceAction(XMLControlElement control) {
        this.clearDrawables();
        this.pasteAction(control);
    }

    protected void copyAction(XMLControlElement control) {
        StringSelection data = new StringSelection(control.toXML());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(data, this);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setEnabledCopy(boolean enable) {
        this.copyItem.setEnabled(enable);
    }

    protected void refreshGUI() {
        this.createMenuBar();
        this.pack();
    }

    private void createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.fileMenu = new JMenu(DisplayRes.getString("DrawingFrame.File_menu_item"));
        JMenuItem printItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Print_menu_item"));
        printItem.setAccelerator(KeyStroke.getKeyStroke(80, MENU_SHORTCUT_KEY_MASK));
        printItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable(DrawingFrame.this.drawingPanel);
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException pe) {
                        JOptionPane.showMessageDialog(DrawingFrame.this, DisplayRes.getString("DrawingFrame.PrintErrorMessage"), DisplayRes.getString("DrawingFrame.Error"), 0);
                    }
                }
            }
        });
        JMenuItem saveXMLItem = new JMenuItem(DisplayRes.getString("DrawingFrame.SaveXML_menu_item"));
        saveXMLItem.setAccelerator(KeyStroke.getKeyStroke(83, MENU_SHORTCUT_KEY_MASK));
        saveXMLItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawingFrame.this.saveXML();
            }
        });
        JMenuItem exportItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Export_menu_item"));
        exportItem.setAccelerator(KeyStroke.getKeyStroke(69, MENU_SHORTCUT_KEY_MASK));
        exportItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ExportTool.getTool().send(new LocalJob(DrawingFrame.this.drawingPanel), null);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
        JMenu saveImage = new JMenu(DisplayRes.getString("DrawingFrame.SaveImage_menu_title"));
        JMenuItem epsMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.EPS_menu_item"));
        JMenuItem jpegMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.JPEG_menu_item"));
        JMenuItem pngMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.PNG_menu_item"));
        saveImage.add(epsMenuItem);
        saveImage.add(jpegMenuItem);
        saveImage.add(pngMenuItem);
        epsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIUtils.saveImage((JComponent)DrawingFrame.this.drawingPanel, "eps", DrawingFrame.this);
            }
        });
        jpegMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIUtils.saveImage((JComponent)DrawingFrame.this.drawingPanel, DisplayRes.getString("DrawingFrame.17"), DrawingFrame.this);
            }
        });
        pngMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIUtils.saveImage((JComponent)DrawingFrame.this.drawingPanel, "png", DrawingFrame.this);
            }
        });
        JMenuItem inspectItem = new JMenuItem(DisplayRes.getString("DrawingFrame.InspectMenuItem"));
        inspectItem.setAccelerator(KeyStroke.getKeyStroke(73, MENU_SHORTCUT_KEY_MASK));
        inspectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawingFrame.this.inspectXML();
            }
        });
        this.fileMenu.add(printItem);
        this.fileMenu.add(saveXMLItem);
        this.fileMenu.add(exportItem);
        this.fileMenu.add(saveImage);
        this.fileMenu.add(inspectItem);
        menuBar.add(this.fileMenu);
        this.editMenu = new JMenu(DisplayRes.getString("DrawingFrame.Edit_menu_title"));
        menuBar.add(this.editMenu);
        this.copyItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Copy_menu_item"));
        this.copyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XMLControlElement control = new XMLControlElement(DrawingFrame.this);
                control.saveObject(null);
                DrawingFrame.this.copyAction(control);
            }
        });
        this.editMenu.add(this.copyItem);
        this.pasteItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Paste_menu_item"));
        this.pasteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable data = clipboard.getContents(null);
                    XMLControlElement control = new XMLControlElement();
                    control.readXML((String)data.getTransferData(DataFlavor.stringFlavor));
                    DrawingFrame.this.pasteAction(control);
                }
                catch (UnsupportedFlavorException ex) {
                }
                catch (IOException ex) {
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
            }
        });
        this.pasteItem.setEnabled(false);
        this.editMenu.add(this.pasteItem);
        this.replaceItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Replace_menu_item"));
        this.replaceItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable data = clipboard.getContents(null);
                    XMLControlElement control = new XMLControlElement();
                    control.readXML((String)data.getTransferData(DataFlavor.stringFlavor));
                    DrawingFrame.this.replaceAction(control);
                }
                catch (UnsupportedFlavorException ex) {
                }
                catch (IOException ex) {
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
            }
        });
        this.replaceItem.setEnabled(false);
        this.editMenu.add(this.replaceItem);
        this.setJMenuBar(menuBar);
        this.loadDisplayMenu();
        this.loadToolsMenu();
        JMenu helpMenu = new JMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        menuBar.add(helpMenu);
        JMenuItem aboutItem = new JMenuItem(DisplayRes.getString("DrawingFrame.AboutOSP_menu_item"));
        aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlFrame.showAboutDialog(DrawingFrame.this);
            }
        });
        helpMenu.add(aboutItem);
    }

    protected JMenu loadDisplayMenu() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return null;
        }
        JMenu displayMenu = new JMenu(DisplayRes.getString("DrawingFrame.Display_menu_title"));
        menuBar.add(displayMenu);
        JMenu fontMenu = new JMenu(DisplayRes.getString("DrawingFrame.Font_menu_title"));
        displayMenu.add(fontMenu);
        JMenuItem sizeUpItem = new JMenuItem(DisplayRes.getString("DrawingFrame.IncreaseFontSize_menu_item"));
        sizeUpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontSizer.levelUp();
            }
        });
        fontMenu.add(sizeUpItem);
        final JMenuItem sizeDownItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DecreaseFontSize_menu_item"));
        sizeDownItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontSizer.levelDown();
            }
        });
        fontMenu.add(sizeDownItem);
        fontMenu.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                sizeDownItem.setEnabled(FontSizer.getLevel() > 0);
            }
        });
        JMenu aliasMenu = new JMenu(DisplayRes.getString("DrawingFrame.AntiAlias_menu_title"));
        displayMenu.add(aliasMenu);
        final JCheckBoxMenuItem textAliasItem = new JCheckBoxMenuItem(DisplayRes.getString("DrawingFrame.Text_checkbox_label"), false);
        textAliasItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawingFrame.this.drawingPanel.antialiasTextOn = textAliasItem.isSelected();
                DrawingFrame.this.drawingPanel.repaint();
            }
        });
        aliasMenu.add(textAliasItem);
        final JCheckBoxMenuItem shapeAliasItem = new JCheckBoxMenuItem(DisplayRes.getString("DrawingFrame.Drawing_textbox_label"), false);
        shapeAliasItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawingFrame.this.drawingPanel.antialiasShapeOn = shapeAliasItem.isSelected();
                DrawingFrame.this.drawingPanel.repaint();
            }
        });
        aliasMenu.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                textAliasItem.setSelected(DrawingFrame.this.drawingPanel.antialiasTextOn);
                shapeAliasItem.setSelected(DrawingFrame.this.drawingPanel.antialiasShapeOn);
            }
        });
        aliasMenu.add(shapeAliasItem);
        menuBar.add(displayMenu);
        return displayMenu;
    }

    protected JMenu loadToolsMenu() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return null;
        }
        JMenu toolsMenu = new JMenu(DisplayRes.getString("DrawingFrame.Tools_menu_title"));
        menuBar.add(toolsMenu);
        JMenuItem datasetItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DatasetTool_menu_item"));
        toolsMenu.add(datasetItem);
        datasetItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DatasetTool tool = DatasetTool.getTool();
                    tool.send(new LocalJob(DrawingFrame.this.drawingPanel), DrawingFrame.this.reply);
                    tool.setVisible(true);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
        return toolsMenu;
    }

    public void setCustomInspector(Window w) {
        if (this.customInspector != null) {
            ((Component)this.customInspector).setVisible(false);
        }
        this.customInspector = w;
    }

    public void inspectXML() {
        if (this.customInspector != null) {
            ((Component)this.customInspector).setVisible(true);
            return;
        }
        XMLControlElement xml = null;
        try {
            Method method = this.drawingPanel.getClass().getMethod("getLoader", null);
            if (method != null && Modifier.isStatic(method.getModifiers())) {
                xml = new XMLControlElement(this.drawingPanel);
            }
        }
        catch (NoSuchMethodException ex) {
            return;
        }
        XMLTreePanel treePanel = new XMLTreePanel(xml);
        JDialog dialog = new JDialog((Frame)null, true);
        dialog.setContentPane(treePanel);
        ((Component)dialog).setSize(new Dimension(600, 300));
        ((Component)dialog).setVisible(true);
    }

    public void saveXML() {
        JFileChooser chooser = OSPFrame.getChooser();
        int result = chooser.showSaveDialog(null);
        if (result == 0) {
            int selected;
            OSPFrame.chooserDir = chooser.getCurrentDirectory().toString();
            File file = chooser.getSelectedFile();
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(null, DisplayRes.getString("DrawingFrame.ReplaceExisting_message") + file.getName() + DisplayRes.getString("DrawingFrame.QuestionMark"), DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"), 1)) != 0) {
                return;
            }
            String fileName = XML.getRelativePath(file.getAbsolutePath());
            if (fileName == null || fileName.trim().equals("")) {
                return;
            }
            int i = fileName.toLowerCase().lastIndexOf(".xml");
            if (i != fileName.length() - 4) {
                fileName = fileName + ".xml";
            }
            try {
                Method method = this.drawingPanel.getClass().getMethod("getLoader", null);
                if (method != null && Modifier.isStatic(method.getModifiers())) {
                    XMLControlElement xml = new XMLControlElement(this.drawingPanel);
                    xml.write(fileName);
                }
            }
            catch (NoSuchMethodException ex) {
                return;
            }
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawingFrameLoader();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class DrawingFrameLoader
    implements XML.ObjectLoader {
        protected DrawingFrameLoader() {
        }

        public Object createObject(XMLControl control) {
            DrawingFrame frame = new DrawingFrame();
            frame.setTitle(control.getString("title"));
            ((Component)frame).setLocation(control.getInt("location x"), control.getInt("location y"));
            frame.setSize(control.getInt("width"), control.getInt("height"));
            if (control.getBoolean("showing")) {
                frame.setVisible(true);
            }
            return frame;
        }

        public void saveObject(XMLControl control, Object obj) {
            DrawingFrame frame = (DrawingFrame)obj;
            control.setValue("title", frame.getTitle());
            control.setValue("showing", frame.isShowing());
            control.setValue("location x", frame.getLocation().x);
            control.setValue("location y", frame.getLocation().y);
            control.setValue("width", frame.getSize().width);
            control.setValue("height", frame.getSize().height);
            control.setValue("drawing panel", frame.getDrawingPanel());
        }

        public Object loadObject(XMLControl control, Object obj) {
            DrawingFrame frame = (DrawingFrame)obj;
            DrawingPanel panel = frame.getDrawingPanel();
            panel.clear();
            XMLControl panelControl = control.getChildControl("drawing panel");
            panelControl.loadObject(panel);
            panel.repaint();
            frame.setTitle(control.getString("title"));
            ((Component)frame).setLocation(control.getInt("location x"), control.getInt("location y"));
            frame.setSize(control.getInt("width"), control.getInt("height"));
            if (control.getBoolean("showing")) {
                frame.setVisible(true);
            }
            return obj;
        }
    }
}

