/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.numerics.Function;

public class FunctionDrawer
implements Drawable,
Measurable,
Function {
    private double[] xrange = new double[2];
    private double[] yrange = new double[2];
    private int numpts = 0;
    private GeneralPath generalPath = new GeneralPath();
    private Function function;
    private boolean filled = false;
    private boolean measured = false;
    public Color color = Color.black;
    public boolean functionChanged = false;

    public FunctionDrawer(Function f) {
        this.function = f;
    }

    public FunctionDrawer(Function f, double xmin, double xmax, int numpts, boolean filled) {
        this(f);
        this.initialize(xmin, xmax, numpts, filled);
    }

    public double evaluate(double x) {
        return this.function.evaluate(x);
    }

    public void initialize(double xmin, double xmax, int numpts, boolean filled) {
        if (numpts < 1) {
            return;
        }
        this.filled = filled;
        this.xrange[0] = xmin;
        this.xrange[1] = xmax;
        this.numpts = numpts;
        this.generalPath.reset();
        if (numpts < 1) {
            return;
        }
        this.yrange[0] = this.function.evaluate(xmin);
        this.yrange[1] = this.yrange[0];
        if (filled) {
            this.generalPath.moveTo((float)this.xrange[0], 0.0f);
            this.generalPath.lineTo((float)this.xrange[0], (float)this.yrange[0]);
        } else {
            this.generalPath.moveTo((float)this.xrange[0], (float)this.yrange[0]);
        }
        double x = this.xrange[0];
        double dx = (xmax - xmin) / (double)numpts;
        for (int i = 0; i < numpts; ++i) {
            double y = this.function.evaluate(x += dx);
            this.generalPath.lineTo((float)x, (float)y);
            if (y < this.yrange[0]) {
                this.yrange[0] = y;
            }
            if (!(y > this.yrange[1])) continue;
            this.yrange[1] = y;
        }
        if (filled) {
            this.generalPath.lineTo((float)x, 0.0f);
            this.generalPath.closePath();
        }
        this.measured = true;
    }

    public GeneralPath getPath() {
        return (GeneralPath)this.generalPath.clone();
    }

    public double[] getXRange() {
        return this.xrange;
    }

    public double[] getYRange() {
        return this.yrange;
    }

    void checkRange(DrawingPanel panel) {
        if (this.xrange[0] == panel.getXMin() && this.xrange[1] == panel.getXMax() && this.numpts == panel.getWidth() && !this.functionChanged) {
            return;
        }
        this.functionChanged = false;
        this.xrange[0] = panel.getXMin();
        this.xrange[1] = panel.getXMax();
        this.numpts = panel.getWidth();
        this.generalPath.reset();
        if (this.numpts < 1) {
            return;
        }
        this.yrange[0] = this.function.evaluate(this.xrange[0]);
        this.yrange[1] = this.yrange[0];
        if (this.filled) {
            this.generalPath.moveTo((float)this.xrange[0], 0.0f);
            this.generalPath.lineTo((float)this.xrange[0], (float)this.yrange[0]);
        } else {
            this.generalPath.moveTo((float)this.xrange[0], (float)this.yrange[0]);
        }
        double x = this.xrange[0];
        double dx = (this.xrange[1] - this.xrange[0]) / (double)this.numpts;
        for (int i = 0; i < this.numpts; ++i) {
            double y = this.function.evaluate(x += dx);
            if (Double.isNaN(x) || Double.isNaN(y)) continue;
            y = Math.min(y, 1.0E12);
            y = Math.max(y, -1.0E12);
            this.generalPath.lineTo((float)x, (float)y);
            if (y < this.yrange[0]) {
                this.yrange[0] = y;
            }
            if (!(y > this.yrange[1])) continue;
            this.yrange[1] = y;
        }
        if (this.filled) {
            this.generalPath.lineTo((float)x, 0.0f);
            this.generalPath.closePath();
        }
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.measured) {
            this.checkRange(panel);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.color);
        Shape s = this.generalPath.createTransformedShape(panel.getPixelTransform());
        if (this.filled) {
            g2.fill(s);
            g2.draw(s);
        } else {
            g2.draw(s);
        }
    }

    public void setFilled(boolean _filled) {
        this.filled = _filled;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public boolean isMeasured() {
        return this.measured;
    }

    public double getXMin() {
        return this.xrange[0];
    }

    public double getXMax() {
        return this.xrange[1];
    }

    public double getYMin() {
        return this.yrange[0];
    }

    public double getYMax() {
        return this.yrange[1];
    }
}

