/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;

public class HighlightableDataset
extends Dataset {
    boolean[] highlighted = new boolean[1];
    boolean[] previous;
    Color highlightColor = new Color(255, 255, 0, 128);
    Shape highlightShape;
    static /* synthetic */ Class class$org$opensourcephysics$display$Dataset;

    public HighlightableDataset() {
    }

    public HighlightableDataset(Color markerColor) {
        super(markerColor);
    }

    public HighlightableDataset(Color markerColor, Color lineColor, boolean connected) {
        super(markerColor, lineColor, connected);
    }

    public void append(double x, double y) {
        super.append(x, y);
        this.adjustCapacity(this.xpoints.length);
    }

    public void append(double[] xarray, double[] yarray) {
        super.append(xarray, yarray);
        this.adjustCapacity(this.xpoints.length);
    }

    public void clear() {
        super.clear();
        this.previous = this.highlighted;
        this.highlighted = new boolean[this.xpoints.length];
    }

    public void restoreHighlights() {
        if (this.previous != null && this.previous.length == this.highlighted.length) {
            this.highlighted = this.previous;
        }
    }

    public void clearHighlights() {
        for (int i = 0; i < this.highlighted.length; ++i) {
            this.highlighted[i] = false;
        }
    }

    public void setHighlighted(int i, boolean highlight) {
        if (i >= this.highlighted.length) {
            this.adjustCapacity(i + 1);
        }
        this.highlighted[i] = highlight;
    }

    public void setHighlighted(int start, int end, boolean highlight) {
        if (end >= this.highlighted.length) {
            this.adjustCapacity(end + 1);
        }
        for (int i = start = Math.max(start, 0); i <= end; ++i) {
            this.highlighted[i] = highlight;
        }
    }

    public boolean isHighlighted(int i) {
        if (i >= this.highlighted.length) {
            this.adjustCapacity(i + 1);
        }
        return this.highlighted[i];
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
    }

    protected void moveDatum(int loc) {
        super.moveDatum(loc);
    }

    private synchronized void adjustCapacity(int minLength) {
        int len = Math.max(this.xpoints.length, minLength);
        if (this.highlighted.length == len) {
            return;
        }
        boolean[] temp = this.highlighted;
        this.highlighted = new boolean[len];
        int count = Math.min(temp.length, len);
        System.arraycopy(temp, 0, this.highlighted, 0, count);
    }

    public void draw(DrawingPanel drawingPanel, Graphics g) {
        super.draw(drawingPanel, g);
        Graphics2D g2 = (Graphics2D)g;
        int offset = this.getMarkerSize() + 4;
        int edge = 2 * offset;
        Shape clipShape = g2.getClip();
        g2.setClip(drawingPanel.leftGutter - offset - 1, drawingPanel.topGutter - offset - 1, drawingPanel.getWidth() - drawingPanel.leftGutter - drawingPanel.rightGutter + 2 + 2 * offset, drawingPanel.getHeight() - drawingPanel.bottomGutter - drawingPanel.topGutter + 2 + 2 * offset);
        Rectangle viewRect = drawingPanel.getViewRect();
        if (viewRect != null) {
            g2.clipRect(viewRect.x, viewRect.y, viewRect.x + viewRect.width, viewRect.y + viewRect.height);
        }
        for (int i = 0; i < this.index; ++i) {
            if (!this.isHighlighted(i) || Double.isNaN(this.ypoints[i])) continue;
            double xp = drawingPanel.xToPix(this.xpoints[i]);
            double yp = drawingPanel.yToPix(this.ypoints[i]);
            Rectangle2D.Double shape = new Rectangle2D.Double(xp - (double)offset, yp - (double)offset, edge, edge);
            g2.setColor(this.highlightColor);
            g2.fill(shape);
        }
        g2.setClip(clipShape);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            XML.getLoader(class$org$opensourcephysics$display$Dataset == null ? (class$org$opensourcephysics$display$Dataset = HighlightableDataset.class$("org.opensourcephysics.display.Dataset")) : class$org$opensourcephysics$display$Dataset).saveObject(control, obj);
            HighlightableDataset data = (HighlightableDataset)obj;
            control.setValue("highlighted", data.highlighted);
        }

        public Object createObject(XMLControl control) {
            return new HighlightableDataset();
        }

        public Object loadObject(XMLControl control, Object obj) {
            XML.getLoader(class$org$opensourcephysics$display$Dataset == null ? (class$org$opensourcephysics$display$Dataset = HighlightableDataset.class$("org.opensourcephysics.display.Dataset")) : class$org$opensourcephysics$display$Dataset).loadObject(control, obj);
            HighlightableDataset data = (HighlightableDataset)obj;
            boolean[] highlighted = (boolean[])control.getObject("highlighted");
            if (highlighted != null) {
                data.highlighted = highlighted;
            }
            return data;
        }
    }
}

