/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.BoundedShape;
import org.opensourcephysics.display.DrawingPanel;

public class InteractiveArrow
extends BoundedShape {
    Point2D[] hotSpots = new Point2D[2];
    BasicStroke stroke = new BasicStroke(2.0f);
    Shape head;
    static int HEAD = 1;

    public InteractiveArrow(double x, double y, double w, double h) {
        super(new Line2D.Double(0.0, 0.0, w, h), x, y);
        this.theta = w == 0.0 ? 0.0 : Math.atan2(h, w);
        this.head = this.getHead(this.theta);
        this.setRotateDrag(true);
        this.hideBounds = true;
        this.width = w;
        this.height = h;
        int n = this.hotSpots.length;
        for (int i = 0; i < n; ++i) {
            this.hotSpots[i] = new Point2D.Float(0.0f, 0.0f);
        }
    }

    public void setStrokeWidth(double width) {
        this.stroke = new BasicStroke((float)width);
    }

    public void setOffset(double xoffset, double yoffset) {
    }

    public boolean isInside(DrawingPanel panel, int xpix, int ypix) {
        this.hotspot = BoundedShape.NONE;
        if (!this.enabled) {
            return false;
        }
        if (this.pixelBounds.contains(xpix, ypix) && !this.selected) {
            return true;
        }
        if (this.selected) {
            this.hotspot = this.getHotSpotIndex(xpix, ypix, this.hotSpots);
            return true;
        }
        return false;
    }

    public void setTheta(double theta) {
        double len = Math.sqrt(this.width * this.width + this.height * this.height);
        double dx = len * Math.cos(theta);
        double dy = len * Math.sin(theta);
        this.shape = new Line2D.Double(this.x, this.y, this.x + dx, this.y + dy);
        this.shape = AffineTransform.getTranslateInstance(this.x, this.y).createTransformedShape(this.shape);
        this.width = dx;
        this.height = dy;
        this.theta = theta;
        this.head = this.getHead(theta);
    }

    void setHotSpotXY(double x, double y) {
        if (this.hideBounds) {
            this.setXY(x, y);
            return;
        }
        if (this.xyDrag && this.selected && this.hotspot == BoundedShape.CENTER) {
            this.setXY(x, y);
        } else if (this.rotateDrag && this.selected && this.hotspot == HEAD) {
            double r = -this.toPixels.getScaleY() / this.toPixels.getScaleX();
            double dx = x - this.x;
            double dy = y - this.y;
            this.shape = new Line2D.Double(this.x, this.y, this.x + dx, this.y + dy);
            this.width = dx;
            this.height = dy;
            this.theta = this.width == 0.0 ? this.theta : Math.atan2(r * this.height, this.width);
            this.head = this.getHead(this.theta);
        }
    }

    public void setWidthHeight(double width, double height) {
        this.shape = new Line2D.Double(this.x, this.y, this.x + width, this.y + height);
        this.width = width;
        this.height = height;
        this.theta = width == 0.0 ? this.theta : Math.atan2(height, width);
        this.head = this.getHead(this.theta);
    }

    public void draw(DrawingPanel panel, Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.toPixels = panel.getPixelTransform();
        Point2D pt = new Point2D.Double(this.x, this.y);
        pt = this.toPixels.transform(pt, pt);
        this.computePixelBounds(pt);
        Shape temp = this.pixelSized ? new AffineTransform(1.0, 0.0, 0.0, -1.0, -this.x + pt.getX(), this.y + pt.getY()).createTransformedShape(this.shape) : this.toPixels.createTransformedShape(this.shape);
        g2.setPaint(this.edgeColor);
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(this.stroke);
        g2.draw(temp);
        this.hotSpots[0].setLocation(pt);
        pt = new Point2D.Double(this.x + this.width, this.y + this.height);
        pt = this.toPixels.transform(pt, pt);
        this.hotSpots[1].setLocation(pt);
        temp = AffineTransform.getTranslateInstance(pt.getX(), pt.getY()).createTransformedShape(this.head);
        g2.fill(temp);
        g2.draw(temp);
        g2.setStroke(oldStroke);
        if (!this.selected || this.hideBounds) {
            return;
        }
        g2.setPaint(this.boundsColor);
        if (this.xyDrag) {
            g2.fillRect((int)this.hotSpots[BoundedShape.CENTER].getX() - this.delta, (int)this.hotSpots[BoundedShape.CENTER].getY() - this.delta, this.d2, this.d2);
        }
        if (this.rotateDrag) {
            g2.fillOval((int)this.hotSpots[HEAD].getX() - this.delta, (int)this.hotSpots[HEAD].getY() - this.delta, this.d2, this.d2);
        }
        g2.setPaint(Color.BLACK);
    }

    private void computePixelBounds(Point2D pt) {
        double dx = this.toPixels.getScaleX() * this.width;
        double dy = this.toPixels.getScaleY() * this.height;
        double len = Math.sqrt(dx * dx + dy * dy) + (double)this.delta;
        Rectangle2D.Double rect = new Rectangle2D.Double(pt.getX(), pt.getY() - (double)this.delta, len, this.d2);
        this.pixelBounds = AffineTransform.getRotateInstance(-this.theta, pt.getX(), pt.getY()).createTransformedShape(rect);
    }

    public Cursor getPreferredCursor() {
        if (this.xyDrag && this.hotspot == BoundedShape.CENTER) {
            return Cursor.getPredefinedCursor(13);
        }
        if (this.rotateDrag && this.hotspot == HEAD) {
            return Cursor.getPredefinedCursor(12);
        }
        if (this.selected) {
            return Cursor.getPredefinedCursor(1);
        }
        return Cursor.getPredefinedCursor(12);
    }

    private Shape getHead(double theta) {
        float headSize = 4.0f + 2.0f * this.stroke.getLineWidth();
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(-headSize, -headSize / 2.0f);
        path.lineTo(-headSize, headSize / 2.0f);
        path.closePath();
        AffineTransform rot = AffineTransform.getRotateInstance(-theta);
        Shape head = rot.createTransformedShape(path);
        return head;
    }

    public static XML.ObjectLoader getLoader() {
        return new InteractiveArrowLoader();
    }

    protected static class InteractiveArrowLoader
    extends XMLLoader {
        protected InteractiveArrowLoader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            InteractiveArrow arrow = (InteractiveArrow)obj;
            control.setValue("x", arrow.x);
            control.setValue("y", arrow.y);
            control.setValue("width", arrow.width);
            control.setValue("height", arrow.height);
            control.setValue("is enabled", arrow.isEnabled());
            control.setValue("is measured", arrow.isMeasured());
            control.setValue("color", arrow.color);
        }

        public Object createObject(XMLControl control) {
            return new InteractiveArrow(0.0, 0.0, 0.0, 0.0);
        }

        public Object loadObject(XMLControl control, Object obj) {
            InteractiveArrow arrow = (InteractiveArrow)obj;
            double x = control.getDouble("x");
            double y = control.getDouble("y");
            double w = control.getDouble("width");
            double h = control.getDouble("height");
            arrow.enabled = control.getBoolean("is enabled");
            arrow.enableMeasure = control.getBoolean("is measured");
            arrow.color = (Color)control.getObject("color");
            arrow.setXY(x, y);
            arrow.setWidthHeight(w, h);
            return obj;
        }
    }
}

