/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractiveShape;
import org.opensourcephysics.display.TextLine;

public class InteractiveTextLine
extends InteractiveShape {
    TextLine textLine;
    boolean dirty = true;
    double sx;
    double sy;
    Rectangle2D boundsRect = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);

    public InteractiveTextLine(String text, double x, double y) {
        super(null, x, y);
        this.textLine = new TextLine(text);
        this.textLine.setJustification(0);
        this.color = Color.BLACK;
    }

    public void setJustification(int justification) {
        this.textLine.setJustification(justification);
    }

    public void setText(String text) {
        this.textLine.setText(text);
        this.dirty = true;
    }

    public String getText() {
        return this.textLine.getText();
    }

    public void setFont(Font font) {
        this.textLine.setFont(font);
        this.dirty = true;
    }

    public Font getFont() {
        return this.textLine.getFont();
    }

    public boolean isInside(DrawingPanel panel, int xpix, int ypix) {
        if (this.textLine == null || !this.enabled) {
            return false;
        }
        return Math.abs(panel.xToPix(this.x) - xpix) < 10 && Math.abs(panel.yToPix(this.y) - ypix) < 10;
    }

    private void checkBounds(Graphics g) {
        if (this.dirty || this.toPixels.getScaleX() != this.sx || this.toPixels.getScaleY() != this.sy) {
            this.boundsRect = this.textLine.getStringBounds(g);
            this.sx = this.toPixels.getScaleX();
            this.sy = this.toPixels.getScaleY();
            this.dirty = false;
        }
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (this.textLine.getText().trim().equals("")) {
            return;
        }
        this.textLine.setColor(this.color);
        this.toPixels = panel.getPixelTransform();
        this.checkBounds(g);
        Point2D pt = new Point2D.Double(this.x, this.y);
        pt = this.toPixels.transform(pt, pt);
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(pt.getX(), pt.getY());
        g2.rotate(-this.theta);
        this.textLine.drawText(g2, (int)this.boundsRect.getX(), (int)this.boundsRect.getY());
        g2.rotate(this.theta);
        g2.translate(-pt.getX(), -pt.getY());
    }

    public static XML.ObjectLoader getLoader() {
        return new InteractiveTextLineLoader();
    }

    protected static class InteractiveTextLineLoader
    extends XMLLoader {
        protected InteractiveTextLineLoader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            InteractiveTextLine interactiveTextLine = (InteractiveTextLine)obj;
            control.setValue("text", interactiveTextLine.getText());
            control.setValue("x", interactiveTextLine.x);
            control.setValue("y", interactiveTextLine.y);
            control.setValue("is enabled", interactiveTextLine.isEnabled());
            control.setValue("is measured", interactiveTextLine.isMeasured());
            control.setValue("color", interactiveTextLine.color);
        }

        public Object createObject(XMLControl control) {
            return new InteractiveTextLine("", 0.0, 0.0);
        }

        public Object loadObject(XMLControl control, Object obj) {
            InteractiveTextLine interactiveTextLine = (InteractiveTextLine)obj;
            double x = control.getDouble("x");
            double y = control.getDouble("y");
            interactiveTextLine.setText(control.getString("text"));
            interactiveTextLine.enabled = control.getBoolean("is enabled");
            interactiveTextLine.enableMeasure = control.getBoolean("is measured");
            interactiveTextLine.color = (Color)control.getObject("color");
            interactiveTextLine.setXY(x, y);
            return obj;
        }
    }
}

