/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Dataset;

public class Stripchart
extends Dataset {
    boolean rightToLeft = true;
    double xrange;
    double yrange;
    double lastx;
    boolean enabled = true;

    public Stripchart(double _xrange, double _yrange) {
        this.xrange = Math.abs(_xrange);
        this.yrange = Math.abs(_yrange);
    }

    protected Stripchart() {
        this(1.0, 10.0);
    }

    public void setRange(double _xrange, double _yrange) {
        this.xrange = Math.abs(_xrange);
        this.yrange = Math.abs(_yrange);
    }

    public void enable(boolean enabled) {
        this.enabled = enabled;
    }

    public void append(double x, double y) {
        if (!this.enabled) {
            super.append(x, y);
            return;
        }
        if (this.index != 0 && x < this.lastx) {
            this.clear();
        }
        this.lastx = x;
        super.append(x, y);
        this.trim();
    }

    public void append(double[] _xpoints, double[] _ypoints) {
        if (!this.enabled) {
            super.append(_xpoints, _ypoints);
            return;
        }
        if (this.index != 0 && _xpoints[0] < this.lastx) {
            this.clear();
        }
        int n = _xpoints.length;
        for (int i = 1; i < n; ++i) {
            if (!(_xpoints[i] < _xpoints[i - 1])) continue;
            this.clear();
            return;
        }
        this.lastx = _xpoints[_xpoints.length - 1];
        super.append(_xpoints, _ypoints);
        this.trim();
    }

    public void clear() {
        super.clear();
        this.lastx = this.xpoints[0];
    }

    private void trim() {
        if (this.index > 0 && this.xpoints[0] < this.lastx - this.xrange) {
            int counter;
            for (counter = 0; counter < this.index && this.xpoints[counter] < this.lastx - this.xrange; ++counter) {
            }
            System.arraycopy(this.xpoints, counter, this.xpoints, 0, this.index - counter);
            System.arraycopy(this.ypoints, counter, this.ypoints, 0, this.index - counter);
            this.index -= counter;
        }
        this.xmin = this.rightToLeft ? this.lastx - this.xrange : this.lastx;
        this.xmax = this.rightToLeft ? this.lastx : this.lastx - this.xrange;
        this.ymin = this.ymax = this.ypoints[0];
        for (int i = 1; i < this.index; ++i) {
            this.ymin = Math.min(this.ymin, this.ypoints[i]);
            this.ymax = Math.max(this.ymax, this.ypoints[i]);
        }
        if (this.ymax - this.ymin < this.yrange) {
            this.ymin = (this.ymax + this.ymin - this.yrange) / 2.0;
            this.ymax = (this.ymax + this.ymin + this.yrange) / 2.0;
        }
        this.recalculatePath();
    }

    public static XML.ObjectLoader getLoader() {
        return new StripchartLoader();
    }

    protected static class StripchartLoader
    extends Dataset.Loader {
        protected StripchartLoader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            super.saveObject(control, obj);
            Stripchart dataset = (Stripchart)obj;
            control.setValue("x_range", dataset.xrange);
            control.setValue("y_range", dataset.yrange);
            control.setValue("last_x", dataset.lastx);
            control.setValue("right_to_left", dataset.rightToLeft);
        }

        public Object loadObject(XMLControl control, Object obj) {
            Stripchart dataset = (Stripchart)obj;
            dataset.xrange = control.getDouble("x_range");
            dataset.yrange = control.getDouble("y_range");
            dataset.lastx = control.getDouble("last_x");
            dataset.rightToLeft = control.getBoolean("right_to_left");
            super.loadObject(control, obj);
            return obj;
        }
    }
}

