/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Component;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class TextFrame
extends JFrame {
    JTextPane textPane = new JTextPane();
    JScrollPane textScroller;

    public TextFrame() {
        this((String)null, (Class)null);
    }

    public TextFrame(String resourceName) {
        this(resourceName, (Class)null);
    }

    public TextFrame(String resourceName, Class location) {
        ((Component)this).setSize(300, 300);
        this.textPane.setEditable(false);
        this.textScroller = new JScrollPane(this.textPane);
        this.setContentPane(this.textScroller);
        if (resourceName != null) {
            this.loadResource(resourceName, location);
        }
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public void enableHyperlinks() {
        this.textPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        TextFrame.this.textPane.setPage(e.getURL());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public boolean loadResource(String resourceName, Class location) {
        Resource res = null;
        try {
            res = ResourceLoader.getResource(resourceName, location);
        }
        catch (Exception ex) {
            OSPLog.fine("Error getting resource: " + resourceName);
            return false;
        }
        if (res == null) {
            OSPLog.fine("Resource not found: " + resourceName);
            return false;
        }
        try {
            this.textPane.setPage(res.getURL());
        }
        catch (IOException ex) {
            OSPLog.fine("Resource not loadeded: " + resourceName);
            return false;
        }
        this.setTitle(resourceName);
        return true;
    }
}

