/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractAxes;
import org.opensourcephysics.display.axes.CartesianAxes;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display.axes.YAxis;

public class CartesianType2
extends AbstractAxes
implements CartesianAxes {
    XAxis xaxis;
    YAxis yaxis;
    boolean xlog = false;
    boolean ylog = false;

    public CartesianType2(PlottingPanel panel) {
        super(panel);
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        this.xaxis = new XAxis();
        this.yaxis = new YAxis();
        this.xaxis.setLocationType(1);
        this.yaxis.setLocationType(1);
        panel.setGutters(50, 25, 25, 50);
        if (panel == null) {
            return;
        }
        panel.setCoordinateStringBuilder(CoordinateStringBuilder.createCartesian());
        panel.setAxes(this);
    }

    public void setXLabel(String s, String font_name) {
        this.xaxis.setTitle(s, font_name);
    }

    public void setYLabel(String s, String font_name) {
        this.yaxis.setTitle(s, font_name);
    }

    public String getXLabel() {
        return this.xaxis.axisLabel.getText();
    }

    public String getYLabel() {
        return this.yaxis.axisLabel.getText();
    }

    public String getTitle() {
        return this.titleLine.getText();
    }

    public void setTitle(String s, String font_name) {
        this.titleLine.setText(s);
        if (font_name == null || font_name.equals("")) {
            return;
        }
        this.titleLine.setFont(Font.decode(font_name));
    }

    public void setXLog(boolean isLog) {
        this.xlog = isLog;
        if (isLog) {
            this.xaxis.setAxisType(1);
        } else {
            this.xaxis.setAxisType(0);
        }
    }

    public void setYLog(boolean isLog) {
        this.ylog = isLog;
        if (isLog) {
            this.yaxis.setAxisType(1);
        } else {
            this.yaxis.setAxisType(0);
        }
    }

    public boolean isXLog() {
        return this.xlog;
    }

    public boolean isYLog() {
        return this.ylog;
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.interiorColor != null) {
            g.setColor(this.interiorColor);
            int gw = panel.getLeftGutter() + panel.getRightGutter();
            int gh = panel.getTopGutter() + panel.getBottomGutter();
            g.fillRect(panel.getLeftGutter(), panel.getTopGutter(), panel.getWidth() - gw, panel.getHeight() - gh);
            g.setColor(Color.lightGray);
            g.drawRect(panel.getLeftGutter(), panel.getTopGutter(), panel.getWidth() - gw - 1, panel.getHeight() - gh - 1);
        }
        this.xaxis.draw(panel, g);
        this.yaxis.draw(panel, g);
        this.titleLine.setX((panel.getXMax() + panel.getXMin()) / 2.0);
        if (panel.getTopGutter() > 20) {
            this.titleLine.setY(panel.getYMax() + 5.0 / panel.getYPixPerUnit());
        } else {
            this.titleLine.setY(panel.getYMax() - 25.0 / panel.getYPixPerUnit());
        }
        this.titleLine.draw(panel, g);
    }

    public void setInteriorBackground(Color color) {
        this.interiorColor = color;
    }

    public void setShowMajorXGrid(boolean showGrid) {
        this.xaxis.setShowMajorGrid(showGrid);
        if (!showGrid) {
            this.setShowMinorXGrid(showGrid);
        }
    }

    public void setShowMinorXGrid(boolean showGrid) {
    }

    public void setShowMajorYGrid(boolean showGrid) {
        this.yaxis.setShowMajorGrid(showGrid);
        if (!showGrid) {
            this.setShowMinorYGrid(showGrid);
        }
    }

    public void setShowMinorYGrid(boolean showGrid) {
    }

    public void setX(double x) {
    }

    public void setY(double y) {
    }

    public double getX() {
        return 0.0;
    }

    public double getY() {
        return 0.0;
    }
}

