/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;

public class PolarCoordinateStringBuilder
extends CoordinateStringBuilder {
    protected DecimalFormat scientificFormat = new DecimalFormat("0.###E0");
    protected DecimalFormat decimalFormat = new DecimalFormat("0.00");
    protected String rLabel = "r=";
    protected String phiLabel = " phi=";
    protected double sin = 0.0;
    protected double cos = 1.0;

    public PolarCoordinateStringBuilder() {
        this("r=", "  phi=");
    }

    public PolarCoordinateStringBuilder(String rLabel, String phiLabel, double phiZero) {
        this(rLabel, phiLabel);
        this.sin = -Math.sin(phiZero);
        this.cos = Math.cos(phiZero);
    }

    public PolarCoordinateStringBuilder(String rLabel, String phiLabel) {
        this.rLabel = rLabel;
        this.phiLabel = phiLabel;
    }

    public void setCoordinateLabels(String rLabel, String phiLabel) {
        this.rLabel = rLabel;
        this.phiLabel = phiLabel;
    }

    public String getCoordinateString(DrawingPanel panel, MouseEvent e) {
        double y;
        double x = panel.pixToX(e.getPoint().x);
        double r = Math.sqrt(x * x + (y = panel.pixToY(e.getPoint().y)) * y);
        String msg = r > 100.0 || r < 0.01 ? this.rLabel + this.scientificFormat.format((float)r) : this.rLabel + this.decimalFormat.format((float)r);
        msg = msg + this.phiLabel + this.decimalFormat.format((double)(180.0f * (float)Math.atan2(x * this.sin + y * this.cos, x * this.cos - y * this.sin)) / Math.PI);
        return msg;
    }
}

