/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.dialogs.DecimalField;
import org.opensourcephysics.display.dialogs.DialogsRes;

public class ScaleInspector
extends JDialog {
    protected DrawingPanel plotPanel;
    protected JPanel dataPanel;
    protected JLabel xMinLabel;
    protected JLabel xMaxLabel;
    protected JLabel yMinLabel;
    protected JLabel yMaxLabel;
    protected DecimalField xMinField;
    protected DecimalField xMaxField;
    protected DecimalField yMinField;
    protected DecimalField yMaxField;
    protected JCheckBox xAutoscaleCheckBox;
    protected JCheckBox yAutoscaleCheckBox;
    protected JButton okButton;
    protected JButton cancelButton;

    public ScaleInspector(DrawingPanel panel) {
        super((Frame)null, true);
        this.plotPanel = panel;
        this.setTitle(DialogsRes.SCALE_SCALE);
        this.setResizable(false);
        this.createGUI();
        this.pack();
    }

    private void createGUI() {
        JPanel inspectorPanel = new JPanel(new BorderLayout());
        this.setContentPane(inspectorPanel);
        JPanel controlPanel = new JPanel(new BorderLayout());
        inspectorPanel.add((Component)controlPanel, "South");
        this.xMinLabel = new JLabel(DialogsRes.SCALE_MIN);
        this.xMinField = new DecimalField(5, 1);
        this.xMinField.setMaximumSize(this.xMinField.getPreferredSize());
        this.xMinField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                double xMax = ScaleInspector.this.plotPanel.getPreferredXMax();
                ScaleInspector.this.plotPanel.setPreferredMinMaxX(ScaleInspector.this.xMinField.getValue(), xMax);
                ScaleInspector.this.plotPanel.repaint();
                ScaleInspector.this.updateDisplay();
                ScaleInspector.this.xMinField.selectAll();
            }
        });
        this.xMinField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ScaleInspector.this.xMinField.selectAll();
            }

            public void focusLost(FocusEvent e) {
                double xMax = ScaleInspector.this.plotPanel.getPreferredXMax();
                ScaleInspector.this.plotPanel.setPreferredMinMaxX(ScaleInspector.this.xMinField.getValue(), xMax);
                ScaleInspector.this.plotPanel.repaint();
                ScaleInspector.this.updateDisplay();
            }
        });
        this.xAutoscaleCheckBox = new JCheckBox(DialogsRes.SCALE_AUTO);
        this.xAutoscaleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScaleInspector.this.xMinField.setEnabled(!ScaleInspector.this.xAutoscaleCheckBox.isSelected());
                ScaleInspector.this.xMaxField.setEnabled(!ScaleInspector.this.xAutoscaleCheckBox.isSelected());
                ScaleInspector.this.plotPanel.setAutoscaleX(ScaleInspector.this.xAutoscaleCheckBox.isSelected());
                ScaleInspector.this.plotPanel.scale();
                ScaleInspector.this.updateDisplay();
                ScaleInspector.this.plotPanel.repaint();
            }
        });
        this.xMaxLabel = new JLabel(DialogsRes.SCALE_MAX);
        this.xMaxField = new DecimalField(5, 1);
        this.xMaxField.setMaximumSize(this.xMaxField.getPreferredSize());
        this.xMaxField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                double xMin = ScaleInspector.this.plotPanel.getPreferredXMin();
                ScaleInspector.this.plotPanel.setPreferredMinMaxX(xMin, ScaleInspector.this.xMaxField.getValue());
                ScaleInspector.this.plotPanel.repaint();
                ScaleInspector.this.updateDisplay();
                ScaleInspector.this.xMaxField.selectAll();
            }
        });
        this.xMaxField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ScaleInspector.this.xMaxField.selectAll();
            }

            public void focusLost(FocusEvent e) {
                double xMin = ScaleInspector.this.plotPanel.getPreferredXMin();
                ScaleInspector.this.plotPanel.setPreferredMinMaxX(xMin, ScaleInspector.this.xMaxField.getValue());
                ScaleInspector.this.plotPanel.repaint();
                ScaleInspector.this.updateDisplay();
            }
        });
        this.yMinLabel = new JLabel(DialogsRes.SCALE_MIN);
        this.yMinField = new DecimalField(5, 1);
        this.yMinField.setMaximumSize(this.yMinField.getPreferredSize());
        this.yMinField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                double yMax = ScaleInspector.this.plotPanel.getPreferredYMax();
                ScaleInspector.this.plotPanel.setPreferredMinMaxY(ScaleInspector.this.yMinField.getValue(), yMax);
                ScaleInspector.this.plotPanel.repaint();
                ScaleInspector.this.updateDisplay();
                ScaleInspector.this.yMinField.selectAll();
            }
        });
        this.yMinField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ScaleInspector.this.yMinField.selectAll();
            }

            public void focusLost(FocusEvent e) {
                double yMax = ScaleInspector.this.plotPanel.getPreferredYMax();
                ScaleInspector.this.plotPanel.setPreferredMinMaxY(ScaleInspector.this.yMinField.getValue(), yMax);
                ScaleInspector.this.plotPanel.repaint();
                ScaleInspector.this.updateDisplay();
            }
        });
        this.yAutoscaleCheckBox = new JCheckBox(DialogsRes.SCALE_AUTO);
        this.yAutoscaleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScaleInspector.this.yMinField.setEnabled(!ScaleInspector.this.yAutoscaleCheckBox.isSelected());
                ScaleInspector.this.yMaxField.setEnabled(!ScaleInspector.this.yAutoscaleCheckBox.isSelected());
                ScaleInspector.this.plotPanel.setAutoscaleY(ScaleInspector.this.yAutoscaleCheckBox.isSelected());
                ScaleInspector.this.plotPanel.scale();
                ScaleInspector.this.updateDisplay();
                ScaleInspector.this.plotPanel.repaint();
            }
        });
        this.yMaxLabel = new JLabel(DialogsRes.SCALE_MAX);
        this.yMaxField = new DecimalField(5, 1);
        this.yMaxField.setMaximumSize(this.yMaxField.getPreferredSize());
        this.yMaxField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                double yMin = ScaleInspector.this.plotPanel.getPreferredYMin();
                ScaleInspector.this.plotPanel.setPreferredMinMaxY(yMin, ScaleInspector.this.yMaxField.getValue());
                ScaleInspector.this.plotPanel.repaint();
                ScaleInspector.this.updateDisplay();
                ScaleInspector.this.yMaxField.selectAll();
            }
        });
        this.yMaxField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ScaleInspector.this.yMaxField.selectAll();
            }

            public void focusLost(FocusEvent e) {
                double yMin = ScaleInspector.this.plotPanel.getPreferredYMin();
                ScaleInspector.this.plotPanel.setPreferredMinMaxY(yMin, ScaleInspector.this.yMaxField.getValue());
                ScaleInspector.this.plotPanel.repaint();
                ScaleInspector.this.updateDisplay();
            }
        });
        JPanel xPanel = new JPanel(new GridLayout(3, 1));
        String title = "x";
        xPanel.setBorder(BorderFactory.createTitledBorder(title));
        JPanel yPanel = new JPanel(new GridLayout(3, 1));
        title = "y";
        yPanel.setBorder(BorderFactory.createTitledBorder(title));
        this.dataPanel = new JPanel(new GridLayout(2, 1));
        this.dataPanel.setBorder(BorderFactory.createEtchedBorder());
        controlPanel.add((Component)this.dataPanel, "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.xMinLabel);
        box.add(this.xMinField);
        xPanel.add(this.xAutoscaleCheckBox);
        xPanel.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.xMaxLabel);
        box.add(this.xMaxField);
        xPanel.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.yMinLabel);
        box.add(this.yMinField);
        yPanel.add(this.yAutoscaleCheckBox);
        yPanel.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.yMaxLabel);
        box.add(this.yMaxField);
        yPanel.add(box);
        this.dataPanel.add(xPanel);
        this.dataPanel.add(yPanel);
        this.xMinLabel.setAlignmentX(1.0f);
        this.xMaxLabel.setAlignmentX(1.0f);
        this.yMinLabel.setAlignmentX(1.0f);
        this.yMaxLabel.setAlignmentX(1.0f);
        this.xMinField.setAlignmentX(1.0f);
        this.xMaxField.setAlignmentX(1.0f);
        this.yMinField.setAlignmentX(1.0f);
        this.yMaxField.setAlignmentX(1.0f);
        this.xAutoscaleCheckBox.setAlignmentX(1.0f);
        this.yAutoscaleCheckBox.setAlignmentX(1.0f);
        this.cancelButton = new JButton(DialogsRes.SCALE_CANCEL);
        this.cancelButton.setForeground(new Color(0, 0, 102));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScaleInspector.this.revert();
                ((Component)ScaleInspector.this).setVisible(false);
            }
        });
        this.okButton = new JButton(DialogsRes.SCALE_OK);
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((Component)ScaleInspector.this).setVisible(false);
            }
        });
        JPanel buttonbar = new JPanel();
        controlPanel.add((Component)buttonbar, "South");
        buttonbar.add(this.okButton);
    }

    public void updateDisplay() {
        this.xAutoscaleCheckBox.setSelected(this.plotPanel.isAutoscaleX());
        this.xMinField.setEnabled(!this.xAutoscaleCheckBox.isSelected());
        this.xMaxField.setEnabled(!this.xAutoscaleCheckBox.isSelected());
        this.xMinField.setValue(this.plotPanel.getPreferredXMin());
        this.xMaxField.setValue(this.plotPanel.getPreferredXMax());
        this.yAutoscaleCheckBox.setSelected(this.plotPanel.isAutoscaleY());
        this.yMinField.setEnabled(!this.yAutoscaleCheckBox.isSelected());
        this.yMaxField.setEnabled(!this.yAutoscaleCheckBox.isSelected());
        this.yMinField.setValue(this.plotPanel.getPreferredYMin());
        this.yMaxField.setValue(this.plotPanel.getPreferredYMax());
    }

    private void revert() {
    }
}

